/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.runtime.hotspot;

import java.lang.reflect.Method;
import jdk.vm.ci.code.InstalledCode;
import jdk.vm.ci.hotspot.HotSpotNmethod;
import jdk.vm.ci.hotspot.HotSpotSpeculationLog;
import jdk.vm.ci.meta.SpeculationLog;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.RootNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.runtime.EngineData;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.runtime.OptimizedCallTarget;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.runtime.hotspot.HotSpotTruffleRuntimeServices;

public final class HotSpotOptimizedCallTarget
extends OptimizedCallTarget {
    private static final InstalledCode INVALID_CODE = new InstalledCode(null);
    private InstalledCode installedCode = INVALID_CODE;
    private static final Method setSpeculationLog;
    private static final Method invalidateInstalledCode;

    public HotSpotOptimizedCallTarget(OptimizedCallTarget sourceCallTarget, RootNode rootNode) {
        super(sourceCallTarget, rootNode);
    }

    public HotSpotOptimizedCallTarget(EngineData engine) {
        super(engine);
    }

    public void setInstalledCode(InstalledCode code) {
        assert (code != null) : "code must never become null";
        InstalledCode oldCode = this.installedCode;
        if (oldCode == code) {
            return;
        }
        if (oldCode != INVALID_CODE && invalidateInstalledCode != null) {
            try {
                invalidateInstalledCode.invoke((Object)oldCode, false);
            }
            catch (Error e) {
                throw e;
            }
            catch (Throwable throwable) {
                throw new InternalError(throwable);
            }
        }
        if (code instanceof HotSpotNmethod) {
            HotSpotNmethod nmethod = (HotSpotNmethod)code;
            if (nmethod.isDefault()) {
                throw new IllegalArgumentException("Cannot install a default nmethod for a " + this.getClass().getSimpleName());
            }
            this.tetherSpeculationLog(nmethod);
        }
        this.installedCode = code;
    }

    private void tetherSpeculationLog(HotSpotNmethod nmethod) throws Error, InternalError {
        HotSpotSpeculationLog log;
        if (setSpeculationLog != null && this.speculationLog instanceof HotSpotSpeculationLog && (log = (HotSpotSpeculationLog)this.speculationLog).managesFailedSpeculations() && log.hasSpeculations()) {
            try {
                setSpeculationLog.invoke((Object)nmethod, log);
            }
            catch (Error e) {
                throw e;
            }
            catch (Throwable throwable) {
                throw new InternalError(throwable);
            }
        }
    }

    @Override
    public boolean isValid() {
        return this.installedCode.isValid();
    }

    @Override
    public boolean isValidLastTier() {
        InstalledCode code = this.installedCode;
        return code.isValid() && code.getName().endsWith("#2");
    }

    @Override
    public long getCodeAddress() {
        return this.installedCode.getStart();
    }

    @Override
    public SpeculationLog getCompilationSpeculationLog() {
        return HotSpotTruffleRuntimeServices.getCompilationSpeculationLog(this);
    }

    static {
        Method method = null;
        try {
            method = HotSpotNmethod.class.getDeclaredMethod("setSpeculationLog", HotSpotSpeculationLog.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        setSpeculationLog = method;
        method = null;
        try {
            method = InstalledCode.class.getDeclaredMethod("invalidate", Boolean.TYPE);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        invalidateInstalledCode = method;
    }
}

