/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.runtime.debug;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.function.Supplier;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.frame.Frame;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.NodeVisitor;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.source.SourceSection;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.compiler.TruffleCompilerListener;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.runtime.AbstractCompilationTask;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.runtime.AbstractGraalTruffleRuntimeListener;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.runtime.CompilationTask;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.runtime.FixedPointMath;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.runtime.OptimizedCallTarget;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.runtime.OptimizedDirectCallNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.runtime.OptimizedTruffleRuntime;

public final class TraceCompilationListener
extends AbstractGraalTruffleRuntimeListener {
    private static final Method GET_COMPILATION_ID_METHOD;
    private final ThreadLocal<Times> currentCompilation = new ThreadLocal();
    public static final String TIER_FORMAT = "Tier %d";
    private static final String QUEUE_FORMAT = "Queue: Size %4d Change %c%-2d Load %5.2f Time %5dus                                   ";
    private static final String TARGET_FORMAT = "engine=%-2d id=%-5d %-50s ";
    public static final String COUNT_THRESHOLD_FORMAT = "Count/Thres  %9d/%9d";
    private static final DateTimeFormatter TIME_FORMATTER;
    private static final String QUEUED_FORMAT = "opt queued engine=%-2d id=%-5d %-50s |Tier %d|Count/Thres  %9d/%9d|Queue: Size %4d Change %c%-2d Load %5.2f Time %5dus                                   |UTC %s|Src %s";
    private static final String UNQUEUED_FORMAT = "opt unque. engine=%-2d id=%-5d %-50s |Tier %d|Count/Thres  %9d/%9d|Queue: Size %4d Change %c%-2d Load %5.2f Time %5dus                                   |UTC %s|Src %s|Reason %s";
    private static final String START_FORMAT = "opt start  engine=%-2d id=%-5d %-50s |Tier %d|Priority %9d|Rate %.6f|Queue: Size %4d Change %c%-2d Load %5.2f Time %5dus                                   |UTC %s|Src %s|Bonuses %s";
    private static final String DONE_FORMAT = "opt done   engine=%-2d id=%-5d %-50s |Tier %d|Time %18s|AST %4d|Inlined %3dY %3dN|IR %6d/%6d|CodeSize %7d|Addr 0x%012x|CompId %-7s|UTC %s|Src %s";
    private static final String FAILED_FORMAT = "opt failed engine=%-2d id=%-5d %-50s |Tier %d|Time %18s|Reason: %s|UTC %s|Src %s";
    private static final String PADDING = "                                                                                                                              ";
    private static final String INV_FORMAT = "opt inval. engine=%-2d id=%-5d %-50s                                                                                                                                |UTC %s|Src %s|Reason %s";
    private static final String DEOPT_FORMAT = "opt deopt  engine=%-2d id=%-5d %-50s |                                                                                                                              |UTC %s|Src %s";

    private TraceCompilationListener(OptimizedTruffleRuntime runtime) {
        super(runtime);
    }

    public static void install(OptimizedTruffleRuntime runtime) {
        runtime.addListener(new TraceCompilationListener(runtime));
    }

    @Override
    public void onCompilationQueued(OptimizedCallTarget target, int tier) {
        if (target.engine.traceCompilationDetails) {
            int callAndLoopThreshold = target.engine.multiTier && tier == 2 ? target.engine.callAndLoopThresholdInFirstTier : target.engine.callAndLoopThresholdInInterpreter;
            int scale = this.runtime.compilationThresholdScale();
            this.log(target, String.format(QUEUED_FORMAT, target.engineId(), target.id, this.safeTargetName(target), tier, target.getCallAndLoopCount(), OptimizedCallTarget.scaledThreshold(callAndLoopThreshold), this.runtime.getCompilationQueueSize(), Character.valueOf('+'), 1, FixedPointMath.toDouble(scale), 0, TIME_FORMATTER.format(ZonedDateTime.now()), TraceCompilationListener.formatSourceSection(this.safeSourceSection(target))));
        }
    }

    @Override
    public void onCompilationDequeued(OptimizedCallTarget target, Object source, CharSequence reason, int tier) {
        if (target.engine.traceCompilationDetails) {
            int callAndLoopThreshold = tier == 1 ? target.engine.callAndLoopThresholdInInterpreter : target.engine.callAndLoopThresholdInFirstTier;
            int scale = this.runtime.compilationThresholdScale();
            this.log(target, String.format(UNQUEUED_FORMAT, target.engineId(), target.id, this.safeTargetName(target), tier, target.getCallAndLoopCount(), FixedPointMath.multiply(scale, callAndLoopThreshold), this.runtime.getCompilationQueueSize(), Character.valueOf(' '), 0, FixedPointMath.toDouble(scale), 0, TIME_FORMATTER.format(ZonedDateTime.now()), TraceCompilationListener.formatSourceSection(this.safeSourceSection(target)), reason));
        }
    }

    @Override
    public void onCompilationFailed(OptimizedCallTarget target, String reason, boolean bailout, boolean permanentBailout, int tier, Supplier<String> lazyStackTrace) {
        if (target.engine.traceCompilation || target.engine.traceCompilationDetails) {
            Times compilation = this.currentCompilation.get();
            if (!compilation.partialEvaluationSuccess) {
                compilation.timePartialEvaluationFinished = System.nanoTime();
            }
            if (!TraceCompilationListener.isPermanentFailure(bailout, permanentBailout)) {
                this.onCompilationDequeued(target, null, "Non permanent bailout: " + reason, tier);
            } else {
                this.log(target, String.format(FAILED_FORMAT, target.engineId(), target.id, this.safeTargetName(target), tier, this.compilationTime(), reason, TIME_FORMATTER.format(ZonedDateTime.now()), TraceCompilationListener.formatSourceSection(this.safeSourceSection(target))));
            }
            this.currentCompilation.remove();
        }
    }

    @Override
    public void onCompilationStarted(OptimizedCallTarget target, AbstractCompilationTask task) {
        if (target.engine.traceCompilationDetails) {
            String appliedBonuses;
            int queueChange;
            double rate;
            long time;
            double weight;
            if (task instanceof CompilationTask) {
                CompilationTask t = (CompilationTask)task;
                weight = t.weight();
                time = t.time();
                rate = t.rate();
                queueChange = t.queueChange();
                appliedBonuses = String.join((CharSequence)", ", t.bonusDescriptors());
            } else {
                weight = 0.0;
                time = 0L;
                rate = Double.NaN;
                queueChange = 0;
                appliedBonuses = "";
            }
            this.log(target, String.format(START_FORMAT, target.engineId(), target.id, this.safeTargetName(target), task.tier(), (int)weight, rate, this.runtime.getCompilationQueueSize(), Character.valueOf(queueChange >= 0 ? (char)'+' : '-'), Math.abs(queueChange), FixedPointMath.toDouble(this.runtime.compilationThresholdScale()), time / 1000L, TIME_FORMATTER.format(ZonedDateTime.now()), TraceCompilationListener.formatSourceSection(this.safeSourceSection(target)), appliedBonuses));
        }
        if (target.engine.traceCompilation || target.engine.traceCompilationDetails) {
            this.currentCompilation.set(new Times());
        }
    }

    private void log(OptimizedCallTarget target, String message) {
        this.runtime.log(target, message);
    }

    @Override
    public void onCompilationDeoptimized(OptimizedCallTarget target, Frame frame) {
        if (target.engine.traceCompilation || target.engine.traceCompilationDetails) {
            this.log(target, String.format(DEOPT_FORMAT, target.engineId(), target.id, this.safeTargetName(target), TIME_FORMATTER.format(ZonedDateTime.now()), TraceCompilationListener.formatSourceSection(this.safeSourceSection(target))));
        }
    }

    @Override
    public void onCompilationTruffleTierFinished(OptimizedCallTarget target, AbstractCompilationTask task, TruffleCompilerListener.GraphInfo graph) {
        if (target.engine.traceCompilation || target.engine.traceCompilationDetails) {
            Times current = this.currentCompilation.get();
            current.partialEvaluationSuccess = true;
            current.timePartialEvaluationFinished = System.nanoTime();
            current.nodeCountPartialEval = graph.getNodeCount();
        }
    }

    @Override
    public void onCompilationSuccess(OptimizedCallTarget target, AbstractCompilationTask task, TruffleCompilerListener.GraphInfo graph, TruffleCompilerListener.CompilationResultInfo result) {
        if (!target.engine.traceCompilation && !target.engine.traceCompilationDetails) {
            return;
        }
        Times compilation = this.currentCompilation.get();
        int[] inlinedAndDispatched = this.inlinedAndDispatched(target, task);
        this.log(target, String.format(DONE_FORMAT, target.engineId(), target.id, this.safeTargetName(target), task.tier(), this.compilationTime(), target.getNonTrivialNodeCount(), inlinedAndDispatched[0], inlinedAndDispatched[1], compilation.nodeCountPartialEval, graph == null ? 0 : graph.getNodeCount(), result == null ? 0 : result.getTargetCodeSize(), target.getCodeAddress(), result == null ? "n/a" : TraceCompilationListener.getCompilationId(result), TIME_FORMATTER.format(ZonedDateTime.now()), TraceCompilationListener.formatSourceSection(this.safeSourceSection(target))));
        this.currentCompilation.remove();
    }

    static String getCompilationId(TruffleCompilerListener.CompilationResultInfo result) {
        String toRet = "n/a";
        if (GET_COMPILATION_ID_METHOD != null) {
            try {
                long compilationId = (Long)GET_COMPILATION_ID_METHOD.invoke((Object)result, new Object[0]);
                if (compilationId >= 0L) {
                    toRet = String.valueOf(compilationId);
                }
            }
            catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                // empty catch block
            }
        }
        return toRet;
    }

    private SourceSection safeSourceSection(OptimizedCallTarget target) {
        try {
            return target.getRootNode().getSourceSection();
        }
        catch (Throwable throwable) {
            this.log(target, "Failed to call RootNode.getSourceSection(): " + String.valueOf(throwable));
            return null;
        }
    }

    private String safeTargetName(OptimizedCallTarget target) {
        try {
            return target.getName();
        }
        catch (Throwable throwable) {
            this.log(target, "Failed to call RootNode.getName(): " + String.valueOf(throwable));
            return null;
        }
    }

    private int[] inlinedAndDispatched(OptimizedCallTarget target, AbstractCompilationTask task) {
        try {
            int inlinedCalls;
            int calls = 0;
            if (task == null) {
                CallCountVisitor visitor = new CallCountVisitor();
                target.accept(visitor);
                calls = visitor.calls;
                inlinedCalls = 0;
            } else {
                calls = task.countCalls();
                inlinedCalls = task.countInlinedCalls();
            }
            int dispatchedCalls = calls - inlinedCalls;
            int[] inlinedAndDispatched = new int[]{inlinedCalls, dispatchedCalls};
            return inlinedAndDispatched;
        }
        catch (Throwable throwable) {
            this.log(target, "Failed to inlined and dispatched counts: " + String.valueOf(throwable));
            return null;
        }
    }

    private String compilationTime() {
        long timeCompilationFinished = System.nanoTime();
        Times compilation = this.currentCompilation.get();
        return String.format("%4.0f(%4.0f+%-4.0f)ms", (double)(timeCompilationFinished - compilation.timeCompilationStarted) / 1000000.0, (double)(compilation.timePartialEvaluationFinished - compilation.timeCompilationStarted) / 1000000.0, (double)(timeCompilationFinished - compilation.timePartialEvaluationFinished) / 1000000.0);
    }

    private static String formatSourceSection(SourceSection sourceSection) {
        if (sourceSection == null || sourceSection.getSource() == null) {
            return "n/a";
        }
        return String.format("%s:%d 0x%x", sourceSection.getSource().getName(), sourceSection.getStartLine(), sourceSection.getSource().hashCode());
    }

    @Override
    public void onCompilationInvalidated(OptimizedCallTarget target, Object source, CharSequence reason) {
        if (target.engine.traceCompilation || target.engine.traceCompilationDetails) {
            this.log(target, String.format(INV_FORMAT, target.engineId(), target.id, this.safeTargetName(target), TIME_FORMATTER.format(ZonedDateTime.now()), TraceCompilationListener.formatSourceSection(this.safeSourceSection(target)), reason));
        }
    }

    private static boolean isPermanentFailure(boolean bailout, boolean permanentBailout) {
        return !bailout || permanentBailout;
    }

    static {
        Method getCompilationIdMethod = null;
        try {
            getCompilationIdMethod = TruffleCompilerListener.CompilationResultInfo.class.getMethod("getCompilationId", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        GET_COMPILATION_ID_METHOD = getCompilationIdMethod;
        TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSS").withZone(ZoneId.of("UTC"));
    }

    private static final class Times {
        final long timeCompilationStarted = System.nanoTime();
        boolean partialEvaluationSuccess;
        long timePartialEvaluationFinished;
        long nodeCountPartialEval;

        private Times() {
        }
    }

    static final class CallCountVisitor
    implements NodeVisitor {
        int calls = 0;

        CallCountVisitor() {
        }

        @Override
        public boolean visit(Node node) {
            if (node instanceof OptimizedDirectCallNode) {
                ++this.calls;
            }
            return true;
        }
    }
}

