/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.ast;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.buffer.CompilationBuffer;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.ast.Group;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.ast.RegexAST;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.ast.RegexASTNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.ast.Sequence;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.util.json.Json;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.util.json.JsonValue;

public final class ConditionalBackReferenceGroup
extends Group {
    private final int referencedGroupNumber;

    public ConditionalBackReferenceGroup(int referencedGroupNumber) {
        this.referencedGroupNumber = referencedGroupNumber;
    }

    private ConditionalBackReferenceGroup(ConditionalBackReferenceGroup copy) {
        super(copy);
        this.referencedGroupNumber = copy.referencedGroupNumber;
    }

    public int getReferencedGroupNumber() {
        return this.referencedGroupNumber;
    }

    @Override
    public ConditionalBackReferenceGroup copy(RegexAST ast) {
        return ast.register(new ConditionalBackReferenceGroup(this));
    }

    @Override
    public ConditionalBackReferenceGroup copyRecursive(RegexAST ast, CompilationBuffer compilationBuffer) {
        ConditionalBackReferenceGroup copy = this.copy(ast);
        for (Sequence s : this.getAlternatives()) {
            copy.add(s.copyRecursive(ast, compilationBuffer));
        }
        return copy;
    }

    @Override
    public boolean equalsSemantic(RegexASTNode obj, boolean ignoreQuantifier) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ConditionalBackReferenceGroup)) {
            return false;
        }
        ConditionalBackReferenceGroup o = (ConditionalBackReferenceGroup)obj;
        assert (this.size() == 2 && o.size() == 2);
        assert (this.getGroupNumber() == -1 && o.getGroupNumber() == -1);
        if (this.referencedGroupNumber != o.referencedGroupNumber || this.isLoop() != o.isLoop() || !ignoreQuantifier && !this.quantifierEquals(o)) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (this.getAlternatives().get(i).equalsSemantic(o.getAlternatives().get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public String toString() {
        return "(?(" + this.referencedGroupNumber + ")" + this.alternativesToString() + ")" + this.loopToString();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public JsonValue toJson() {
        return super.toJson("ConditionalBackReferenceGroup").append(Json.prop("referencedGroupNumber", this.referencedGroupNumber), Json.prop("isLoop", this.isLoop()), Json.prop("isExpandedLoop", this.isExpandedQuantifier()), Json.prop("alternatives", this.getAlternatives()));
    }
}

