/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.nodes.nfa;

import java.util.Arrays;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerAsserts;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.buffer.IntRingBuffer;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.nfa.PureNFATransition;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.nodes.TRegexExecutorLocals;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.ast.Group;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.util.MathUtil;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.util.BitSets;

public final class TRegexBacktrackingNFAExecutorLocals
extends TRegexExecutorLocals {
    private static final int MULTI_CHAR_EXPANSION_LENGTH_POWER_OF_2 = MathUtil.log2ceil(4);
    private static final int FLAG_MATCH_END_ASSERTION = 1;
    private final int stackFrameSize;
    private final int nQuantifierCounts;
    private final int nZeroWidthQuantifiers;
    private final int[] zeroWidthTermEnclosedCGLow;
    private final int[] zeroWidthQuantifierCGOffsets;
    private final int[] stackFrameBuffer;
    private final int stackBase;
    private final Stack stack;
    private int sp;
    private final int[] result;
    private final long[] transitionBitSet;
    private final boolean trackLastGroup;
    private final boolean dontOverwriteLastGroup;
    private final boolean recursiveBackReferences;
    private final boolean matchBoundaryAssertions;
    private int lastResultSp = -1;
    private int lastResultIndex = -1;
    private int lastInnerLiteralIndex;
    private int lastInitialStateIndex;
    private final IntRingBuffer backrefMultiCharExpansionBufferA;
    private final IntRingBuffer backrefMultiCharExpansionBufferB;

    private TRegexBacktrackingNFAExecutorLocals(TruffleString input, int fromIndex, int maxIndex, int regionFrom, int regionTo, int index, int nCaptureGroups, int nQuantifiers, int nZeroWidthQuantifiers, int[] zeroWidthTermEnclosedCGLow, int[] zeroWidthQuantifierCGOffsets, int[] stackFrameBuffer, Stack stack, int stackBase, int stackFrameSize, long[] transitionBitSet, boolean trackLastGroup, boolean dontOverwriteLastGroup, boolean recursiveBackReferences, boolean matchBoundaryAssertions, IntRingBuffer backrefMultiCharExpansionBufferA, IntRingBuffer backrefMultiCharExpansionBufferB) {
        super(input, fromIndex, maxIndex, regionFrom, regionTo, index);
        this.stackFrameSize = stackFrameSize;
        this.nQuantifierCounts = nQuantifiers;
        this.nZeroWidthQuantifiers = nZeroWidthQuantifiers;
        this.zeroWidthTermEnclosedCGLow = zeroWidthTermEnclosedCGLow;
        this.zeroWidthQuantifierCGOffsets = zeroWidthQuantifierCGOffsets;
        this.stackFrameBuffer = stackFrameBuffer;
        this.stack = stack;
        this.stackBase = stackBase;
        this.sp = stackBase;
        this.result = new int[nCaptureGroups * 2 + (trackLastGroup ? 1 : 0)];
        this.transitionBitSet = transitionBitSet;
        this.trackLastGroup = trackLastGroup;
        this.dontOverwriteLastGroup = dontOverwriteLastGroup;
        this.recursiveBackReferences = recursiveBackReferences;
        this.matchBoundaryAssertions = matchBoundaryAssertions;
        this.backrefMultiCharExpansionBufferA = backrefMultiCharExpansionBufferA;
        this.backrefMultiCharExpansionBufferB = backrefMultiCharExpansionBufferB;
    }

    public static TRegexBacktrackingNFAExecutorLocals create(TruffleString input, int fromIndex, int maxIndex, int regionFrom, int regionTo, int index, int nCaptureGroups, int nQuantifiers, int nZeroWidthQuantifiers, int[] zeroWidthTermEnclosedCGLow, int[] zeroWidthQuantifierCGOffsets, boolean allocateStackFrameBuffer, int maxNTransitions, boolean trackLastGroup, boolean dontOverwriteLastGroup, boolean recursiveBackrefs, boolean backrefMultiCharExpansion, boolean matchBoundaryAssertions) {
        int stackFrameSize = TRegexBacktrackingNFAExecutorLocals.getStackFrameSize(nCaptureGroups, nQuantifiers, nZeroWidthQuantifiers, zeroWidthQuantifierCGOffsets, trackLastGroup, recursiveBackrefs, matchBoundaryAssertions);
        TRegexBacktrackingNFAExecutorLocals ret = new TRegexBacktrackingNFAExecutorLocals(input, fromIndex, maxIndex, regionFrom, regionTo, index, nCaptureGroups, nQuantifiers, nZeroWidthQuantifiers, zeroWidthTermEnclosedCGLow, zeroWidthQuantifierCGOffsets, allocateStackFrameBuffer ? new int[stackFrameSize] : null, new Stack(new int[stackFrameSize * 4]), 0, stackFrameSize, BitSets.createBitSetArray(maxNTransitions), trackLastGroup, dontOverwriteLastGroup, recursiveBackrefs, matchBoundaryAssertions, backrefMultiCharExpansion ? new IntRingBuffer(MULTI_CHAR_EXPANSION_LENGTH_POWER_OF_2) : null, backrefMultiCharExpansion ? new IntRingBuffer(MULTI_CHAR_EXPANSION_LENGTH_POWER_OF_2) : null);
        ret.setIndex(fromIndex);
        ret.clearCaptureGroups();
        if (recursiveBackrefs) {
            ret.clearRecursiveCaptureGroups();
        }
        return ret;
    }

    private int[] stack() {
        return this.stack.stack;
    }

    private static int getStackFrameSize(int nCaptureGroups, int nQuantifiers, int nZeroWidthQuantifiers, int[] zeroWidthQuantifierCGOffsets, boolean trackLastGroup, boolean recursiveBackrefs, boolean matchBoundaryAssertions) {
        return 2 + (matchBoundaryAssertions ? 1 : 0) + nCaptureGroups * (recursiveBackrefs ? 3 : 2) + (trackLastGroup ? 1 : 0) + nQuantifiers + nZeroWidthQuantifiers + zeroWidthQuantifierCGOffsets[zeroWidthQuantifierCGOffsets.length - 1];
    }

    public TRegexBacktrackingNFAExecutorLocals createSubNFALocals(boolean newDontOverwriteLastGroup) {
        this.dupFrame();
        if (this.trackLastGroup && newDontOverwriteLastGroup) {
            this.stack()[this.offsetLastGroup() + this.stackFrameSize] = -1;
        }
        return this.newSubLocals(newDontOverwriteLastGroup);
    }

    public TRegexBacktrackingNFAExecutorLocals createSubNFALocals(PureNFATransition t, boolean newDontOverwriteLastGroup) {
        this.dupFrame();
        if (this.trackLastGroup && newDontOverwriteLastGroup) {
            this.stack()[this.offsetLastGroup() + this.stackFrameSize] = -1;
        }
        t.getGroupBoundaries().applyExploded(this.stack(), this.offsetCaptureGroups() + this.stackFrameSize, this.offsetLastGroup() + this.stackFrameSize, this.getIndex(), this.trackLastGroup, this.dontOverwriteLastGroup);
        return this.newSubLocals(newDontOverwriteLastGroup);
    }

    private TRegexBacktrackingNFAExecutorLocals newSubLocals(boolean newDontOverwriteLastGroup) {
        TRegexBacktrackingNFAExecutorLocals locals = new TRegexBacktrackingNFAExecutorLocals(this.getInput(), this.getFromIndex(), this.getMaxIndex(), this.getRegionFrom(), this.getRegionTo(), this.getIndex(), this.result.length / 2, this.nQuantifierCounts, this.nZeroWidthQuantifiers, this.zeroWidthTermEnclosedCGLow, this.zeroWidthQuantifierCGOffsets, this.stackFrameBuffer, this.stack, this.sp + this.stackFrameSize, this.stackFrameSize, this.transitionBitSet, this.trackLastGroup, newDontOverwriteLastGroup, this.recursiveBackReferences, this.matchBoundaryAssertions, this.backrefMultiCharExpansionBufferA, this.backrefMultiCharExpansionBufferB);
        if (this.matchBoundaryAssertions) {
            locals.clearMatchEndAssertionTraversed();
        }
        return locals;
    }

    private int offsetIP() {
        return this.sp + 1;
    }

    private int offsetFlags() {
        assert (this.matchBoundaryAssertions);
        return this.sp + 2;
    }

    private int offsetCaptureGroups() {
        return this.offsetCaptureGroups(this.sp);
    }

    private int offsetCaptureGroups(int framePointer) {
        return framePointer + 2 + (this.matchBoundaryAssertions ? 1 : 0);
    }

    private int offsetLastGroup() {
        return this.trackLastGroup ? this.offsetCaptureGroups(this.sp) + this.result.length - 1 : -1;
    }

    private int offsetQuantifierCounts() {
        return this.offsetCaptureGroups(this.sp) + this.result.length;
    }

    private int offsetZeroWidthQuantifierIndices() {
        return this.offsetCaptureGroups(this.sp) + this.result.length + this.nQuantifierCounts;
    }

    private int offsetZeroWidthQuantifierCG() {
        return this.offsetCaptureGroups(this.sp) + this.result.length + this.nQuantifierCounts + this.nZeroWidthQuantifiers;
    }

    private int offsetRecursiveBackReferences() {
        return this.offsetCaptureGroups(this.sp) + this.result.length + this.nQuantifierCounts + this.nZeroWidthQuantifiers + this.zeroWidthQuantifierCGOffsets[this.zeroWidthQuantifierCGOffsets.length - 1];
    }

    private int offsetQuantifierCount(int quantifierIndex) {
        CompilerAsserts.partialEvaluationConstant(quantifierIndex);
        return this.offsetQuantifierCounts() + quantifierIndex;
    }

    private int offsetZeroWidthQuantifierIndex(int quantifierZeroWidthIndex) {
        CompilerAsserts.partialEvaluationConstant(quantifierZeroWidthIndex);
        return this.offsetZeroWidthQuantifierIndices() + quantifierZeroWidthIndex;
    }

    private int offsetZeroWidthQuantifierCG(int zeroWidthIndex) {
        CompilerAsserts.partialEvaluationConstant(zeroWidthIndex);
        return this.offsetZeroWidthQuantifierCG() + this.zeroWidthQuantifierCGOffsets[zeroWidthIndex];
    }

    public void apply(PureNFATransition t, int index) {
        t.getGroupBoundaries().applyExploded(this.stack(), this.offsetCaptureGroups(), this.offsetLastGroup(), index, this.trackLastGroup, this.dontOverwriteLastGroup);
    }

    public void resetToInitialState() {
        this.clearCaptureGroups();
        this.clearQuantifierCounts();
        if (this.recursiveBackReferences) {
            this.clearRecursiveCaptureGroups();
        }
        if (this.matchBoundaryAssertions) {
            this.clearMatchEndAssertionTraversed();
        }
    }

    private void clearCaptureGroups() {
        Arrays.fill(this.stack(), this.offsetCaptureGroups(), this.offsetCaptureGroups() + this.result.length, -1);
    }

    private void clearRecursiveCaptureGroups() {
        Arrays.fill(this.stack(), this.offsetRecursiveBackReferences(), this.offsetRecursiveBackReferences() + this.result.length, -1);
    }

    private void clearQuantifierCounts() {
        Arrays.fill(this.stack(), this.offsetQuantifierCounts(), this.offsetQuantifierCounts() + this.nQuantifierCounts, 0);
    }

    public void push() {
        this.sp += this.stackFrameSize;
    }

    public void pushFrame(int[] frame) {
        this.ensureSize(this.sp + 2 * this.stackFrameSize);
        this.push();
        this.writeFrame(frame);
    }

    public void readFrame(int[] to) {
        assert (to == this.stackFrameBuffer || to.length >= this.stackFrameSize);
        System.arraycopy(this.stack(), this.sp, to, 0, this.stackFrameSize);
    }

    public void writeFrame(int[] from) {
        System.arraycopy(from, 0, this.stack(), this.sp, this.stackFrameSize);
    }

    public void dupFrame() {
        this.dupFrame(1);
    }

    public void dupFrame(int n) {
        int minSize = this.sp + this.stackFrameSize * (n + 1);
        this.ensureSize(minSize);
        int targetFrame = this.sp;
        for (int i = 0; i < n; ++i) {
            System.arraycopy(this.stack(), this.sp, this.stack(), targetFrame += this.stackFrameSize, this.stackFrameSize);
        }
    }

    private void ensureSize(int minSize) {
        if (this.stack().length < minSize) {
            int newLength;
            for (newLength = this.stack().length << 1; newLength < minSize; newLength <<= 1) {
            }
            this.stack.stack = Arrays.copyOf(this.stack(), newLength);
        }
    }

    public void pushResult(PureNFATransition t, int index) {
        t.getGroupBoundaries().applyExploded(this.result, 0, this.result.length - 1, index, this.trackLastGroup, this.dontOverwriteLastGroup);
        this.pushResult();
    }

    public void pushResult() {
        this.lastResultSp = this.sp;
        this.lastResultIndex = this.getIndex();
    }

    public void setResult() {
        System.arraycopy(this.stack(), this.offsetCaptureGroups(), this.result, 0, this.result.length);
    }

    public boolean canPopResult() {
        return this.lastResultSp == this.sp;
    }

    public int[] popResult() {
        if (this.lastResultSp < 0) {
            return null;
        }
        this.setIndex(this.lastResultIndex);
        return this.result;
    }

    public boolean canPop() {
        return this.sp > this.stackBase;
    }

    public int pop() {
        assert (this.sp > this.stackBase);
        this.sp -= this.stackFrameSize;
        this.restoreIndex();
        return this.stack()[this.offsetIP()];
    }

    public void saveIndex(int index) {
        this.stack()[this.sp] = index;
    }

    public void restoreIndex() {
        this.setIndex(this.stack()[this.sp]);
    }

    public int getPc() {
        return this.stack()[this.offsetIP()];
    }

    public int setPc(int pc) {
        int n = pc;
        this.stack()[this.offsetIP()] = n;
        return n;
    }

    public void setMatchEndAssertionTraversed() {
        assert (this.matchBoundaryAssertions);
        this.setFlag(1);
    }

    public void clearMatchEndAssertionTraversed() {
        assert (this.matchBoundaryAssertions);
        this.clearFlag(1);
    }

    public boolean isMatchEndAssertionTraversed() {
        assert (this.matchBoundaryAssertions);
        return this.isFlagSet(1);
    }

    private void setFlag(int flag) {
        int[] nArray = this.stack();
        int n = this.offsetFlags();
        nArray[n] = nArray[n] | flag;
    }

    private void clearFlag(int flag) {
        int[] nArray = this.stack();
        int n = this.offsetFlags();
        nArray[n] = nArray[n] & ~flag;
    }

    private boolean isFlagSet(int flag) {
        return (this.stack()[this.offsetFlags()] & flag) != 0;
    }

    public int getCaptureGroupBoundary(int boundary) {
        return this.stack()[this.offsetCaptureGroups() + boundary];
    }

    public void setCaptureGroupBoundary(int boundary, int index) {
        this.stack()[this.offsetCaptureGroups() + boundary] = index;
    }

    public int getCaptureGroupStart(int groupNumber) {
        return this.getCaptureGroupBoundary(Group.groupNumberToBoundaryIndexStart(groupNumber));
    }

    public int getCaptureGroupEnd(int groupNumber) {
        return this.getCaptureGroupBoundary(Group.groupNumberToBoundaryIndexEnd(groupNumber));
    }

    public int getRecursiveCaptureGroupStart(int groupNumber) {
        return this.stack()[this.offsetRecursiveBackReferences() + groupNumber];
    }

    public void saveRecursiveBackrefGroupStart(int groupNumber) {
        this.stack()[this.offsetRecursiveBackReferences() + groupNumber] = this.getCaptureGroupStart(groupNumber);
    }

    public void overwriteCaptureGroups(int[] captureGroups) {
        assert (captureGroups.length == this.result.length);
        if (this.trackLastGroup) {
            System.arraycopy(captureGroups, 0, this.stack(), this.offsetCaptureGroups(), captureGroups.length - 1);
            this.setLastGroup(captureGroups[captureGroups.length - 1]);
        } else {
            System.arraycopy(captureGroups, 0, this.stack(), this.offsetCaptureGroups(), captureGroups.length);
        }
    }

    public void setLastGroup(int newLastGroup) {
        if (this.trackLastGroup && newLastGroup != -1 && (!this.dontOverwriteLastGroup || this.stack()[this.offsetLastGroup()] == -1)) {
            this.stack()[this.offsetLastGroup()] = newLastGroup;
        }
    }

    public int getQuantifierCount(int quantifierIndex) {
        return this.stack()[this.offsetQuantifierCount(quantifierIndex)];
    }

    public void setQuantifierCount(int quantifierIndex, int count) {
        this.stack()[this.offsetQuantifierCount((int)quantifierIndex)] = count;
    }

    public void incQuantifierCount(int quantifierIndex) {
        int[] nArray = this.stack();
        int n = this.offsetQuantifierCount(quantifierIndex);
        nArray[n] = nArray[n] + 1;
    }

    public int getZeroWidthQuantifierGuardIndex(int quantifierZeroWidthIndex) {
        return this.stack()[this.offsetZeroWidthQuantifierIndex(quantifierZeroWidthIndex)];
    }

    public void setZeroWidthQuantifierGuardIndex(int quantifierZeroWidthIndex) {
        this.stack()[this.offsetZeroWidthQuantifierIndex((int)quantifierZeroWidthIndex)] = this.getIndex();
    }

    public boolean isResultUnmodifiedByZeroWidthQuantifier(int quantifierZeroWidthIndex) {
        int start = this.offsetCaptureGroups() + 2 * this.zeroWidthTermEnclosedCGLow[quantifierZeroWidthIndex];
        int length = this.zeroWidthQuantifierCGOffsets[quantifierZeroWidthIndex + 1] - this.zeroWidthQuantifierCGOffsets[quantifierZeroWidthIndex];
        for (int i = 0; i < length; ++i) {
            if (this.stack()[this.offsetZeroWidthQuantifierCG(quantifierZeroWidthIndex) + i] == this.stack()[start + i]) continue;
            return false;
        }
        return true;
    }

    public void setZeroWidthQuantifierResults(int quantifierZeroWidthIndex) {
        int start = this.offsetCaptureGroups() + 2 * this.zeroWidthTermEnclosedCGLow[quantifierZeroWidthIndex];
        int length = this.zeroWidthQuantifierCGOffsets[quantifierZeroWidthIndex + 1] - this.zeroWidthQuantifierCGOffsets[quantifierZeroWidthIndex];
        System.arraycopy(this.stack(), start, this.stack(), this.offsetZeroWidthQuantifierCG(quantifierZeroWidthIndex), length);
    }

    public long[] getTransitionBitSet() {
        return this.transitionBitSet;
    }

    public int getLastInnerLiteralIndex() {
        return this.lastInnerLiteralIndex;
    }

    public void setLastInnerLiteralIndex(int i) {
        this.lastInnerLiteralIndex = i;
    }

    public int getLastInitialStateIndex() {
        return this.lastInitialStateIndex;
    }

    public void setLastInitialStateIndex(int i) {
        this.lastInitialStateIndex = i;
    }

    public int[] getStackFrameBuffer() {
        return this.stackFrameBuffer;
    }

    public IntRingBuffer getBackrefMultiCharExpansionBufferA() {
        return this.backrefMultiCharExpansionBufferA;
    }

    public IntRingBuffer getBackrefMultiCharExpansionBufferB() {
        return this.backrefMultiCharExpansionBufferB;
    }

    @CompilerDirectives.TruffleBoundary
    public void printStack(int curPc) {
        System.out.println("STACK SNAPSHOT");
        System.out.println("==============");
        for (int i = this.sp; i >= 0; i -= this.stackFrameSize) {
            int j;
            System.out.printf("pc: %d, i: %d,\n  cg: [", i == this.sp ? curPc : this.stack()[i + 1], this.stack()[i]);
            for (j = this.offsetCaptureGroups(); j < this.offsetQuantifierCounts(); ++j) {
                System.out.printf("%d, ", this.stack()[i + j - this.sp]);
            }
            System.out.print("],\n  quant: [");
            for (j = this.offsetQuantifierCounts(); j < this.offsetZeroWidthQuantifierIndices(); ++j) {
                System.out.printf("%d, ", this.stack()[i + j - this.sp]);
            }
            System.out.print("],\n  zwq-indices: [");
            for (j = this.offsetZeroWidthQuantifierIndices(); j < this.offsetZeroWidthQuantifierCG(); ++j) {
                System.out.printf("%d, ", this.stack()[i + j - this.sp]);
            }
            System.out.print("],\n  zwq-cg: {\n");
            for (int zwq = 0; zwq < this.nZeroWidthQuantifiers; ++zwq) {
                System.out.printf("    %d: [", zwq);
                for (int j2 = this.offsetZeroWidthQuantifierCG(zwq); j2 < this.offsetZeroWidthQuantifierCG(zwq + 1); ++j2) {
                    System.out.printf("%d, ", this.stack()[i + j2 - this.sp]);
                }
                System.out.print("],\n");
            }
            System.out.println("}\n");
        }
    }

    private static final class Stack {
        private int[] stack;

        Stack(int[] stack) {
            this.stack = stack;
        }
    }
}

