/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.nodes.dfa;

import java.util.Arrays;
import java.util.PrimitiveIterator;
import java.util.StringJoiner;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerAsserts;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.ExplodeLoop;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.automaton.TransitionOp;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.buffer.IntArrayBuffer;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.nodes.dfa.CounterTracker;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.nodes.dfa.CounterTrackerData;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.util.BitSets;

public class CounterTrackerBitSetWithOffset
extends CounterTracker {
    public static final int MAX_BITSET_SIZE = 16;
    private static final int N_FIELDS = 1;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final long[] set1Template;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final long[] initTemplate;
    private final int bitsetLength;
    private final int min;
    private final int max;
    private final int upperBound;
    private final int fixedOffset;

    protected CounterTrackerBitSetWithOffset(int min, int max, int numberOfSets, CounterTrackerData.Builder dataBuilder) {
        this.min = min;
        this.max = max;
        int n = this.upperBound = max == -1 ? this.min : this.max;
        assert (this.upperBound + 64 <= 65535);
        this.bitsetLength = BitSets.requiredArraySize(this.upperBound + 64);
        this.set1Template = new long[1 + this.bitsetLength];
        this.set1Template[0] = CounterTrackerBitSetWithOffset.setFields(0, 0, 1);
        this.set1Template[1] = 1L;
        int size = (this.bitsetLength + 1 + 1) * numberOfSets;
        this.fixedOffset = dataBuilder.getFixedDataSize();
        dataBuilder.requestFixedSize(size);
        this.initTemplate = new long[numberOfSets];
        for (int i = 0; i < numberOfSets; ++i) {
            this.initTemplate[i] = (long)(this.fixedOffset + numberOfSets) + (long)i * (long)(this.bitsetLength + 1);
        }
    }

    @Override
    public void init(long[] fixed, int[][] intArrays) {
        System.arraycopy(this.initTemplate, 0, fixed, this.fixedOffset, this.initTemplate.length);
    }

    private int mapId(int sId, long[] fixedData) {
        return (int)fixedData[this.fixedOffset + sId];
    }

    private static int getOffset(long fields) {
        return (int)fields;
    }

    private static int getMinBit(long fields) {
        return (int)(fields >>> 32) & 0xFFFF;
    }

    private static int getMaxBit(long fields) {
        return (int)(fields >>> 48);
    }

    private static long setFields(int minBit, int maxBit, int offset) {
        return (long)maxBit << 48 | (long)minBit << 32 | (long)offset;
    }

    @Override
    protected boolean anyLtMin(int sId, long[] fixedData, int[][] intArrays) {
        int mapId = this.mapId(sId, fixedData);
        long fields = fixedData[mapId];
        return CounterTrackerBitSetWithOffset.getOffset(fields) - CounterTrackerBitSetWithOffset.getMaxBit(fields) < this.min;
    }

    @Override
    protected boolean anyLtMax(int sId, long[] fixedData, int[][] intArrays) {
        int mapId = this.mapId(sId, fixedData);
        long fields = fixedData[mapId];
        return this.max == -1 || CounterTrackerBitSetWithOffset.getOffset(fields) - CounterTrackerBitSetWithOffset.getMaxBit(fields) < this.max;
    }

    @Override
    protected boolean anyGeMin(int sId, long[] fixedData, int[][] intArrays) {
        int mapId = this.mapId(sId, fixedData);
        long fields = fixedData[mapId];
        return CounterTrackerBitSetWithOffset.getOffset(fields) - CounterTrackerBitSetWithOffset.getMinBit(fields) >= this.min;
    }

    @ExplodeLoop
    protected void set1(int idDst, int modifier, long[] fixedData) {
        CompilerAsserts.partialEvaluationConstant(modifier);
        int dst = this.mapId(idDst, fixedData);
        if (modifier == 1) {
            System.arraycopy(this.set1Template, 0, fixedData, dst, this.set1Template.length);
        } else {
            assert (modifier == 2);
            long fields = fixedData[dst];
            assert (CounterTrackerBitSetWithOffset.getOffset(fields) >= 1 || !this.iterator(fixedData, idDst).hasNext());
            int offset = Math.max(1, CounterTrackerBitSetWithOffset.getOffset(fields));
            int bitIndex = offset - 1;
            int wordIndex = bitIndex >>> 6;
            assert (wordIndex < this.bitsetLength);
            int n = dst + 1 + wordIndex;
            fixedData[n] = fixedData[n] | 1L << (bitIndex & 0x3F);
            fixedData[dst] = CounterTrackerBitSetWithOffset.setFields(CounterTrackerBitSetWithOffset.getMinBit(fields), bitIndex, offset);
        }
    }

    protected void inc(int idSrc, int idDst, int modifier, long[] fixedData) {
        CompilerAsserts.partialEvaluationConstant(modifier);
        CompilerAsserts.partialEvaluationConstant(idSrc);
        CompilerAsserts.partialEvaluationConstant(idDst);
        boolean isSelfUpdate = idSrc == idDst;
        CompilerAsserts.partialEvaluationConstant(isSelfUpdate);
        int src = this.mapId(idSrc, fixedData);
        int dst = this.mapId(idDst, fixedData);
        long fieldsSrc = fixedData[src];
        int offsetSrc = CounterTrackerBitSetWithOffset.getOffset(fieldsSrc);
        int minBitSrc = CounterTrackerBitSetWithOffset.getMinBit(fieldsSrc);
        int maxBitSrc = CounterTrackerBitSetWithOffset.getMaxBit(fieldsSrc);
        long fieldsDst = fixedData[dst];
        int minBitDst = CounterTrackerBitSetWithOffset.getMinBit(fieldsDst);
        int copyIndexSrc = src;
        int copyLengthSrc = this.bitsetLength;
        if (CompilerDirectives.injectBranchProbability(0.25, offsetSrc >= this.upperBound + 63)) {
            ++copyIndexSrc;
            --copyLengthSrc;
            if (modifier == 1) {
                if (isSelfUpdate) {
                    CounterTrackerBitSetWithOffset.copy(fixedData, copyIndexSrc + 1, dst + 1, copyLengthSrc);
                    if (this.max == -1) {
                        int n = dst + 1;
                        fixedData[n] = fixedData[n] | 1L;
                    }
                }
                fixedData[dst + 1 + this.bitsetLength - 1] = 0L;
            }
            minBitSrc = this.max == -1 ? 0 : (minBitSrc -= 64);
            if ((maxBitSrc -= 64) < 0) {
                maxBitSrc = 0;
            }
            offsetSrc -= 63;
        } else {
            ++offsetSrc;
        }
        if (this.max != -1 && CompilerDirectives.injectBranchProbability(0.25, offsetSrc - minBitSrc > this.max)) {
            minBitSrc = modifier == 1 && isSelfUpdate ? this.recalculateMinBit(fixedData, dst, this.bitsetLength, offsetSrc) : this.recalculateMinBit(fixedData, copyIndexSrc, copyLengthSrc, offsetSrc);
        }
        if (modifier == 1) {
            fixedData[dst] = CounterTrackerBitSetWithOffset.setFields(minBitSrc, maxBitSrc, offsetSrc);
            if (!isSelfUpdate) {
                CounterTrackerBitSetWithOffset.copy(fixedData, copyIndexSrc + 1, dst + 1, copyLengthSrc);
                if (this.max == -1 && copyLengthSrc == this.bitsetLength - 1) {
                    int n = dst + 1;
                    fixedData[n] = fixedData[n] | 1L;
                }
            }
        } else {
            assert (modifier == 2);
            this.incUnion(fixedData, dst, offsetSrc, minBitSrc, maxBitSrc, minBitDst, copyIndexSrc, copyLengthSrc, isSelfUpdate);
        }
    }

    @ExplodeLoop
    private void incUnion(long[] fixedData, int dstArg, int offsetSrc, int minBitSrcArg, int maxBitSrcArg, int minBitDstArg, int copyIndexSrc, int copyLengthSrc, boolean isSelfUpdate) {
        int offsetMax;
        int delta;
        int biggerLength;
        int biggerSet;
        int smallerLength;
        int smallerSet;
        int lengthDst;
        int dst;
        int maxBitDst;
        int offsetDst;
        int minBitSrc = minBitSrcArg;
        int maxBitSrc = maxBitSrcArg;
        int minBitDst = minBitDstArg;
        if (isSelfUpdate) {
            offsetDst = offsetSrc - 1;
            maxBitDst = maxBitSrcArg;
            dst = copyIndexSrc;
            lengthDst = copyLengthSrc;
        } else {
            long fieldsDst = fixedData[dstArg];
            offsetDst = CounterTrackerBitSetWithOffset.getOffset(fieldsDst);
            maxBitDst = CounterTrackerBitSetWithOffset.getMaxBit(fieldsDst);
            dst = dstArg;
            lengthDst = this.bitsetLength;
        }
        if (offsetSrc < offsetDst) {
            smallerSet = copyIndexSrc;
            smallerLength = copyLengthSrc;
            biggerSet = dst;
            biggerLength = lengthDst;
            delta = offsetDst - offsetSrc;
            offsetMax = offsetDst;
            minBitSrc += delta;
            maxBitSrc += delta;
        } else {
            smallerSet = dst;
            smallerLength = lengthDst;
            biggerSet = copyIndexSrc;
            biggerLength = copyLengthSrc;
            delta = offsetSrc - offsetDst;
            offsetMax = offsetSrc;
            minBitDst += delta;
            maxBitDst += delta;
        }
        fixedData[dstArg] = CounterTrackerBitSetWithOffset.setFields(Math.min(minBitSrc, minBitDst), Math.max(maxBitSrc, maxBitDst), offsetMax);
        int iSmallerSet = smallerLength - 1 - (delta >>> 6);
        assert (iSmallerSet >= 0);
        int shiftAmountHi = delta & 0x3F;
        int shiftAmountLo = 64 - shiftAmountHi;
        long shiftLoMask = shiftAmountHi == 0 ? 0L : -1L;
        long bitSetChunkSmallerHi = fixedData[smallerSet + 1 + iSmallerSet--];
        assert (biggerLength == this.bitsetLength || biggerLength == this.bitsetLength - 1);
        if (biggerLength == this.bitsetLength) {
            long union;
            long bitSetChunkBigger = fixedData[biggerSet + 1 + this.bitsetLength - 1];
            long bitSetChunkSmallerLo = iSmallerSet < 0 ? 0L : fixedData[smallerSet + 1 + iSmallerSet--];
            fixedData[dstArg + 1 + this.bitsetLength - 1] = union = bitSetChunkBigger | (bitSetChunkSmallerLo & shiftLoMask) >>> shiftAmountLo | bitSetChunkSmallerHi << shiftAmountHi;
            bitSetChunkSmallerHi = bitSetChunkSmallerLo;
        }
        for (int i = this.bitsetLength - 2; i >= 0; --i) {
            long union;
            long bitSetChunkBigger = fixedData[biggerSet + 1 + i];
            long bitSetChunkSmallerLo = iSmallerSet < 0 ? 0L : fixedData[smallerSet + 1 + iSmallerSet--];
            fixedData[dstArg + 1 + i] = union = bitSetChunkBigger | (bitSetChunkSmallerLo & shiftLoMask) >>> shiftAmountLo | bitSetChunkSmallerHi << shiftAmountHi;
            bitSetChunkSmallerHi = bitSetChunkSmallerLo;
        }
        if (lengthDst == this.bitsetLength - 1) {
            if (this.max == -1) {
                int n = dstArg + 1;
                fixedData[n] = fixedData[n] | 1L;
            }
            if (isSelfUpdate) {
                fixedData[dstArg + 1 + this.bitsetLength - 1] = 0L;
            }
        }
    }

    private int recalculateMinBit(long[] fixedData, int src, int srcLength, int offsetSrc) {
        int i;
        assert (srcLength <= this.bitsetLength);
        long bitSetChunk = fixedData[src + 1];
        int delta = offsetSrc - this.max;
        assert (delta >= 0 && delta < 64) : delta;
        bitSetChunk >>>= delta;
        bitSetChunk <<= delta;
        for (i = 1; i < srcLength && bitSetChunk == 0L; ++i) {
            bitSetChunk = fixedData[src + 1 + i];
        }
        return (i - 1 << 6) + Long.numberOfTrailingZeros(bitSetChunk);
    }

    private static void copy(long[] fixedData, int src, int dst, int length) {
        System.arraycopy(fixedData, src, fixedData, dst, length);
    }

    protected void maintain(int idSrc, int idDst, int modifier, long[] fixedData) {
        CompilerAsserts.partialEvaluationConstant(modifier);
        if (idSrc == idDst) {
            return;
        }
        if (modifier == 3) {
            this.swapIndices(idSrc, idDst, fixedData);
        } else {
            int src = this.mapId(idSrc, fixedData);
            int dst = this.mapId(idDst, fixedData);
            if (modifier == 1) {
                CounterTrackerBitSetWithOffset.copy(fixedData, src, dst, this.bitsetLength + 1);
            } else {
                this.maintainUnion(fixedData, src, dst);
            }
        }
    }

    private void swapIndices(int idA, int idB, long[] fixedData) {
        long tmp = fixedData[this.fixedOffset + idA];
        fixedData[this.fixedOffset + idA] = fixedData[this.fixedOffset + idB];
        fixedData[this.fixedOffset + idB] = tmp;
    }

    @ExplodeLoop
    private void maintainUnion(long[] fixedData, int src, int dst) {
        int offsetMax;
        int delta;
        int biggerSet;
        int smallerSet;
        long fieldsSrc = fixedData[src];
        long fieldsDst = fixedData[dst];
        int offsetSrc = CounterTrackerBitSetWithOffset.getOffset(fieldsSrc);
        int offsetDst = CounterTrackerBitSetWithOffset.getOffset(fieldsDst);
        int minBitSrc = CounterTrackerBitSetWithOffset.getMinBit(fieldsSrc);
        int minBitDst = CounterTrackerBitSetWithOffset.getMinBit(fieldsDst);
        int maxBitSrc = CounterTrackerBitSetWithOffset.getMaxBit(fieldsSrc);
        int maxBitDst = CounterTrackerBitSetWithOffset.getMaxBit(fieldsDst);
        if (offsetSrc < offsetDst) {
            smallerSet = src;
            biggerSet = dst;
            delta = offsetDst - offsetSrc;
            offsetMax = offsetDst;
            minBitSrc += delta;
            maxBitSrc += delta;
        } else {
            smallerSet = dst;
            biggerSet = src;
            delta = offsetSrc - offsetDst;
            offsetMax = offsetSrc;
            minBitDst += delta;
            maxBitDst += delta;
        }
        fixedData[dst] = CounterTrackerBitSetWithOffset.setFields(Math.min(minBitSrc, minBitDst), Math.max(maxBitSrc, maxBitDst), offsetMax);
        int iSmallerSet = this.bitsetLength - 1 - (delta >>> 6);
        assert (iSmallerSet >= 0);
        int shiftAmountHi = delta & 0x3F;
        int shiftAmountLo = 64 - shiftAmountHi;
        long shiftLoMask = shiftAmountHi == 0 ? 0L : -1L;
        long bitSetChunkSmallerHi = fixedData[smallerSet + 1 + iSmallerSet--];
        for (int i = this.bitsetLength - 1; i >= 0; --i) {
            long union;
            long bitSetChunkBigger = fixedData[biggerSet + 1 + i];
            long bitSetChunkSmallerLo = iSmallerSet < 0 ? 0L : fixedData[smallerSet + 1 + iSmallerSet--];
            fixedData[dst + 1 + i] = union = bitSetChunkBigger | (bitSetChunkSmallerLo & shiftLoMask) >>> shiftAmountLo | bitSetChunkSmallerHi << shiftAmountHi;
            bitSetChunkSmallerHi = bitSetChunkSmallerLo;
        }
    }

    @Override
    public void apply(long op, long[] fixedData, int[][] intArrays) {
        CompilerAsserts.partialEvaluationConstant(op);
        int dst = TransitionOp.getTarget(op);
        int kind = TransitionOp.getKind(op);
        int modifier = TransitionOp.getModifier(op);
        CompilerAsserts.partialEvaluationConstant(dst);
        CompilerAsserts.partialEvaluationConstant(kind);
        CompilerAsserts.partialEvaluationConstant(modifier);
        switch (kind) {
            case 2: {
                this.set1(dst, modifier, fixedData);
                break;
            }
            case 1: {
                int src = TransitionOp.getSource(op);
                this.inc(src, dst, modifier, fixedData);
                break;
            }
            case 0: {
                int src = TransitionOp.getSource(op);
                this.maintain(src, dst, modifier, fixedData);
            }
        }
        assert (this.checkConsistency(fixedData, dst));
    }

    @CompilerDirectives.TruffleBoundary
    private boolean checkConsistency(long[] fixedData, int idDst) {
        int dst = this.mapId(idDst, fixedData);
        long fieldsDst = fixedData[dst];
        int offsetDst = CounterTrackerBitSetWithOffset.getOffset(fieldsDst);
        int minBitDst = CounterTrackerBitSetWithOffset.getMinBit(fieldsDst);
        int maxBitDst = CounterTrackerBitSetWithOffset.getMaxBit(fieldsDst);
        int actualMinBit = Integer.MAX_VALUE;
        int actualMaxBit = 0;
        long firstChunk = fixedData[dst + 1];
        if (offsetDst > this.upperBound) {
            int delta = offsetDst - this.upperBound;
            assert (delta >= 0 && delta < 64) : delta;
            firstChunk >>>= delta;
            firstChunk <<= delta;
        }
        if (firstChunk != 0L) {
            actualMinBit = Math.min(actualMinBit, Long.numberOfTrailingZeros(firstChunk));
            actualMaxBit = Math.max(actualMaxBit, 63 - Long.numberOfLeadingZeros(firstChunk));
        }
        for (int i = 1; i < this.bitsetLength; ++i) {
            long bitSetChunk = fixedData[dst + 1 + i];
            if (bitSetChunk == 0L) continue;
            actualMinBit = Math.min(actualMinBit, (i << 6) + Long.numberOfTrailingZeros(bitSetChunk));
            actualMaxBit = Math.max(actualMaxBit, (i << 6) + (63 - Long.numberOfLeadingZeros(bitSetChunk)));
        }
        if (actualMinBit == Integer.MAX_VALUE) {
            actualMinBit = 0;
        }
        if (actualMinBit == this.bitsetLength << 6 && minBitDst == 0 || minBitDst == this.bitsetLength << 6 && actualMinBit == 0) {
            actualMinBit = minBitDst;
        }
        assert (minBitDst == actualMinBit && maxBitDst == actualMaxBit) : String.format("actualMinBit: %d, actualMaxBit: %d, %s", actualMinBit, actualMaxBit, this.bitSetDataToString(fixedData, idDst));
        return true;
    }

    @Override
    public boolean support(long operation) {
        return true;
    }

    @CompilerDirectives.TruffleBoundary
    String valuesToString(long[] fixedData, int stateId) {
        StringJoiner stringJoiner = new StringJoiner(", ", "[", "]");
        this.iterator(fixedData, stateId).forEachRemaining(i -> stringJoiner.add(Integer.toString(i)));
        return stringJoiner.toString();
    }

    @CompilerDirectives.TruffleBoundary
    String bitSetDataToString(long[] fixedData, int stateId) {
        int mapId = this.mapId(stateId, fixedData);
        long fields = fixedData[mapId];
        int offset = CounterTrackerBitSetWithOffset.getOffset(fields);
        int minBit = CounterTrackerBitSetWithOffset.getMinBit(fields);
        int maxBit = CounterTrackerBitSetWithOffset.getMaxBit(fields);
        assert (this.bitsetLength > 0);
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("offset: %3d, minBit: %3d, maxBit: %3d, bits: [0x%016x", offset, minBit, maxBit, fixedData[mapId + 1]));
        for (int i = 1; i < this.bitsetLength; ++i) {
            sb.append(String.format(", 0x%016x", fixedData[mapId + 1 + i]));
        }
        return sb.append("], values: ").append(this.valuesToString(fixedData, stateId)).toString();
    }

    @CompilerDirectives.TruffleBoundary
    int[] getValues(long[] fixedData, int stateId) {
        IntArrayBuffer buf = new IntArrayBuffer();
        PrimitiveIterator.OfInt iterator = this.iterator(fixedData, stateId);
        while (iterator.hasNext()) {
            int next = iterator.next();
            if (next > this.max) continue;
            buf.add(next);
        }
        return buf.toArray();
    }

    @CompilerDirectives.TruffleBoundary
    PrimitiveIterator.OfInt iterator(long[] fixedData, int stateId) {
        int mapId = this.mapId(stateId, fixedData);
        long[] bitset = Arrays.copyOfRange(fixedData, mapId + 1, mapId + 1 + this.bitsetLength);
        return new AbstractCounterTrackerBitSetWithOffsetIterator(BitSets.iterator(bitset), CounterTrackerBitSetWithOffset.getOffset(fixedData[mapId]));
    }

    @Override
    public String dumpState(int sId, long[] fixedData, int[][] intArrays) {
        return "Bitset " + this.bitSetDataToString(fixedData, sId);
    }

    private static final class AbstractCounterTrackerBitSetWithOffsetIterator
    implements PrimitiveIterator.OfInt {
        private final PrimitiveIterator.OfInt bitSetIterator;
        private final int offset;

        private AbstractCounterTrackerBitSetWithOffsetIterator(PrimitiveIterator.OfInt bitSetIterator, int offset) {
            this.bitSetIterator = bitSetIterator;
            this.offset = offset;
        }

        @Override
        public int nextInt() {
            return this.offset - this.bitSetIterator.nextInt();
        }

        @Override
        public boolean hasNext() {
            return this.bitSetIterator.hasNext();
        }
    }
}

