/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.nodes.dfa;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerAsserts;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.UnsupportedRegexException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.automaton.TransitionConstraint;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.nodes.dfa.CounterTrackerBitSetWithOffset;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.nodes.dfa.CounterTrackerData;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.nodes.dfa.CounterTrackerList;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.nodes.dfa.CounterTrackerLong;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.nodes.dfa.CounterTrackerLong2;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.nodes.dfa.CounterTrackerTrivialAlwaysReEnter;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.nodes.dfa.CounterTrackerTrivialNeverReEnter;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.nodes.dfa.RegressionModeCounterTracker;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.util.TBitSet;

public abstract class CounterTracker {
    public static CounterTracker[] build(int[] quantifierBounds, int[] trackerSizes, CounterTrackerData.Builder dataBuilder, TBitSet trivialAlwaysReEnter, TBitSet trivialNeverReEnter, boolean regressionTestMode) {
        CounterTracker[] result = new CounterTracker[trackerSizes.length];
        for (int i = 0; i < quantifierBounds.length / 2; ++i) {
            CounterTracker tracker;
            int min = quantifierBounds[i * 2];
            int max = quantifierBounds[i * 2 + 1];
            assert (max == -1 || max >= 2);
            int upperBound = Math.max(min, max);
            int numberOfCells = trackerSizes[i];
            if (regressionTestMode) {
                tracker = new RegressionModeCounterTracker(min, max, numberOfCells, trivialAlwaysReEnter.get(i), trivialNeverReEnter.get(i), dataBuilder);
            } else if (trivialAlwaysReEnter.get(i)) {
                tracker = new CounterTrackerTrivialAlwaysReEnter(min, numberOfCells, dataBuilder);
            } else if (trivialNeverReEnter.get(i)) {
                tracker = new CounterTrackerTrivialNeverReEnter(min, max, numberOfCells, dataBuilder);
            } else if (upperBound <= 64) {
                tracker = new CounterTrackerLong(min, max, numberOfCells, dataBuilder);
            } else if (upperBound <= 128) {
                tracker = new CounterTrackerLong2(min, max, numberOfCells, dataBuilder);
            } else if (upperBound <= 1024) {
                tracker = new CounterTrackerBitSetWithOffset(min, max, numberOfCells, dataBuilder);
            } else {
                long maxMemoryConsumption = (long)numberOfCells * (long)upperBound * 4L;
                if (maxMemoryConsumption > 102400L) {
                    throw new UnsupportedRegexException(String.format("Bounded quantifier tracking would consume too much memory at match time: up to %d bytes. Limit: %d bytes", maxMemoryConsumption, 102400));
                }
                tracker = new CounterTrackerList(min, max, numberOfCells, dataBuilder);
            }
            result[i] = tracker;
        }
        return result;
    }

    public boolean canExecute(long constraint, long[] fixedData, int[][] intArrays) {
        int kind = TransitionConstraint.getKind(constraint);
        int sId = TransitionConstraint.getStateID(constraint);
        CompilerAsserts.partialEvaluationConstant(constraint);
        CompilerAsserts.partialEvaluationConstant(kind);
        CompilerAsserts.partialEvaluationConstant(sId);
        return switch (kind) {
            case 2 -> this.anyGeMin(sId, fixedData, intArrays);
            case 3 -> {
                if (!this.anyGeMin(sId, fixedData, intArrays)) {
                    yield true;
                }
                yield false;
            }
            case 4 -> this.anyLtMin(sId, fixedData, intArrays);
            case 5 -> {
                if (!this.anyLtMin(sId, fixedData, intArrays)) {
                    yield true;
                }
                yield false;
            }
            case 0 -> this.anyLtMax(sId, fixedData, intArrays);
            case 1 -> {
                if (!this.anyLtMax(sId, fixedData, intArrays)) {
                    yield true;
                }
                yield false;
            }
            default -> throw CompilerDirectives.shouldNotReachHere();
        };
    }

    protected abstract boolean anyLtMax(int var1, long[] var2, int[][] var3);

    protected abstract boolean anyLtMin(int var1, long[] var2, int[][] var3);

    protected abstract boolean anyGeMin(int var1, long[] var2, int[][] var3);

    public abstract void apply(long var1, long[] var3, int[][] var4);

    public abstract void init(long[] var1, int[][] var2);

    public abstract boolean support(long var1);

    public abstract String dumpState(int var1, long[] var2, int[][] var3);
}

