/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.nodes;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CallTarget;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerAsserts;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.frame.MaterializedFrame;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.frame.VirtualFrame;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.RegexBodyNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.RegexExecNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.RegexFlags;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.RegexLanguage;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.RegexProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.RegexRootNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.RegexSource;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.UnsupportedRegexException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.result.PreCalculatedResultFactory;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.result.RegexResult;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.TRegexCompiler;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.nfa.NFA;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.nodes.TRegexExecutorBaseNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.nodes.TRegexExecutorEntryNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.nodes.TRegexExecutorNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.nodes.dfa.TRegexDFAExecutorNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.nodes.dfa.TRegexLazyBackwardSimpleCGRootNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.nodes.dfa.TRegexLazyCaptureGroupsRootNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.nodes.dfa.TRegexLazyFindStartRootNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.nodes.dfa.TRegexTraceFinderRootNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.nodes.nfa.TRegexBacktrackingNFAExecutorNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.nodes.nfa.TRegexNFAExecutorNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.ast.RegexAST;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.util.Loggers;

public final class TRegexExecNode
extends RegexExecNode
implements RegexProfile.TracksRegexProfile {
    private RegexProfile regexProfile;
    private boolean lazyDFABailedOut = false;
    private boolean eagerDFABailedOut = false;
    private final int numberOfCaptureGroups;
    private final boolean backtrackingMode;
    private final boolean sticky;
    private final Lock optimizeLock;
    @Node.Child
    private RunRegexSearchNode runnerNode;

    private TRegexExecNode(RegexAST ast, boolean backtrackingMode, RunRegexSearchNode runnerNode) {
        super(ast.getLanguage(), ast.getSource(), ast.getFlags().isEitherUnicode());
        this.numberOfCaptureGroups = ast.getNumberOfCaptureGroups();
        this.backtrackingMode = backtrackingMode;
        this.sticky = ast.getFlags().isSticky();
        this.optimizeLock = new ReentrantLock();
        this.runnerNode = this.insert(runnerNode);
        if (!backtrackingMode && runnerNode instanceof NFARegexSearchNode) {
            NFARegexSearchNode nfaNode = (NFARegexSearchNode)runnerNode;
            if (ast.getOptions().isGenerateDFAImmediately()) {
                this.switchToLazyDFA(nfaNode);
            }
        }
    }

    public static TRegexExecNode create(RegexAST ast, NFA nfa, RunRegexSearchNode runnerNodeArg) {
        boolean isBacktracking;
        RunRegexSearchNode runnerNode = runnerNodeArg;
        boolean bl = isBacktracking = runnerNode instanceof NFARegexSearchNode && ((NFARegexSearchNode)runnerNode).getExecutor().unwrap() instanceof TRegexBacktrackingNFAExecutorNode;
        if (!isBacktracking && ast.getOptions().isRegressionTestMode()) {
            runnerNode = RegressionTestModeSearchNode.create(ast, nfa, runnerNodeArg);
        }
        return new TRegexExecNode(ast, isBacktracking, runnerNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RegexResult execute(VirtualFrame frame, TruffleString input, int fromIndex, int maxIndex, int regionFrom, int regionTo) {
        RunRegexSearchNode curRunnerNode;
        if (CompilerDirectives.inInterpreter() && !this.backtrackingMode) {
            RegexProfile profile = this.getRegexProfile();
            curRunnerNode = this.runnerNode;
            if (curRunnerNode instanceof NFARegexSearchNode) {
                NFARegexSearchNode nfaNode = (NFARegexSearchNode)curRunnerNode;
                if (profile.shouldGenerateDFA(maxIndex - fromIndex) && this.optimizeLock.tryLock()) {
                    try {
                        this.switchToLazyDFA(nfaNode);
                        profile.resetCalls();
                    }
                    finally {
                        this.optimizeLock.unlock();
                    }
                }
            } else if (TRegexExecNode.canSwitchToEagerDFA(this.source, curRunnerNode)) {
                assert (((LazyCaptureGroupRegexSearchNode)curRunnerNode).forwardEntryNode != null);
                if (profile.atEvaluationTripPoint() && profile.shouldUseEagerMatching() && this.optimizeLock.tryLock()) {
                    try {
                        this.switchToEagerDFA(profile);
                    }
                    finally {
                        this.optimizeLock.unlock();
                    }
                }
            }
        }
        RegexResult result = this.runnerNode.run(frame, input, fromIndex, maxIndex, regionFrom, regionTo);
        assert (!this.sticky || this.source.getOptions().isBooleanMatch() || result == RegexResult.getNoMatchInstance() || RegexResult.RegexResultGetStartNode.getUncached().execute(result, 0) == fromIndex);
        assert (this.validResult(input, fromIndex, maxIndex, regionFrom, regionTo, result));
        if (CompilerDirectives.inInterpreter() && !this.backtrackingMode) {
            curRunnerNode = this.runnerNode;
            RegexProfile profile = this.getRegexProfile();
            if (curRunnerNode instanceof NFARegexSearchNode) {
                profile.incCalls();
                profile.incProcessedCharacters(TRegexExecNode.charactersProcessedDuringSearch(result, fromIndex, maxIndex));
            } else if (TRegexExecNode.canSwitchToEagerDFA(this.source, curRunnerNode)) {
                profile.incCalls();
                if (result != RegexResult.getNoMatchInstance()) {
                    profile.incMatches();
                }
            }
        }
        return result;
    }

    public int getNumberOfCaptureGroups() {
        return this.numberOfCaptureGroups;
    }

    @Override
    public boolean isBacktracking() {
        return this.backtrackingMode;
    }

    @Override
    public boolean isNFA() {
        return this.runnerNode instanceof NFARegexSearchNode;
    }

    private static int charactersProcessedDuringSearch(RegexResult result, int fromIndex, int maxIndex) {
        if (result == RegexResult.getNoMatchInstance()) {
            return maxIndex - fromIndex;
        }
        return result.getEnd(0) + 1 - fromIndex;
    }

    private boolean validResult(Object input, int fromIndex, int maxIndex, int regionFrom, int regionTo, RegexResult result) {
        if (result == RegexResult.getNoMatchInstance() || result == RegexResult.getBooleanMatchInstance()) {
            return true;
        }
        result.debugForceEvaluation();
        for (int i = 0; i < this.getNumberOfCaptureGroups(); ++i) {
            int end;
            int start = result.getStart(i);
            if (start <= (end = result.getEnd(i)) && (start >= 0 || end < 0)) continue;
            Loggers.LOG_INTERNAL_ERRORS.severe(() -> String.format("Regex: %s\nInput: %s\nfromIndex: %d\nmaxIndex: %d\nregionFrom: %d\nregionTo: %d\nINVALID Result: %s\n", this.getSource().toStringEscaped(), input, fromIndex, maxIndex, regionFrom, regionTo, result));
            return false;
        }
        return true;
    }

    @Override
    public RegexProfile getRegexProfile() {
        if (this.regexProfile == null) {
            this.regexProfile = new RegexProfile();
        }
        return this.regexProfile;
    }

    private void switchToLazyDFA(NFARegexSearchNode nfaNode) {
        CompilerAsserts.neverPartOfCompilation();
        if (!this.lazyDFABailedOut) {
            LazyCaptureGroupRegexSearchNode lazyDFANode = TRegexExecNode.compileLazyDFA(((TRegexNFAExecutorNode)nfaNode.getExecutor().unwrap()).getNFA(), this.getRegexProfile(), true);
            if (lazyDFANode == null) {
                this.lazyDFABailedOut = true;
                ((TRegexNFAExecutorNode)nfaNode.getExecutor().unwrap()).notifyDfaGeneratorBailedOut();
            } else if (this.getSource().getOptions().isAlwaysEager() && TRegexExecNode.canSwitchToEagerDFA(this.source, lazyDFANode)) {
                this.switchToEagerDFA(null);
            } else {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.runnerNode = this.insert(lazyDFANode);
            }
        }
    }

    private static LazyCaptureGroupRegexSearchNode compileLazyDFA(NFA nfa, RegexProfile profile, boolean allowSimpleCG) {
        try {
            return TRegexCompiler.compileLazyDFAExecutor(nfa.getAst().getLanguage(), new NFA(nfa), profile, allowSimpleCG);
        }
        catch (UnsupportedRegexException e) {
            Loggers.LOG_BAILOUT_MESSAGES.fine(() -> e.getReason() + ": " + String.valueOf(nfa.getAst().getSource()));
            return null;
        }
    }

    private static boolean canSwitchToEagerDFA(RegexSource source, RunRegexSearchNode curRunnerNode) {
        return !source.getOptions().isBooleanMatch() && curRunnerNode instanceof LazyCaptureGroupRegexSearchNode && ((LazyCaptureGroupRegexSearchNode)curRunnerNode).captureGroupEntryNode != null;
    }

    private void switchToEagerDFA(RegexProfile profile) {
        CompilerAsserts.neverPartOfCompilation();
        if (!this.eagerDFABailedOut) {
            EagerCaptureGroupRegexSearchNode eagerDFANode = TRegexExecNode.compileEagerDFA(this.getRegexLanguage(), this.getSource());
            if (eagerDFANode == null) {
                this.eagerDFABailedOut = true;
            } else {
                Loggers.LOG_SWITCH_TO_EAGER.fine(() -> "regex " + String.valueOf(this.getSource()) + ": switching to eager matching." + (String)(profile == null ? "" : " profile: " + String.valueOf(profile)));
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.runnerNode = this.insert(eagerDFANode);
            }
        }
    }

    private static EagerCaptureGroupRegexSearchNode compileEagerDFA(RegexLanguage language, RegexSource source) {
        try {
            assert (!source.getOptions().isBooleanMatch());
            TRegexDFAExecutorNode executorNode = TRegexCompiler.compileEagerDFAExecutor(language, source);
            return new EagerCaptureGroupRegexSearchNode(TRegexExecNode.createEntryNode(language, executorNode));
        }
        catch (UnsupportedRegexException e) {
            Loggers.LOG_BAILOUT_MESSAGES.fine(() -> e.getReason() + ": " + String.valueOf(source));
            return null;
        }
    }

    public static TRegexExecutorEntryNode createEntryNode(RegexLanguage language, TRegexExecutorNode executor) {
        if (executor == null) {
            return null;
        }
        return TRegexExecutorEntryNode.create(language, executor);
    }

    @Override
    public String getEngineLabel() {
        return "TRegex fwd";
    }

    public static abstract class RunRegexSearchNode
    extends Node {
        protected abstract RegexResult run(VirtualFrame var1, TruffleString var2, int var3, int var4, int var5, int var6);
    }

    public static final class NFARegexSearchNode
    extends RunRegexSearchNode {
        @Node.Child
        private TRegexExecutorEntryNode entryNode;

        private NFARegexSearchNode(TRegexExecutorEntryNode entryNode) {
            this.entryNode = entryNode;
        }

        public static NFARegexSearchNode create(RegexLanguage language, TRegexExecutorNode nfaExecutor) {
            return new NFARegexSearchNode(TRegexExecNode.createEntryNode(language, nfaExecutor));
        }

        public TRegexExecutorBaseNode getExecutor() {
            return this.entryNode.getExecutor();
        }

        @Override
        protected RegexResult run(VirtualFrame frame, TruffleString input, int fromIndex, int maxIndex, int regionFrom, int regionTo) {
            Object result = this.entryNode.execute(frame, input, fromIndex, maxIndex, regionFrom, regionTo, fromIndex);
            if (this.entryNode.getExecutor().isBooleanMatch()) {
                return result == null ? RegexResult.getNoMatchInstance() : RegexResult.getBooleanMatchInstance();
            }
            return RegexResult.createFromExecutorResult(result);
        }
    }

    private static final class RegressionTestModeSearchNode
    extends RunRegexSearchNode {
        private final RegexSource source;
        private final int numberOfCaptureGroups;
        private final RunRegexSearchNode runner;
        private final NFARegexSearchNode nfaNode;
        private final NFARegexSearchNode backtrackingNode;
        private final LazyCaptureGroupRegexSearchNode lazyDFANode;
        private final LazyCaptureGroupRegexSearchNode noSimpleCGLazyDFANode;
        private final EagerCaptureGroupRegexSearchNode eagerDFANode;

        private RegressionTestModeSearchNode(RegexSource source, int numberOfCaptureGroups, RunRegexSearchNode runner, NFARegexSearchNode nfaNode, NFARegexSearchNode backtrackingNode, LazyCaptureGroupRegexSearchNode lazyDFANode, LazyCaptureGroupRegexSearchNode noSimpleCGLazyDFANode, EagerCaptureGroupRegexSearchNode eagerDFANode) {
            this.source = source;
            this.numberOfCaptureGroups = numberOfCaptureGroups;
            this.runner = runner;
            this.nfaNode = nfaNode;
            this.backtrackingNode = backtrackingNode;
            this.lazyDFANode = lazyDFANode;
            this.noSimpleCGLazyDFANode = noSimpleCGLazyDFANode;
            this.eagerDFANode = eagerDFANode;
        }

        private static RegressionTestModeSearchNode create(RegexAST ast, NFA nfa, RunRegexSearchNode runnerNode) {
            RegexLanguage language = ast.getLanguage();
            NFARegexSearchNode nfaNode = null;
            LazyCaptureGroupRegexSearchNode noSimpleCGLazyDFANode = null;
            EagerCaptureGroupRegexSearchNode eagerDFANode = null;
            if (runnerNode instanceof NFARegexSearchNode) {
                nfaNode = (NFARegexSearchNode)runnerNode;
                assert (!(nfaNode.getExecutor().unwrap() instanceof TRegexBacktrackingNFAExecutorNode));
            }
            NFARegexSearchNode backtrackingNode = new NFARegexSearchNode(TRegexExecNode.createEntryNode(language, TRegexCompiler.compileBacktrackingExecutor(language, nfa)));
            LazyCaptureGroupRegexSearchNode lazyDFANode = runnerNode instanceof LazyCaptureGroupRegexSearchNode ? (LazyCaptureGroupRegexSearchNode)runnerNode : TRegexExecNode.compileLazyDFA(nfa, new RegexProfile(), true);
            if (lazyDFANode != null) {
                if (TRegexExecNode.canSwitchToEagerDFA(ast.getSource(), lazyDFANode)) {
                    eagerDFANode = TRegexExecNode.compileEagerDFA(ast.getLanguage(), ast.getSource());
                }
                if (lazyDFANode.isSimpleCG()) {
                    noSimpleCGLazyDFANode = TRegexExecNode.compileLazyDFA(nfa, new RegexProfile(), false);
                }
            }
            RunRegexSearchNode runner = lazyDFANode == null ? nfaNode : lazyDFANode;
            return new RegressionTestModeSearchNode(ast.getSource(), ast.getNumberOfCaptureGroups(), runner, nfaNode, backtrackingNode, lazyDFANode, noSimpleCGLazyDFANode, eagerDFANode);
        }

        @Override
        protected RegexResult run(VirtualFrame frame, TruffleString input, int fromIndex, int maxIndex, int regionFrom, int regionTo) {
            RegexResult result = this.runner.run(frame, input, fromIndex, maxIndex, regionFrom, regionTo);
            this.runInternalRegressionTests(frame.materialize(), input, fromIndex, maxIndex, regionFrom, regionTo, result);
            return result;
        }

        @CompilerDirectives.TruffleBoundary
        private void runInternalRegressionTests(MaterializedFrame frame, TruffleString input, int fromIndex, int maxIndex, int regionFrom, int regionTo, RegexResult result) {
            if (!(this.backtrackerProducesSameResult(frame, input, fromIndex, maxIndex, regionFrom, regionTo, result) && this.nfaProducesSameResult(frame, input, fromIndex, maxIndex, regionFrom, regionTo, result) && this.noSimpleCGLazyDFAProducesSameResult(frame, input, fromIndex, maxIndex, regionFrom, regionTo, result) && (this.source.getOptions().isBooleanMatch() || this.eagerDFAProducesSameResult(frame, input, fromIndex, maxIndex, regionFrom, regionTo, result)))) {
                throw new AssertionError((Object)"Inconsistent results between different matching modes");
            }
        }

        private boolean backtrackerProducesSameResult(MaterializedFrame frame, TruffleString input, int fromIndex, int maxIndex, int regionFrom, int regionTo, RegexResult result) {
            RegexResult btResult = this.backtrackingNode.run(frame, input, fromIndex, maxIndex, regionFrom, regionTo);
            if (this.resultsEqual(result, btResult)) {
                return true;
            }
            Loggers.LOG_INTERNAL_ERRORS.severe(() -> this.regressionTestErrorMsg(input, fromIndex, maxIndex, regionFrom, regionTo, "Backtracker", btResult, "DFA", result));
            return false;
        }

        private boolean nfaProducesSameResult(MaterializedFrame frame, TruffleString input, int fromIndex, int maxIndex, int regionFrom, int regionTo, RegexResult result) {
            if (this.lazyDFANode == null || this.nfaNode == null) {
                return true;
            }
            RegexResult nfaResult = this.nfaNode.run(frame, input, fromIndex, maxIndex, regionFrom, regionTo);
            if (this.resultsEqual(result, nfaResult)) {
                return true;
            }
            Loggers.LOG_INTERNAL_ERRORS.severe(() -> this.regressionTestErrorMsg(input, fromIndex, maxIndex, regionFrom, regionTo, "NFA", nfaResult, "DFA", result));
            return false;
        }

        private boolean noSimpleCGLazyDFAProducesSameResult(MaterializedFrame frame, TruffleString input, int fromIndex, int maxIndex, int regionFrom, int regionTo, RegexResult result) {
            if (this.noSimpleCGLazyDFANode == null) {
                return true;
            }
            assert (!this.noSimpleCGLazyDFANode.isSimpleCG());
            RegexResult noSimpleCGResult = this.noSimpleCGLazyDFANode.run(frame, input, fromIndex, maxIndex, regionFrom, regionTo);
            if (this.resultsEqual(result, noSimpleCGResult)) {
                return true;
            }
            Loggers.LOG_INTERNAL_ERRORS.severe(() -> this.regressionTestErrorMsg(input, fromIndex, maxIndex, regionFrom, regionTo, "LazyDFA", noSimpleCGResult, "SimplCGDFA", result));
            return false;
        }

        private boolean eagerDFAProducesSameResult(MaterializedFrame frame, TruffleString input, int fromIndex, int maxIndex, int regionFrom, int regionTo, RegexResult result) {
            if (this.eagerDFANode == null) {
                return true;
            }
            RegexResult eagerResult = this.eagerDFANode.run(frame, input, fromIndex, maxIndex, regionFrom, regionTo);
            boolean equal = this.resultsEqual(result, eagerResult);
            if (!equal) {
                Loggers.LOG_INTERNAL_ERRORS.severe(() -> this.regressionTestErrorMsg(input, fromIndex, maxIndex, regionFrom, regionTo, "Lazy", result, "Eager", eagerResult));
            }
            return equal;
        }

        private String regressionTestErrorMsg(TruffleString input, int fromIndex, int maxIndex, int regionFrom, int regionTo, String nameA, RegexResult a, String nameB, RegexResult b) {
            return String.format("Regex: %s\nInput: %s\nfromIndex: %d\nmaxIndex: %d\nregionFrom: %d\nregionTo: %d\n%s Result: %s\n%s Result: %s", this.source.toStringEscaped(), input, fromIndex, maxIndex, regionFrom, regionTo, nameA, a, nameB, b);
        }

        private boolean resultsEqual(RegexResult a, RegexResult b) {
            if (a == RegexResult.getNoMatchInstance()) {
                return b == RegexResult.getNoMatchInstance();
            }
            a.debugForceEvaluation();
            if (b == RegexResult.getNoMatchInstance()) {
                return a == RegexResult.getNoMatchInstance();
            }
            b.debugForceEvaluation();
            if (a == RegexResult.getBooleanMatchInstance()) {
                return b != RegexResult.getNoMatchInstance();
            }
            if (b == RegexResult.getBooleanMatchInstance()) {
                throw CompilerDirectives.shouldNotReachHere("mixed boolean result and regular result: " + String.valueOf(a));
            }
            for (int i = 0; i < this.numberOfCaptureGroups; ++i) {
                if (a.getStart(i) == b.getStart(i) && a.getEnd(i) == b.getEnd(i)) continue;
                return false;
            }
            return a.getLastGroup() == b.getLastGroup();
        }
    }

    public static final class LazyCaptureGroupRegexSearchNode
    extends RunRegexSearchNode {
        private final RegexFlags flags;
        private final boolean booleanMatch;
        @CompilerDirectives.CompilationFinal(dimensions=1)
        private final PreCalculatedResultFactory[] preCalculatedResults;
        @Node.Child
        private TRegexExecutorEntryNode forwardEntryNode;
        @Node.Child
        private TRegexExecutorEntryNode backwardEntryNode;
        @Node.Child
        private TRegexExecutorEntryNode captureGroupEntryNode;
        private final CallTarget backwardCallTarget;
        private final CallTarget captureGroupCallTarget;

        public LazyCaptureGroupRegexSearchNode(RegexLanguage language, RegexSource source, RegexFlags flags, PreCalculatedResultFactory[] preCalculatedResults, TRegexExecutorEntryNode forwardNode, TRegexExecutorEntryNode backwardNode, TRegexExecutorEntryNode captureGroupNode, RegexProfile profile) {
            this.forwardEntryNode = forwardNode;
            this.flags = flags;
            this.booleanMatch = source != null && source.getOptions().isBooleanMatch();
            this.preCalculatedResults = preCalculatedResults;
            this.backwardEntryNode = backwardNode;
            if (backwardNode == null) {
                assert (this.singlePreCalcResult() || this.getForwardExecutor().isAnchored() || this.getForwardExecutor().isSimpleCG() || this.booleanMatch);
                this.backwardCallTarget = null;
            } else {
                RegexBodyNode bodyNode = preCalculatedResults != null ? new TRegexTraceFinderRootNode(language, source, preCalculatedResults, backwardNode) : (this.getBackwardExecutor().isSimpleCG() ? new TRegexLazyBackwardSimpleCGRootNode(language, source, backwardNode) : new TRegexLazyFindStartRootNode(language, source, backwardNode, captureGroupNode == null));
                this.backwardCallTarget = new RegexRootNode(language, bodyNode).getCallTarget();
            }
            this.captureGroupEntryNode = this.insert(captureGroupNode);
            if (captureGroupNode == null) {
                this.captureGroupCallTarget = null;
            } else {
                CallTarget findStartCallTarget = this.getForwardExecutor().isAnchored() || flags.isSticky() && this.getForwardExecutor().getPrefixLength() == 0 || this.backwardEntryNode != null && this.getBackwardExecutor().isAnchored() && !flags.isSticky() || this.getForwardExecutor().canFindStart() ? null : this.backwardCallTarget;
                this.captureGroupCallTarget = new RegexRootNode(language, new TRegexLazyCaptureGroupsRootNode(language, source, captureGroupNode, profile, findStartCallTarget)).getCallTarget();
            }
        }

        public TRegexDFAExecutorNode getForwardExecutor() {
            return this.forwardEntryNode == null ? null : (TRegexDFAExecutorNode)this.forwardEntryNode.getExecutor().unwrap();
        }

        public TRegexDFAExecutorNode getBackwardExecutor() {
            return this.backwardEntryNode == null ? null : (TRegexDFAExecutorNode)this.backwardEntryNode.getExecutor().unwrap();
        }

        public boolean isSimpleCG() {
            return this.forwardEntryNode != null && this.getForwardExecutor().isSimpleCG() || this.backwardEntryNode != null && this.getBackwardExecutor().isSimpleCG();
        }

        @Override
        protected RegexResult run(VirtualFrame frame, TruffleString input, int fromIndex, int maxIndex, int regionFrom, int regionTo) {
            if (this.backwardEntryNode != null && this.getBackwardExecutor().isAnchored() && !this.flags.isSticky()) {
                return this.executeBackwardAnchored(frame, input, fromIndex, maxIndex, regionFrom, regionTo);
            }
            return this.executeForward(frame, input, fromIndex, maxIndex, regionFrom, regionTo);
        }

        private RegexResult executeForward(VirtualFrame frame, TruffleString input, int fromIndex, int maxIndex, int regionFrom, int regionTo) {
            if (this.getForwardExecutor().isSimpleCG()) {
                Object result = this.forwardEntryNode.execute(frame, input, fromIndex, maxIndex, regionFrom, regionTo, fromIndex);
                return RegexResult.createFromExecutorResult(result);
            }
            long end = (Long)this.forwardEntryNode.execute(frame, input, fromIndex, maxIndex, regionFrom, regionTo, fromIndex);
            if (end == -2L) {
                return RegexResult.getNoMatchInstance();
            }
            if (this.booleanMatch) {
                return RegexResult.getBooleanMatchInstance();
            }
            if (this.singlePreCalcResult()) {
                return this.preCalculatedResults[0].createFromEnd((int)end);
            }
            if (this.preCalculatedResults == null && this.captureGroupEntryNode == null) {
                if ((this.backwardCallTarget == null || this.getForwardExecutor().getNumberOfCaptureGroups() == 1) && end == (long)fromIndex) {
                    return RegexResult.create((int)end, (int)end);
                }
                if (this.getForwardExecutor().isAnchored() || this.flags.isSticky()) {
                    return RegexResult.create(fromIndex, (int)end);
                }
                if (this.backwardCallTarget == null && this.getForwardExecutor().canFindStart()) {
                    return RegexResult.create((int)(end >>> 32), (int)end);
                }
                assert (this.backwardCallTarget != null);
                return RegexResult.createLazy(input, fromIndex, regionFrom, regionTo, -1, (int)end, this.backwardCallTarget);
            }
            if (this.preCalculatedResults != null) {
                return RegexResult.createLazy(input, fromIndex, regionFrom, regionTo, -1, (int)end, this.backwardCallTarget);
            }
            if (this.getForwardExecutor().canFindStart()) {
                return RegexResult.createLazy(input, fromIndex, regionFrom, regionTo, (int)(end >>> 32), (int)end, this.captureGroupCallTarget);
            }
            return RegexResult.createLazy(input, fromIndex, regionFrom, regionTo, fromIndex, (int)end, this.captureGroupCallTarget);
        }

        private RegexResult executeBackwardAnchored(VirtualFrame frame, TruffleString input, int fromIndex, int maxIndex, int regionFrom, int regionTo) {
            if (this.getBackwardExecutor().isSimpleCG()) {
                Object result = this.backwardEntryNode.execute(frame, input, fromIndex, maxIndex, regionFrom, regionTo, maxIndex);
                return RegexResult.createFromExecutorResult(result);
            }
            int backwardResult = (int)((Long)this.backwardEntryNode.execute(frame, input, fromIndex, maxIndex, regionFrom, regionTo, maxIndex)).longValue();
            if (backwardResult == -2) {
                return RegexResult.getNoMatchInstance();
            }
            if (this.booleanMatch) {
                return RegexResult.getBooleanMatchInstance();
            }
            if (this.multiplePreCalcResults()) {
                return this.preCalculatedResults[backwardResult].createFromEnd(maxIndex);
            }
            int start = backwardResult;
            if (this.singlePreCalcResult()) {
                return this.preCalculatedResults[0].createFromStart(start);
            }
            if (this.getForwardExecutor().isSimpleCG()) {
                Object result = this.forwardEntryNode.execute(frame, input, fromIndex, maxIndex, regionFrom, regionTo, start);
                assert (result != null);
                return RegexResult.createFromExecutorResult(result);
            }
            if (this.captureGroupEntryNode != null) {
                return RegexResult.createLazy(input, fromIndex, regionFrom, regionTo, start, maxIndex, this.captureGroupCallTarget);
            }
            return RegexResult.create(start, maxIndex);
        }

        private boolean singlePreCalcResult() {
            return this.preCalculatedResults != null && this.preCalculatedResults.length == 1;
        }

        private boolean multiplePreCalcResults() {
            return this.preCalculatedResults != null && this.preCalculatedResults.length > 1;
        }
    }

    static final class EagerCaptureGroupRegexSearchNode
    extends RunRegexSearchNode {
        @Node.Child
        private TRegexExecutorEntryNode entryNode;

        EagerCaptureGroupRegexSearchNode(TRegexExecutorEntryNode entryNode) {
            this.entryNode = entryNode;
        }

        public TRegexExecutorBaseNode getExecutor() {
            return this.entryNode.getExecutor();
        }

        @Override
        protected RegexResult run(VirtualFrame frame, TruffleString input, int fromIndex, int maxIndex, int regionFrom, int regionTo) {
            Object result = this.entryNode.execute(frame, input, fromIndex, maxIndex, regionFrom, regionTo, fromIndex);
            return RegexResult.createFromExecutorResult(result);
        }
    }
}

