/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.nfa;

import java.util.Arrays;
import java.util.EnumSet;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.Token;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.util.json.Json;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.util.json.JsonValue;

public final class TransitionGuard {
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private static final Kind[] KIND_VALUES = Arrays.copyOf(Kind.values(), Kind.values().length);
    private static final EnumSet<Kind> QUANTIFIER_GUARDS = EnumSet.of(Kind.countInc, new Kind[]{Kind.countSet1, Kind.countSetMinInc, Kind.countLtMin, Kind.countGeMin, Kind.countLtMax});
    private static final EnumSet<Kind> QUANTIFIER_GUARDS_ALLOWED_IN_DFA = EnumSet.of(Kind.countInc, Kind.countSet1, Kind.countLtMin, Kind.countGeMin, Kind.countLtMax);
    private static final EnumSet<Kind> QUANTIFIER_OP = EnumSet.of(Kind.countInc, Kind.countSet1, Kind.countSetMinInc);
    private static final EnumSet<Kind> ZERO_WIDTH_QUANTIFIER_GUARDS = EnumSet.of(Kind.enterZeroWidth, Kind.exitZeroWidth, Kind.escapeZeroWidth);
    private static final EnumSet<Kind> GROUP_NUMBER_GUARDS = EnumSet.of(Kind.updateRecursiveBackrefPointer, Kind.checkGroupMatched, Kind.checkGroupNotMatched);
    private static final EnumSet<Kind> GROUP_BOUNDARY_INDEX_GUARDS = EnumSet.of(Kind.updateCG);
    public static final long[] NO_GUARDS = new long[0];

    public static long createCountInc(Token.Quantifier quantifier) {
        return TransitionGuard.create(Kind.countInc, quantifier);
    }

    public static long createCountInc(int quantifierIndex) {
        return TransitionGuard.create(Kind.countInc, quantifierIndex);
    }

    public static long createCountSet1(Token.Quantifier quantifier) {
        return TransitionGuard.create(Kind.countSet1, quantifier);
    }

    public static long createCountSet1(int quantifierIndex) {
        return TransitionGuard.create(Kind.countSet1, quantifierIndex);
    }

    public static long createCountSetMin(Token.Quantifier quantifier) {
        return TransitionGuard.create(Kind.countSetMinInc, quantifier);
    }

    public static long createCountSetMin(int quantifierIndex) {
        return TransitionGuard.create(Kind.countSetMinInc, quantifierIndex);
    }

    public static long createCountLtMin(Token.Quantifier quantifier) {
        return TransitionGuard.create(Kind.countLtMin, quantifier);
    }

    public static long createCountLtMin(int quantifierIndex) {
        return TransitionGuard.create(Kind.countLtMin, quantifierIndex);
    }

    public static long createCountGeMin(Token.Quantifier quantifier) {
        return TransitionGuard.create(Kind.countGeMin, quantifier);
    }

    public static long createCountGeMin(int quantifierIndex) {
        return TransitionGuard.create(Kind.countGeMin, quantifierIndex);
    }

    public static long createCountLtMax(Token.Quantifier quantifier) {
        return TransitionGuard.create(quantifier.getMin() == quantifier.getMax() ? Kind.countLtMin : Kind.countLtMax, quantifier);
    }

    public static long createCountLtMax(int quantifierIndex) {
        return TransitionGuard.create(Kind.countLtMax, quantifierIndex);
    }

    public static long createEnterZeroWidth(Token.Quantifier quantifier) {
        return TransitionGuard.createZeroWidth(Kind.enterZeroWidth, quantifier);
    }

    public static long createEnterZeroWidthFromExit(long guard) {
        assert (TransitionGuard.is(guard, Kind.exitZeroWidth) || TransitionGuard.is(guard, Kind.escapeZeroWidth));
        return TransitionGuard.create(Kind.enterZeroWidth, TransitionGuard.getZeroWidthQuantifierIndex(guard));
    }

    public static long createExitZeroWidth(Token.Quantifier quantifier) {
        return TransitionGuard.createZeroWidth(Kind.exitZeroWidth, quantifier);
    }

    public static long createEscapeZeroWidth(Token.Quantifier quantifier) {
        return TransitionGuard.createZeroWidth(Kind.escapeZeroWidth, quantifier);
    }

    public static long createEscapeZeroWidthFromEnter(long guard) {
        assert (TransitionGuard.is(guard, Kind.enterZeroWidth));
        return TransitionGuard.create(Kind.escapeZeroWidth, TransitionGuard.getZeroWidthQuantifierIndex(guard));
    }

    public static long createUpdateCG(int index) {
        return TransitionGuard.create(Kind.updateCG, index);
    }

    public static long createUpdateRecursiveBackref(int index) {
        return TransitionGuard.create(Kind.updateRecursiveBackrefPointer, index);
    }

    public static long createCheckGroupMatched(int groupNumber) {
        return TransitionGuard.create(Kind.checkGroupMatched, groupNumber);
    }

    public static long createCheckGroupNotMatched(int groupNumber) {
        return TransitionGuard.create(Kind.checkGroupNotMatched, groupNumber);
    }

    private static long create(Kind kind, Token.Quantifier q) {
        assert (q.hasIndex());
        return TransitionGuard.create(kind, q.getIndex());
    }

    private static long createZeroWidth(Kind kind, Token.Quantifier q) {
        assert (q.hasZeroWidthIndex());
        return TransitionGuard.create(kind, q.getZeroWidthIndex());
    }

    private static long create(Kind kind, int index) {
        return (long)kind.ordinal() << 32 | (long)index;
    }

    private static int getKindOrdinal(long guard) {
        return (int)(guard >>> 32 & 0xFFL);
    }

    public static Kind getKind(long guard) {
        return KIND_VALUES[TransitionGuard.getKindOrdinal(guard)];
    }

    public static boolean is(long guard, Kind kind) {
        return TransitionGuard.getKindOrdinal(guard) == kind.ordinal();
    }

    public static boolean isQuantifierGuard(long guard) {
        return QUANTIFIER_GUARDS.contains((Object)TransitionGuard.getKind(guard));
    }

    public static boolean isQuantifierGuardAllowedInDFA(long guard) {
        return QUANTIFIER_GUARDS_ALLOWED_IN_DFA.contains((Object)TransitionGuard.getKind(guard));
    }

    public static boolean isQuantifierOp(long guard) {
        return QUANTIFIER_OP.contains((Object)TransitionGuard.getKind(guard));
    }

    public static int getQuantifierIndex(long guard) {
        assert (QUANTIFIER_GUARDS.contains((Object)TransitionGuard.getKind(guard)));
        return (int)guard;
    }

    public static int getZeroWidthQuantifierIndex(long guard) {
        assert (ZERO_WIDTH_QUANTIFIER_GUARDS.contains((Object)TransitionGuard.getKind(guard)));
        return (int)guard;
    }

    public static int getGroupNumber(long guard) {
        assert (GROUP_NUMBER_GUARDS.contains((Object)TransitionGuard.getKind(guard)));
        return (int)guard;
    }

    public static int getGroupBoundaryIndex(long guard) {
        assert (GROUP_BOUNDARY_INDEX_GUARDS.contains((Object)TransitionGuard.getKind(guard)));
        return (int)guard;
    }

    @CompilerDirectives.TruffleBoundary
    public static String toString(long guard) {
        return String.valueOf((Object)TransitionGuard.getKind(guard)) + " " + (int)guard;
    }

    @CompilerDirectives.TruffleBoundary
    public static String dump(long[] guards) {
        StringBuilder sb = new StringBuilder();
        for (long guard : guards) {
            sb.append(TransitionGuard.toString(guard)).append('\n');
        }
        return sb.toString();
    }

    @CompilerDirectives.TruffleBoundary
    public static JsonValue toJson(long guard) {
        return Json.val(TransitionGuard.toString(guard));
    }

    public static enum Kind {
        countInc,
        countSet1,
        countSetMinInc,
        countLtMin,
        countGeMin,
        countLtMax,
        enterZeroWidth,
        exitZeroWidth,
        escapeZeroWidth,
        updateCG,
        updateRecursiveBackrefPointer,
        checkGroupMatched,
        checkGroupNotMatched;

    }
}

