/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.nfa;

import java.util.Arrays;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.automaton.AbstractTransition;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.nfa.PureNFAState;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.nfa.TransitionGuard;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.ast.GroupBoundaries;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.ast.RegexAST;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.util.json.Json;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.util.json.JsonValue;

public final class PureNFATransition
implements AbstractTransition<PureNFAState, PureNFATransition> {
    private final int id;
    private final PureNFAState source;
    private final PureNFAState target;
    private final GroupBoundaries groupBoundaries;
    private final boolean caretGuard;
    private final boolean dollarGuard;
    private final boolean matchBeginGuard;
    private final boolean matchEndGuard;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final long[] guards;

    public PureNFATransition(int id, PureNFAState source, PureNFAState target, GroupBoundaries groupBoundaries, boolean caretGuard, boolean dollarGuard, boolean matchBeginGuard, boolean matchEndGuard, long[] guards) {
        this.id = id;
        this.source = source;
        this.target = target;
        this.caretGuard = caretGuard;
        this.groupBoundaries = groupBoundaries;
        this.dollarGuard = dollarGuard;
        this.matchBeginGuard = matchBeginGuard;
        this.matchEndGuard = matchEndGuard;
        this.guards = guards;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public PureNFAState getSource() {
        return this.source;
    }

    @Override
    public PureNFAState getTarget() {
        return this.target;
    }

    public GroupBoundaries getGroupBoundaries() {
        return this.groupBoundaries;
    }

    public boolean hasCaretGuard() {
        return this.caretGuard;
    }

    public boolean hasDollarGuard() {
        return this.dollarGuard;
    }

    public boolean hasMatchBeginGuard() {
        return this.matchBeginGuard;
    }

    public boolean hasMatchEndGuard() {
        return this.matchEndGuard;
    }

    public long[] getGuards() {
        return this.guards;
    }

    @CompilerDirectives.TruffleBoundary
    public JsonValue toJson(RegexAST ast) {
        return Json.obj(Json.prop("id", this.id), Json.prop("source", this.source.getId()), Json.prop("target", this.target.getId()), Json.prop("groupBoundaries", this.groupBoundaries), Json.prop("sourceSections", this.groupBoundaries.indexUpdateSourceSectionsToJson(ast)), Json.prop("guards", this.guards.length == 0 ? Json.array(Json.val("no guards")) : Json.array(Arrays.stream(this.guards).mapToObj(TransitionGuard::toJson))));
    }
}

