/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.nfa;

import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.automaton.AbstractTransition;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.automaton.BasicState;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.automaton.StateSet;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.nfa.NFAStateTransition;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.ast.LookBehindAssertion;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.ast.RegexAST;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.ast.RegexASTNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.util.json.Json;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.util.json.JsonArray;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.util.json.JsonConvertible;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.util.json.JsonObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.util.TBitSet;
import org.cyclops.integratedscripting.vendors.org.graalvm.collections.EconomicMap;

public final class NFAState
extends BasicState<NFAState, NFAStateTransition>
implements JsonConvertible {
    private static final byte FLAGS_NONE = 0;
    private static final byte FLAG_HAS_PREFIX_STATES = 64;
    private static final byte FLAG_MUST_ADVANCE = -128;
    private static final NFAStateTransition[] EMPTY_TRANSITIONS = new NFAStateTransition[0];
    private final StateSet<RegexAST, ? extends RegexASTNode> stateSet;
    @CompilerDirectives.CompilationFinal
    private short transitionToAnchoredFinalState = (short)-1;
    @CompilerDirectives.CompilationFinal
    private short transitionToUnAnchoredFinalState = (short)-1;
    @CompilerDirectives.CompilationFinal
    private short revTransitionToAnchoredFinalState = (short)-1;
    @CompilerDirectives.CompilationFinal
    private short revTransitionToUnAnchoredFinalState = (short)-1;
    @CompilerDirectives.CompilationFinal
    private int numberOfGuardedUnAnchoredFinalTransitions = 0;
    @CompilerDirectives.CompilationFinal
    private int numberOfGuardedAnchoredFinalTransitions = 0;
    private TBitSet possibleResults;
    private final Set<LookBehindAssertion> finishedLookBehinds;
    private final EconomicMap<Integer, TBitSet> matchedConditionGroupsMap;

    public NFAState(short id, StateSet<RegexAST, ? extends RegexASTNode> stateSet, Set<LookBehindAssertion> finishedLookBehinds, boolean hasPrefixStates, boolean mustAdvance) {
        this(id, stateSet, NFAState.initFlags(hasPrefixStates, mustAdvance), null, finishedLookBehinds, NFAState.initMatchedConditionGroupsMap(stateSet));
    }

    public NFAState(short id, StateSet<RegexAST, ? extends RegexASTNode> stateSet, Set<LookBehindAssertion> finishedLookBehinds, boolean hasPrefixStates, boolean mustAdvance, EconomicMap<Integer, TBitSet> matchedConditionGroupsMap) {
        this(id, stateSet, NFAState.initFlags(hasPrefixStates, mustAdvance), null, finishedLookBehinds, matchedConditionGroupsMap);
    }

    private static EconomicMap<Integer, TBitSet> initMatchedConditionGroupsMap(StateSet<RegexAST, ? extends RegexASTNode> stateSet) {
        if (!stateSet.getStateIndex().getProperties().hasConditionalBackReferences()) {
            return null;
        }
        EconomicMap<Integer, TBitSet> matchedConditionGroupsMap = EconomicMap.create();
        for (RegexASTNode node : stateSet) {
            matchedConditionGroupsMap.put(node.getId(), TBitSet.getEmptyInstance());
        }
        return matchedConditionGroupsMap;
    }

    private static byte initFlags(boolean hasPrefixStates, boolean mustAdvance) {
        return (byte)((hasPrefixStates ? 64 : 0) | (mustAdvance ? -128 : 0));
    }

    private NFAState(short id, StateSet<RegexAST, ? extends RegexASTNode> stateSet, short flags, Set<LookBehindAssertion> finishedLookBehinds, EconomicMap<Integer, TBitSet> matchedConditionGroupsMap) {
        this(id, stateSet, flags, null, finishedLookBehinds, matchedConditionGroupsMap);
    }

    private NFAState(short id, StateSet<RegexAST, ? extends RegexASTNode> stateSet, short flags, TBitSet possibleResults, Set<LookBehindAssertion> finishedLookBehinds, EconomicMap<Integer, TBitSet> matchedConditionGroupsMap) {
        super((int)id, (AbstractTransition[])EMPTY_TRANSITIONS);
        this.setFlag(flags);
        this.stateSet = stateSet;
        this.possibleResults = possibleResults;
        this.finishedLookBehinds = finishedLookBehinds;
        this.matchedConditionGroupsMap = matchedConditionGroupsMap;
    }

    public NFAState createTraceFinderCopy(short copyID) {
        return new NFAState(copyID, this.getStateSet(), this.getFlags(), this.finishedLookBehinds, this.matchedConditionGroupsMap);
    }

    public Set<LookBehindAssertion> getFinishedLookBehinds() {
        return this.finishedLookBehinds;
    }

    public StateSet<RegexAST, ? extends RegexASTNode> getStateSet() {
        return this.stateSet;
    }

    public boolean hasPrefixStates() {
        return this.getFlag((short)64);
    }

    public void setHasPrefixStates(boolean value) {
        this.setFlag((short)64, value);
    }

    public boolean isMustAdvance() {
        return this.getFlag((short)-128);
    }

    public void setMustAdvance(boolean value) {
        this.setFlag((short)-128, value);
    }

    public EconomicMap<Integer, TBitSet> getMatchedConditionGroupsMap() {
        return this.matchedConditionGroupsMap;
    }

    public TBitSet getMatchedConditionGroups(RegexASTNode t) {
        if (!this.stateSet.getStateIndex().getProperties().hasConditionalBackReferences()) {
            return TBitSet.getEmptyInstance();
        }
        assert (this.matchedConditionGroupsMap.containsKey(t.getId()));
        return (TBitSet)this.matchedConditionGroupsMap.get(t.getId());
    }

    public TBitSet getMatchedConditionGroupsDebug() {
        if (!this.stateSet.getStateIndex().getProperties().hasConditionalBackReferences()) {
            return TBitSet.getEmptyInstance();
        }
        TBitSet matchedConditionGroups = new TBitSet(64);
        for (RegexASTNode t : this.stateSet) {
            matchedConditionGroups.union((TBitSet)this.matchedConditionGroupsMap.get(t.getId()));
        }
        return matchedConditionGroups;
    }

    public boolean hasUnGuardedTransitionToAnchoredFinalState(boolean forward) {
        return this.getTransitionToAnchoredFinalStateId(forward) >= 0;
    }

    public boolean hasGuardedTransitionToAnchoredFinalState() {
        return this.getTransitionToAnchoredFinalStateId(true) == -1 && this.numberOfGuardedAnchoredFinalTransitions > 0;
    }

    public long[][] getAnchoredFinalTransitionConstraints() {
        NFAStateTransition[] successors;
        long[][] result = new long[this.numberOfGuardedAnchoredFinalTransitions][];
        int i = 0;
        for (NFAStateTransition transition : successors = (NFAStateTransition[])this.getSuccessors()) {
            if (!transition.getTarget().isAnchoredFinalState() || !transition.hasConstraints()) continue;
            result[i] = transition.getConstraints();
            ++i;
        }
        return result;
    }

    public long[][] getUnAnchoredFinalTransitionConstraints() {
        NFAStateTransition[] successors;
        long[][] result = new long[this.numberOfGuardedUnAnchoredFinalTransitions][];
        int i = 0;
        for (NFAStateTransition transition : successors = (NFAStateTransition[])this.getSuccessors()) {
            if (!transition.getTarget().isUnAnchoredFinalState() || !transition.hasConstraints()) continue;
            result[i] = transition.getConstraints();
            ++i;
        }
        return result;
    }

    public short getTransitionToAnchoredFinalStateId(boolean forward) {
        return forward ? this.transitionToAnchoredFinalState : this.revTransitionToAnchoredFinalState;
    }

    public NFAStateTransition getTransitionToAnchoredFinalState(boolean forward) {
        assert (this.hasUnGuardedTransitionToAnchoredFinalState(forward));
        return ((NFAStateTransition[])this.getSuccessors(forward))[this.getTransitionToAnchoredFinalStateId(forward)];
    }

    @Override
    public boolean hasUnGuardedTransitionToUnAnchoredFinalState(boolean forward) {
        return this.getTransitionToUnAnchoredFinalStateId(forward) >= 0;
    }

    public boolean hasGuardedTransitionToUnAnchoredFinalState() {
        return this.getTransitionToUnAnchoredFinalStateId(true) == -1 && this.numberOfGuardedUnAnchoredFinalTransitions > 0;
    }

    public NFAStateTransition getTransitionToUnAnchoredFinalState(boolean forward) {
        assert (this.hasUnGuardedTransitionToUnAnchoredFinalState(forward));
        return ((NFAStateTransition[])this.getSuccessors(forward))[this.getTransitionToUnAnchoredFinalStateId(forward)];
    }

    public short getTransitionToUnAnchoredFinalStateId(boolean forward) {
        return forward ? this.transitionToUnAnchoredFinalState : this.revTransitionToUnAnchoredFinalState;
    }

    public boolean hasUnGuardedTransitionToFinalState(boolean forward) {
        return this.hasUnGuardedTransitionToAnchoredFinalState(forward) || this.hasUnGuardedTransitionToUnAnchoredFinalState(forward);
    }

    public int getFirstTransitionToFinalStateIndex(boolean forward) {
        assert (this.hasUnGuardedTransitionToFinalState(forward));
        return Math.min(Short.toUnsignedInt(this.getTransitionToAnchoredFinalStateId(forward)), Short.toUnsignedInt(this.getTransitionToUnAnchoredFinalStateId(forward)));
    }

    public NFAStateTransition getFirstTransitionToFinalState(boolean forward) {
        return ((NFAStateTransition[])this.getSuccessors(forward))[this.getFirstTransitionToFinalStateIndex(forward)];
    }

    public void addLoopBackNext(NFAStateTransition transition) {
        this.updateFinalStateTransitions(transition, (short)((NFAStateTransition[])this.getSuccessors()).length);
        this.setSuccessors(Arrays.copyOf((NFAStateTransition[])this.getSuccessors(), ((NFAStateTransition[])this.getSuccessors()).length + 1));
        ((NFAStateTransition[])this.getSuccessors())[((NFAStateTransition[])this.getSuccessors()).length - 1] = transition;
    }

    public void removeLoopBackNext() {
        this.setSuccessors(Arrays.copyOf((NFAStateTransition[])this.getSuccessors(), ((NFAStateTransition[])this.getSuccessors()).length - 1));
        if (this.transitionToAnchoredFinalState == ((NFAStateTransition[])this.getSuccessors()).length) {
            this.transitionToAnchoredFinalState = (short)-1;
        }
        if (this.transitionToUnAnchoredFinalState == ((NFAStateTransition[])this.getSuccessors()).length) {
            this.transitionToUnAnchoredFinalState = (short)-1;
        }
    }

    public void setSuccessors(NFAStateTransition[] transitions, boolean createReverseTransitions) {
        this.setSuccessors(transitions);
        for (short i = 0; i < transitions.length; i = (short)(i + 1)) {
            NFAStateTransition t = transitions[i];
            this.updateFinalStateTransitions(t, i);
            if (!createReverseTransitions) continue;
            t.getTarget().incPredecessors();
        }
    }

    private void updateFinalStateTransitions(NFAStateTransition transition, short i) {
        boolean hasConstraints = transition.hasConstraints();
        if (transition.getTarget().isAnchoredFinalState()) {
            if (this.transitionToAnchoredFinalState == -1 && !hasConstraints) {
                this.transitionToAnchoredFinalState = i;
            }
            if (hasConstraints) {
                ++this.numberOfGuardedAnchoredFinalTransitions;
            }
        }
        if (transition.getTarget().isUnAnchoredFinalState()) {
            if (this.transitionToUnAnchoredFinalState == -1 && !hasConstraints) {
                this.transitionToUnAnchoredFinalState = i;
            }
            if (hasConstraints) {
                ++this.numberOfGuardedUnAnchoredFinalTransitions;
            }
        }
    }

    public void removeSuccessor(NFAState state) {
        int toRemove = 0;
        for (NFAStateTransition successor : (NFAStateTransition[])this.getSuccessors()) {
            if (successor.getTarget() != state) continue;
            ++toRemove;
        }
        if (toRemove == 0) {
            return;
        }
        AbstractTransition[] newNext = new NFAStateTransition[((NFAStateTransition[])this.getSuccessors()).length - toRemove];
        short iNew = 0;
        for (int i = 0; i < ((NFAStateTransition[])this.getSuccessors()).length; i = (int)((short)(i + 1))) {
            NFAStateTransition successor;
            successor = ((NFAStateTransition[])this.getSuccessors())[i];
            if (successor.getTarget() == state) {
                if (i == this.transitionToAnchoredFinalState) {
                    this.transitionToAnchoredFinalState = (short)-1;
                }
                if (i == this.transitionToUnAnchoredFinalState) {
                    this.transitionToUnAnchoredFinalState = (short)-1;
                }
                if (!successor.hasConstraints()) continue;
                if (state.isFinalState()) {
                    --this.numberOfGuardedUnAnchoredFinalTransitions;
                }
                if (!state.isAnchoredFinalState()) continue;
                --this.numberOfGuardedAnchoredFinalTransitions;
                continue;
            }
            if (i == this.transitionToAnchoredFinalState) {
                this.transitionToAnchoredFinalState = iNew;
            }
            if (i == this.transitionToUnAnchoredFinalState) {
                this.transitionToUnAnchoredFinalState = iNew;
            }
            short s = iNew;
            iNew = (short)(iNew + 1);
            newNext[s] = ((NFAStateTransition[])this.getSuccessors())[i];
        }
        this.setSuccessors(newNext);
    }

    public void linkPredecessors() {
        for (NFAStateTransition t : (NFAStateTransition[])this.getSuccessors()) {
            t.getTarget().addPredecessor(t);
            if (this.isAnchoredInitialState()) {
                t.getTarget().revTransitionToAnchoredFinalState = (short)t.getTarget().getNPredecessors();
            }
            if (!this.isUnAnchoredInitialState()) continue;
            t.getTarget().revTransitionToUnAnchoredFinalState = (short)t.getTarget().getNPredecessors();
        }
    }

    public TBitSet getPossibleResults() {
        if (this.possibleResults == null) {
            return TBitSet.getEmptyInstance();
        }
        return this.possibleResults;
    }

    public boolean hasPossibleResults() {
        return this.possibleResults != null && !this.possibleResults.isEmpty();
    }

    public void addPossibleResult(int index) {
        if (this.possibleResults == null) {
            this.possibleResults = new TBitSet(254);
        }
        this.possibleResults.set(index);
    }

    public NFAState(NFAState original) {
        super(original);
        this.stateSet = original.stateSet;
        this.transitionToAnchoredFinalState = original.transitionToAnchoredFinalState;
        this.transitionToUnAnchoredFinalState = original.transitionToUnAnchoredFinalState;
        this.revTransitionToAnchoredFinalState = original.revTransitionToAnchoredFinalState;
        this.revTransitionToUnAnchoredFinalState = original.revTransitionToUnAnchoredFinalState;
        this.possibleResults = original.possibleResults;
        this.finishedLookBehinds = original.finishedLookBehinds;
        this.matchedConditionGroupsMap = original.matchedConditionGroupsMap;
    }

    @CompilerDirectives.TruffleBoundary
    public String idToString() {
        return this.getStateSet().stream().map(x -> String.valueOf(x.getId())).collect(Collectors.joining(",", "(", ")")) + "[" + this.getId() + "]";
    }

    @CompilerDirectives.TruffleBoundary
    public String toString() {
        return this.idToString();
    }

    public boolean equals(Object o) {
        return o instanceof NFAState && this.getId() == ((NFAState)o).getId();
    }

    public int hashCode() {
        return this.getId();
    }

    protected NFAStateTransition[] createTransitionsArray(int length) {
        return new NFAStateTransition[length];
    }

    @CompilerDirectives.TruffleBoundary
    private JsonArray sourceSectionsToJson() {
        return RegexAST.sourceSectionsToJson(this.getStateSet().stream().map(x -> this.getStateSet().getStateIndex().getSourceSections((RegexASTNode)x)).filter(Objects::nonNull).flatMap(Collection::stream));
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public JsonObject toJson() {
        return Json.obj(Json.prop("id", this.getId()), Json.prop("stateSet", this.getStateSet().stream().map(x -> Json.val(x.getId()))), Json.prop("mustAdvance", this.isMustAdvance()), Json.prop("sourceSections", this.sourceSectionsToJson()), Json.prop("forwardAnchoredFinalState", this.isAnchoredFinalState()), Json.prop("forwardUnAnchoredFinalState", this.isUnAnchoredFinalState()), Json.prop("reverseAnchoredFinalState", this.isAnchoredInitialState()), Json.prop("reverseUnAnchoredFinalState", this.isUnAnchoredInitialState()), Json.prop("next", Arrays.stream((NFAStateTransition[])this.getSuccessors()).map(x -> Json.val(x.getId()))), Json.prop("prev", Arrays.stream((NFAStateTransition[])this.getPredecessors()).map(x -> Json.val(x.getId()))));
    }

    @CompilerDirectives.TruffleBoundary
    public JsonObject toJson(boolean forward) {
        return Json.obj(Json.prop("id", this.getId()), Json.prop("stateSet", this.getStateSet().stream().map(x -> Json.val(x.getId()))), Json.prop("matcherBuilder", Arrays.stream((NFAStateTransition[])this.getPredecessors()).findFirst().map(t -> t.getCodePointSet().toString()).orElse("")), Json.prop("mustAdvance", this.isMustAdvance()), Json.prop("sourceSections", this.sourceSectionsToJson()), Json.prop("anchoredFinalState", this.isAnchoredFinalState(forward)), Json.prop("unAnchoredFinalState", this.isUnAnchoredFinalState(forward)), Json.prop("transitions", Arrays.stream((NFAStateTransition[])this.getSuccessors(forward)).map(x -> Json.val(x.getId()))));
    }
}

