/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.nfa;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Set;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.UnsupportedRegexException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.automaton.TransitionConstraint;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.automaton.TransitionOp;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.buffer.LongArrayBuffer;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.nfa.ASTStep;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.nfa.ASTSuccessor;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.nfa.ASTTransition;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.nfa.NFAState;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.nfa.TransitionGuard;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.ast.CharacterClass;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.ast.LookAheadAssertion;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.ast.LookBehindAssertion;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.ast.MatchFound;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.ast.PositionAssertion;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.ast.RegexAST;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.ast.RegexASTNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.ast.Term;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.ast.visitors.NFATraversalRegexASTVisitor;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.util.TBitSet;
import org.cyclops.integratedscripting.vendors.org.graalvm.collections.EconomicMap;

public final class ASTStepVisitor
extends NFATraversalRegexASTVisitor {
    private ASTStep stepCur;
    private final EconomicMap<ASTStepCacheKey, ASTStep> lookAheadMap = EconomicMap.create();
    private final List<ASTStep> curLookAheads = new ArrayList<ASTStep>();
    private final List<ASTStep> curLookBehinds = new ArrayList<ASTStep>();
    private final Deque<ASTStep> lookAroundExpansionQueue = new ArrayDeque<ASTStep>();
    private final LongArrayBuffer constraintsBuilder = new LongArrayBuffer();
    private final LongArrayBuffer operationsBuilder = new LongArrayBuffer();

    public ASTStepVisitor(RegexAST ast) {
        super(ast);
    }

    public ASTStep step(NFAState expandState) {
        ASTStep stepRoot = null;
        assert (this.curLookAheads.isEmpty());
        assert (this.curLookBehinds.isEmpty());
        assert (this.lookAroundExpansionQueue.isEmpty());
        for (RegexASTNode t : expandState.getStateSet()) {
            if (t.isInLookAheadAssertion()) {
                ASTStep laStep = new ASTStep(t, expandState.getMatchedConditionGroups(t));
                this.curLookAheads.add(laStep);
                this.lookAroundExpansionQueue.push(laStep);
                continue;
            }
            if (t.isInLookBehindAssertion()) {
                ASTStep lbStep = new ASTStep(t, expandState.getMatchedConditionGroups(t));
                this.curLookBehinds.add(lbStep);
                this.lookAroundExpansionQueue.push(lbStep);
                continue;
            }
            assert (stepRoot == null);
            stepRoot = new ASTStep(t, expandState.getMatchedConditionGroups(t));
        }
        if (stepRoot == null) {
            if (this.curLookAheads.isEmpty()) {
                assert (!this.curLookBehinds.isEmpty());
                ASTStep noSuccessors = this.curLookBehinds.get(0);
                this.curLookBehinds.clear();
                this.lookAroundExpansionQueue.clear();
                return noSuccessors;
            }
            stepRoot = this.curLookAheads.get(this.curLookAheads.size() - 1);
            this.curLookAheads.remove(this.curLookAheads.size() - 1);
            this.lookAroundExpansionQueue.remove(stepRoot);
        }
        this.stepCur = stepRoot;
        Term root = (Term)stepRoot.getRoot();
        this.setTraversableLookBehindAssertions(expandState.getFinishedLookBehinds());
        this.setCanTraverseCaret(root instanceof PositionAssertion && this.ast.getNfaAnchoredInitialStates().contains(root));
        this.setMatchedConditionGroups(this.stepCur.getMatchedConditionGroups());
        this.run(root);
        this.curLookAheads.clear();
        this.curLookBehinds.clear();
        while (!this.lookAroundExpansionQueue.isEmpty()) {
            this.stepCur = this.lookAroundExpansionQueue.pop();
            this.setMatchedConditionGroups(this.stepCur.getMatchedConditionGroups());
            root = (Term)this.stepCur.getRoot();
            this.run(root);
        }
        return stepRoot;
    }

    @Override
    protected void visit(RegexASTNode target) {
        assert (ASTStepVisitor.allGuardsAllowedInDFA(this.getTransitionGuardsOnPath()));
        ASTSuccessor successor = new ASTSuccessor();
        long[] guards = this.getTransitionGuardsOnPath();
        this.operationsBuilder.clear();
        this.constraintsBuilder.clear();
        int id = this.needsMaintainGuard();
        if (id != -1) {
            if (id > Short.MAX_VALUE) {
                throw new UnsupportedRegexException("too many quantifiers");
            }
            this.operationsBuilder.add(TransitionOp.create(id, 0, 0, 0));
        }
        block7: for (long guard : guards) {
            switch (TransitionGuard.getKind(guard)) {
                case countLtMax: {
                    this.constraintsBuilder.add(TransitionConstraint.create(ASTStepVisitor.getQuantifierIndex(guard), 0, 0));
                    continue block7;
                }
                case countGeMin: {
                    this.constraintsBuilder.add(TransitionConstraint.create(ASTStepVisitor.getQuantifierIndex(guard), 0, 2));
                    continue block7;
                }
                case countLtMin: {
                    this.constraintsBuilder.add(TransitionConstraint.create(ASTStepVisitor.getQuantifierIndex(guard), 0, 4));
                    continue block7;
                }
                case countInc: {
                    this.operationsBuilder.add(TransitionOp.create(ASTStepVisitor.getQuantifierIndex(guard), 0, 0, 1));
                    continue block7;
                }
                case countSet1: {
                    this.operationsBuilder.add(TransitionOp.create(ASTStepVisitor.getQuantifierIndex(guard), 0, 0, 2));
                }
            }
        }
        ASTTransition transition = new ASTTransition(this.ast.getLanguage(), this.constraintsBuilder.toArray(), this.operationsBuilder.toArray());
        transition.setGroupBoundaries(this.getGroupBoundaries());
        TBitSet matchedConditionGroups = this.getCurrentMatchedConditionGroups();
        transition.setMatchedConditionGroups(matchedConditionGroups);
        if (this.dollarsOnPath()) {
            assert (target instanceof MatchFound);
            transition.setTarget(target.getSubTreeParent().getAnchoredFinalState());
        } else if (target instanceof CharacterClass) {
            CharacterClass charClass = (CharacterClass)target;
            if (!charClass.getLookBehindEntries().isEmpty()) {
                ArrayList<ASTStep> newLookBehinds = new ArrayList<ASTStep>(charClass.getLookBehindEntries().size());
                for (LookBehindAssertion lb : charClass.getLookBehindEntries()) {
                    ASTStep lbAstStep = new ASTStep(lb.getGroup(), matchedConditionGroups);
                    assert (lb.getGroup().isLiteral());
                    ASTTransition lbAstTransition = new ASTTransition(this.ast.getLanguage(), lb.getGroup().getFirstAlternative().getFirstTerm(), TransitionConstraint.NO_CONSTRAINTS, TransitionOp.NO_OP);
                    lbAstTransition.setMatchedConditionGroups(matchedConditionGroups);
                    lbAstStep.addSuccessor(new ASTSuccessor(lbAstTransition));
                    newLookBehinds.add(lbAstStep);
                }
                successor.setLookBehinds(newLookBehinds);
            }
            transition.setTarget(charClass);
        } else {
            assert (target instanceof MatchFound);
            transition.setTarget((MatchFound)target);
        }
        successor.setInitialTransition(transition);
        if (!this.curLookAheads.isEmpty()) {
            successor.setLookAheads(new ArrayList<ASTStep>(this.curLookAheads));
        }
        if (!this.curLookBehinds.isEmpty()) {
            successor.addLookBehinds(this.curLookBehinds);
        }
        this.stepCur.addSuccessor(successor);
    }

    private static int getQuantifierIndex(long guard) {
        int quantifierIndex = TransitionGuard.getQuantifierIndex(guard);
        if (quantifierIndex > Short.MAX_VALUE) {
            throw new UnsupportedRegexException("too many quantifiers");
        }
        return quantifierIndex;
    }

    private static boolean allGuardsAllowedInDFA(long[] transitionGuards) {
        for (long guard : transitionGuards) {
            if (TransitionGuard.is(guard, TransitionGuard.Kind.updateCG) || TransitionGuard.is(guard, TransitionGuard.Kind.enterZeroWidth) || TransitionGuard.isQuantifierGuardAllowedInDFA(guard)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void enterLookAhead(LookAheadAssertion assertion) {
        TBitSet currentMatchedConditionGroups = this.getCurrentMatchedConditionGroups();
        currentMatchedConditionGroups.intersect(assertion.getReferencedConditionGroups());
        ASTStepCacheKey key = new ASTStepCacheKey(assertion, this.canTraverseCaret(), this.getTraversableLookBehindAssertions(), currentMatchedConditionGroups);
        ASTStep laStep = (ASTStep)this.lookAheadMap.get(key);
        if (laStep == null) {
            laStep = new ASTStep(assertion.getGroup(), currentMatchedConditionGroups);
            this.lookAroundExpansionQueue.push(laStep);
            this.lookAheadMap.put(key, laStep);
        }
        this.curLookAheads.add(laStep);
    }

    @Override
    protected void leaveLookAhead(LookAheadAssertion assertion) {
        assert (this.curLookAheads.get(this.curLookAheads.size() - 1).getRoot().getParent() == assertion);
        this.curLookAheads.remove(this.curLookAheads.size() - 1);
    }

    @Override
    protected boolean isBuildingDFA() {
        return true;
    }

    @Override
    protected boolean canPruneAfterUnconditionalFinalState() {
        return true;
    }

    private static class ASTStepCacheKey {
        private final RegexASTNode root;
        private final boolean canTraverseCaret;
        private final Set<LookBehindAssertion> traversableLookBehindAssertions;
        private final TBitSet matchedConditionGroups;

        ASTStepCacheKey(RegexASTNode root, boolean canTraverseCaret, Set<LookBehindAssertion> traversableLookBehindAssertions, TBitSet matchedConditionGroups) {
            this.root = root;
            this.canTraverseCaret = canTraverseCaret;
            this.traversableLookBehindAssertions = traversableLookBehindAssertions;
            this.matchedConditionGroups = matchedConditionGroups;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ASTStepCacheKey)) {
                return false;
            }
            ASTStepCacheKey that = (ASTStepCacheKey)obj;
            return this.root.equals(that.root) && this.canTraverseCaret == that.canTraverseCaret && this.traversableLookBehindAssertions.equals(that.traversableLookBehindAssertions) && this.matchedConditionGroups.equals(that.matchedConditionGroups);
        }

        public int hashCode() {
            return this.root.hashCode() + 31 * (Boolean.hashCode(this.canTraverseCaret) + 31 * (this.traversableLookBehindAssertions.hashCode() + 31 * this.matchedConditionGroups.hashCode()));
        }
    }
}

