/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.automaton;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.buffer.LongArrayBuffer;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.util.json.Json;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.util.json.JsonValue;

public class TransitionOp {
    public static final int NO_SOURCE = 65535;
    public static final long[] NO_OP = new long[0];
    public static final int maintain = 0;
    public static final int inc = 1;
    public static final int set1 = 2;
    public static final int noModifier = 0;
    public static final int overwrite = 1;
    public static final int union = 2;
    public static final int swap = 3;
    private static final int OFFSET_SOURCE = 0;
    private static final int OFFSET_TARGET = 16;
    private static final int OFFSET_MODIFIER = 32;
    private static final int OFFSET_KIND = 34;
    private static final int OFFSET_QUANTIFIER_ID = 36;
    private static final int MASK_ID = 65535;
    private static final int MASK_MODIFIER = 3;
    private static final int MASK_KIND = 3;

    public static long create(int qId, int source, int target, int kind) {
        return TransitionOp.create(qId, source, target, kind, 0);
    }

    public static long create(int qId, int source, int target, int kind, int modifier) {
        assert ((qId & 0xFFFF) == qId);
        assert ((source & 0xFFFF) == source);
        assert ((target & 0xFFFF) == target);
        long actualSource = source;
        if (kind == 2) {
            actualSource = 65535L;
        }
        return (long)qId << 36 | (long)kind << 34 | (long)modifier << 32 | (long)target << 16 | actualSource << 0;
    }

    public static long setTarget(long op, int newTarget) {
        return TransitionOp.create(TransitionOp.getQuantifierID(op), TransitionOp.getSource(op), newTarget, TransitionOp.getKind(op), TransitionOp.getModifier(op));
    }

    public static long setSourceAndTarget(long op, int newSource, int newTarget) {
        return TransitionOp.create(TransitionOp.getQuantifierID(op), newSource, newTarget, TransitionOp.getKind(op), TransitionOp.getModifier(op));
    }

    public static void normalize(LongArrayBuffer operations) {
        operations.sort();
        long prev = -1L;
        int cursor = 0;
        for (Long op : operations) {
            if (prev == op) continue;
            operations.set(cursor, op);
            prev = op;
            ++cursor;
        }
        operations.setLength(cursor);
    }

    public static int getSource(long op) {
        int result = (int)(op >> 0 & 0xFFFFL);
        int operation = TransitionOp.getKind(op);
        assert (operation != 2 || result == 65535);
        return result;
    }

    public static int getTarget(long op) {
        return (int)(op >> 16 & 0xFFFFL);
    }

    public static int getKind(long op) {
        return (int)(op >> 34 & 3L);
    }

    public static int getQuantifierID(long op) {
        return (int)(op >>> 36 & 0xFFFFL);
    }

    public static long setModifier(int modifier, long op) {
        assert (modifier >= 0 && modifier < 4);
        assert (TransitionOp.getModifier(op) == 0);
        return (long)modifier << 32 | op;
    }

    public static int getModifier(long op) {
        return (int)(op >> 32 & 3L);
    }

    @CompilerDirectives.TruffleBoundary
    public static String toString(long operation) {
        int sourceId = TransitionOp.getSource(operation);
        int targetId = TransitionOp.getTarget(operation);
        int modifier = TransitionOp.getModifier(operation);
        int op = TransitionOp.getKind(operation);
        StringBuilder builder = new StringBuilder("qId: %d, %d ".formatted(TransitionOp.getQuantifierID(operation), targetId));
        switch (modifier) {
            case 1: {
                builder.append("= ");
                break;
            }
            case 0: {
                builder.append("<- ");
                break;
            }
            case 2: {
                builder.append("= %d \u22c3 ".formatted(targetId));
                break;
            }
            case 3: {
                builder.append("<-> ");
                break;
            }
            default: {
                throw CompilerDirectives.shouldNotReachHere();
            }
        }
        switch (op) {
            case 1: {
                builder.append("inc(%d)".formatted(sourceId));
                break;
            }
            case 2: {
                builder.append("set1");
                break;
            }
            case 0: {
                builder.append(sourceId);
                break;
            }
            default: {
                throw CompilerDirectives.shouldNotReachHere();
            }
        }
        return builder.toString();
    }

    @CompilerDirectives.TruffleBoundary
    public static JsonValue toJson(long op) {
        return Json.val(TransitionOp.toString(op));
    }
}

