/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.flavor.js;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.RegexFlags;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.RegexLanguage;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.RegexSource;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.charset.UnicodeProperties;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.charset.UnicodePropertyDataVersion;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.flavor.js.JSRegexLexer;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.flavor.js.JSRegexParser;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.flavor.js.JSRegexValidator;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.buffer.CompilationBuffer;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.CaseFoldData;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.RegexFlavor;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.RegexLexer;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.RegexParser;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.RegexValidator;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.ast.RegexAST;

public final class ECMAScriptFlavor
extends RegexFlavor {
    public static final ECMAScriptFlavor INSTANCE = new ECMAScriptFlavor();
    public static final UnicodeProperties UNICODE = new UnicodeProperties(UnicodePropertyDataVersion.UNICODE_16_0_0, 0, UnicodeProperties.NameMatchingMode.exact);

    private ECMAScriptFlavor() {
        super(0);
    }

    @Override
    public String getName() {
        return "ECMAScript";
    }

    @Override
    public RegexValidator createValidator(RegexLanguage language, RegexSource source, CompilationBuffer compilationBuffer) {
        return new JSRegexValidator(language, source, compilationBuffer);
    }

    @Override
    public RegexLexer createLexer(RegexSource source, CompilationBuffer compilationBuffer) {
        return new JSRegexLexer(source, RegexFlags.parseFlags(source), compilationBuffer);
    }

    @Override
    public RegexParser createParser(RegexLanguage language, RegexSource source, CompilationBuffer compilationBuffer) {
        return new JSRegexParser(language, source, compilationBuffer);
    }

    @Override
    public RegexFlavor.EqualsIgnoreCasePredicate getEqualsIgnoreCasePredicate(RegexAST ast) {
        if (ast.getFlags().isEitherUnicode()) {
            return (a, b, altMode) -> CaseFoldData.CaseFoldUnfoldAlgorithm.ECMAScriptUnicode.getEqualsPredicate().test(a, b);
        }
        return (a, b, altMode) -> CaseFoldData.CaseFoldUnfoldAlgorithm.ECMAScriptNonUnicode.getEqualsPredicate().test(a, b);
    }

    @Override
    public CaseFoldData.CaseFoldAlgorithm getCaseFoldAlgorithm(RegexAST ast) {
        throw CompilerDirectives.shouldNotReachHere();
    }
}

