/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.InteropLibrary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.UnknownIdentifierException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.library.ExportLibrary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.library.ExportMessage;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.AbstractConstantKeysObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.RegexSource;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.RegexSyntaxException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.util.json.Json;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.util.json.JsonConvertible;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.util.json.JsonValue;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.util.TBitSet;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.util.TruffleReadOnlyKeysArray;

@ExportLibrary(value=InteropLibrary.class)
public final class RegexFlags
extends AbstractConstantKeysObject
implements JsonConvertible {
    private static final String PROP_SOURCE = "source";
    private static final String PROP_IGNORE_CASE = "ignoreCase";
    private static final String PROP_MULTILINE = "multiline";
    private static final String PROP_STICKY = "sticky";
    private static final String PROP_GLOBAL = "global";
    private static final String PROP_UNICODE = "unicode";
    private static final String PROP_DOT_ALL = "dotAll";
    private static final String PROP_HAS_INDICES = "hasIndices";
    private static final String PROP_UNICODE_SETS = "unicodeSets";
    private static final TruffleReadOnlyKeysArray KEYS = new TruffleReadOnlyKeysArray("source", "ignoreCase", "multiline", "sticky", "global", "unicode", "dotAll", "hasIndices", "unicodeSets");
    private static final TBitSet ALL_FLAG_CHARS = TBitSet.valueOf(100, 103, 105, 109, 115, 117, 118, 121);
    private static final TBitSet LOCAL_FLAG_CHARS = TBitSet.valueOf(105, 109, 115);
    private static final int NONE = 0;
    private static final int IGNORE_CASE = 1;
    private static final int MULTILINE = 2;
    private static final int STICKY = 4;
    private static final int GLOBAL = 8;
    private static final int UNICODE = 16;
    private static final int DOT_ALL = 32;
    private static final int HAS_INDICES = 64;
    private static final int UNICODE_SETS = 128;
    private static final int[] FLAG_LOOKUP = new int[]{64, 0, 0, 8, 0, 1, 0, 0, 0, 2, 0, 0, 0, 0, 0, 32, 0, 16, 128, 0, 0, 4};
    public static final RegexFlags DEFAULT = new RegexFlags("", 0);
    private final String source;
    private final int value;

    private RegexFlags(String source, int value) {
        this.source = source;
        this.value = value;
    }

    private RegexFlags(int value) {
        this.source = RegexFlags.generateSource(value);
        this.value = value;
    }

    private static int maskForFlag(char flagChar) {
        assert (ALL_FLAG_CHARS.get(flagChar));
        return FLAG_LOOKUP[flagChar - 100];
    }

    public static Builder builder() {
        return new Builder();
    }

    @CompilerDirectives.TruffleBoundary
    public static RegexFlags parseFlags(RegexSource source) throws RegexSyntaxException {
        String flagsStr = source.getFlags();
        if (flagsStr.isEmpty()) {
            return DEFAULT;
        }
        int flags = 0;
        for (int i = 0; i < flagsStr.length(); ++i) {
            char ch = flagsStr.charAt(i);
            if (!RegexFlags.isValidFlagChar(ch)) {
                throw RegexSyntaxException.createFlags(source, "Invalid regular expression flags", i);
            }
            int flag = RegexFlags.maskForFlag(ch);
            if ((flags & flag) != 0) {
                throw RegexSyntaxException.createFlags(source, "Repeated regex flag", i);
            }
            if (((flags |= flag) & 0x90) != 144) continue;
            throw RegexSyntaxException.createFlags(source, "Both flags 'u' and 'v' cannot be set at same time", i);
        }
        return new RegexFlags(flagsStr, flags);
    }

    public String getSource() {
        return this.source;
    }

    public boolean isIgnoreCase() {
        return this.isSet(1);
    }

    public boolean isMultiline() {
        return this.isSet(2);
    }

    public boolean isSticky() {
        return this.isSet(4);
    }

    public boolean isGlobal() {
        return this.isSet(8);
    }

    public boolean isUnicode() {
        return this.isSet(16);
    }

    public boolean isDotAll() {
        return this.isSet(32);
    }

    public boolean hasIndices() {
        return this.isSet(64);
    }

    public boolean isUnicodeSets() {
        return this.isSet(128);
    }

    public boolean isEitherUnicode() {
        return this.isSet(144);
    }

    public boolean isNone() {
        return this.value == 0;
    }

    private boolean isSet(int flag) {
        return (this.value & flag) != 0;
    }

    public static boolean isValidFlagChar(char candidateChar) {
        return ALL_FLAG_CHARS.get(candidateChar);
    }

    public static boolean isValidLocalFlagChar(char candidateChar) {
        return LOCAL_FLAG_CHARS.get(candidateChar);
    }

    public RegexFlags addNewFlagModifier(RegexSource regexSource, char flagChar) {
        int flag = RegexFlags.maskForFlag(flagChar);
        if (this.isSet(flag)) {
            throw RegexSyntaxException.createFlags(regexSource, "Repeated regex flag in modifier");
        }
        return new RegexFlags(this.value | flag);
    }

    public RegexFlags addFlags(RegexFlags otherFlags) {
        return new RegexFlags(this.value | otherFlags.value);
    }

    public RegexFlags delFlags(RegexFlags otherFlags) {
        return new RegexFlags(this.value & ~otherFlags.value);
    }

    public boolean overlaps(RegexFlags otherFlags) {
        return (this.value & otherFlags.value) != 0;
    }

    public String toString() {
        return this.source;
    }

    public int hashCode() {
        return this.value;
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof RegexFlags && this.value == ((RegexFlags)obj).value;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public JsonValue toJson() {
        return Json.obj(Json.prop(PROP_IGNORE_CASE, this.isIgnoreCase()), Json.prop(PROP_MULTILINE, this.isMultiline()), Json.prop(PROP_GLOBAL, this.isGlobal()), Json.prop(PROP_STICKY, this.isSticky()), Json.prop(PROP_UNICODE, this.isUnicode()), Json.prop(PROP_DOT_ALL, this.isDotAll()), Json.prop(PROP_HAS_INDICES, this.hasIndices()), Json.prop(PROP_UNICODE_SETS, this.isUnicodeSets()));
    }

    @Override
    public TruffleReadOnlyKeysArray getKeys() {
        return KEYS;
    }

    @Override
    public boolean isMemberReadableImpl(String symbol) {
        switch (symbol) {
            case "source": 
            case "ignoreCase": 
            case "multiline": 
            case "sticky": 
            case "global": 
            case "unicode": 
            case "dotAll": 
            case "hasIndices": 
            case "unicodeSets": {
                return true;
            }
        }
        return false;
    }

    @Override
    public Object readMemberImpl(String symbol) throws UnknownIdentifierException {
        switch (symbol) {
            case "source": {
                return this.getSource();
            }
            case "ignoreCase": {
                return this.isIgnoreCase();
            }
            case "multiline": {
                return this.isMultiline();
            }
            case "sticky": {
                return this.isSticky();
            }
            case "global": {
                return this.isGlobal();
            }
            case "unicode": {
                return this.isUnicode();
            }
            case "dotAll": {
                return this.isDotAll();
            }
            case "hasIndices": {
                return this.hasIndices();
            }
            case "unicodeSets": {
                return this.isUnicodeSets();
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw UnknownIdentifierException.create(symbol);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    @ExportMessage
    public Object toDisplayString(boolean allowSideEffects) {
        return "TRegexJSFlags{flags=" + this.toString() + "}";
    }

    private static String generateSource(int value) {
        StringBuilder sb = new StringBuilder(8);
        if ((value & 1) != 0) {
            sb.append("i");
        }
        if ((value & 2) != 0) {
            sb.append("m");
        }
        if ((value & 4) != 0) {
            sb.append("y");
        }
        if ((value & 8) != 0) {
            sb.append("g");
        }
        if ((value & 0x10) != 0) {
            sb.append("u");
        }
        if ((value & 0x20) != 0) {
            sb.append("s");
        }
        if ((value & 0x40) != 0) {
            sb.append("d");
        }
        if ((value & 0x80) != 0) {
            sb.append("v");
        }
        return sb.toString();
    }

    public static final class Builder {
        private int value;

        private Builder() {
        }

        public Builder ignoreCase(boolean enabled) {
            this.updateFlag(enabled, 1);
            return this;
        }

        public Builder multiline(boolean enabled) {
            this.updateFlag(enabled, 2);
            return this;
        }

        public Builder sticky(boolean enabled) {
            this.updateFlag(enabled, 4);
            return this;
        }

        public Builder global(boolean enabled) {
            this.updateFlag(enabled, 8);
            return this;
        }

        public Builder unicode(boolean enabled) {
            if (enabled) {
                this.updateFlag(false, 128);
            }
            this.updateFlag(enabled, 16);
            return this;
        }

        public Builder dotAll(boolean enabled) {
            this.updateFlag(enabled, 32);
            return this;
        }

        public Builder hasIndices(boolean enabled) {
            this.updateFlag(enabled, 64);
            return this;
        }

        public Builder unicodeSets(boolean enabled) {
            if (enabled) {
                this.updateFlag(false, 16);
            }
            this.updateFlag(enabled, 128);
            return this;
        }

        @CompilerDirectives.TruffleBoundary
        public RegexFlags build() {
            return new RegexFlags(RegexFlags.generateSource(this.value), this.value);
        }

        private void updateFlag(boolean enabled, int bitMask) {
            this.value = enabled ? (this.value |= bitMask) : (this.value &= ~bitMask);
        }
    }
}

