/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.util;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerAsserts;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Cached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.GenerateCached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.GenerateInline;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.GenerateUncached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.ImportStatic;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.NeverDefault;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.ArityException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.InteropLibrary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.InvalidArrayIndexException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.UnknownIdentifierException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.UnsupportedMessageException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.UnsupportedTypeException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.library.CachedLibrary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.lang.JavaScriptLanguage;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JSGuards;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Strings;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.Undefined;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.util.TRegexUtilFactory;

public final class TRegexUtil {
    private static final String NUMBER_OF_REGEX_RESULT_TYPES = "9";

    private TRegexUtil() {
    }

    public static final class TRegexMaterializeResult {
        private TRegexMaterializeResult() {
        }

        public static Object materializeGroupUncached(Object regexResult, int i, TruffleString input) {
            return TRegexMaterializeResult.materializeGroup(JavaScriptLanguage.get(null).getJSContext(), regexResult, i, input, null, TruffleString.SubstringByteIndexNode.getUncached(), InvokeGetGroupBoundariesMethodNode.getUncached(), InvokeGetGroupBoundariesMethodNode.getUncached());
        }

        public static Object materializeGroupUncached(Object regexResult, int[] indices, TruffleString input) {
            return TRegexMaterializeResult.materializeGroup(JavaScriptLanguage.get(null).getJSContext(), regexResult, indices, input, null, TruffleString.SubstringByteIndexNode.getUncached(), InvokeGetGroupBoundariesMethodNode.getUncached(), InvokeGetGroupBoundariesMethodNode.getUncached());
        }

        public static Object materializeGroup(JSContext context, Object regexResult, int i, TruffleString input, Node node, TruffleString.SubstringByteIndexNode substringNode, InvokeGetGroupBoundariesMethodNode getStart, InvokeGetGroupBoundariesMethodNode getEnd) {
            int beginIndex = TRegexResultAccessor.captureGroupStart(regexResult, i, node, getStart);
            if (beginIndex == -1) {
                assert (i > 0);
                return Undefined.instance;
            }
            int endIndex = TRegexResultAccessor.captureGroupEnd(regexResult, i, node, getEnd);
            return Strings.substring(context, substringNode, input, beginIndex, endIndex - beginIndex);
        }

        public static Object materializeGroup(JSContext context, Object regexResult, int[] indices, TruffleString input, Node node, TruffleString.SubstringByteIndexNode substringNode, InvokeGetGroupBoundariesMethodNode getStart, InvokeGetGroupBoundariesMethodNode getEnd) {
            for (int i : indices) {
                int beginIndex = TRegexResultAccessor.captureGroupStart(regexResult, i, node, getStart);
                if (beginIndex == -1) continue;
                int endIndex = TRegexResultAccessor.captureGroupEnd(regexResult, i, node, getEnd);
                return Strings.substring(context, substringNode, input, beginIndex, endIndex - beginIndex);
            }
            return Undefined.instance;
        }

        public static Object[] materializeFull(JSContext context, Object regexResult, int groupCount, TruffleString input, Node node, TruffleString.SubstringByteIndexNode substringNode, InvokeGetGroupBoundariesMethodNode getStart, InvokeGetGroupBoundariesMethodNode getEnd) {
            Object[] result = new Object[groupCount];
            for (int i = 0; i < groupCount; ++i) {
                result[i] = TRegexMaterializeResult.materializeGroup(context, regexResult, i, input, node, substringNode, getStart, getEnd);
            }
            return result;
        }

        public static Object[] materializeFullUncached(Object regexResult, int groupCount, TruffleString input) {
            return TRegexMaterializeResult.materializeFull(JavaScriptLanguage.get(null).getJSContext(), regexResult, groupCount, input, null, TruffleString.SubstringByteIndexNode.getUncached(), InvokeGetGroupBoundariesMethodNode.getUncached(), InvokeGetGroupBoundariesMethodNode.getUncached());
        }
    }

    public static final class TRegexResultAccessor {
        private TRegexResultAccessor() {
        }

        public static boolean isMatch(Object result, Node node, InteropReadBooleanMemberNode readIsMatch) {
            return readIsMatch.execute(node, result, "isMatch");
        }

        public static int groupCount(Object compiledRegex, Node node, InteropReadIntMemberNode readGroupCount) {
            return readGroupCount.execute(node, compiledRegex, "groupCount");
        }

        public static int captureGroupStart(Object result, int groupNumber, Node node, InvokeGetGroupBoundariesMethodNode getStart) {
            return getStart.execute(node, result, "getStart", groupNumber);
        }

        public static int captureGroupEnd(Object result, int groupNumber, Node node, InvokeGetGroupBoundariesMethodNode getEnd) {
            return getEnd.execute(node, result, "getEnd", groupNumber);
        }

        public static int captureGroupLength(Object regexResultObject, int groupNumber, Node node, InvokeGetGroupBoundariesMethodNode getStart, InvokeGetGroupBoundariesMethodNode getEnd) {
            return TRegexResultAccessor.captureGroupEnd(regexResultObject, groupNumber, node, getStart) - TRegexResultAccessor.captureGroupStart(regexResultObject, groupNumber, node, getEnd);
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class TRegexCompiledRegexSingleFlagAccessorNode
    extends Node {
        public abstract boolean execute(Node var1, Object var2, String var3);

        @Specialization
        static boolean get(Node node, Object compiledRegex, String flag, @Cached InteropReadMemberNode readFlagsObjectNode, @Cached InteropReadBooleanMemberNode readFlagNode) {
            CompilerAsserts.partialEvaluationConstant(flag);
            return readFlagNode.execute(node, readFlagsObjectNode.execute(node, compiledRegex, "flags"), flag);
        }
    }

    public static final class TRegexFlagsAccessor {
        private TRegexFlagsAccessor() {
        }

        public static Object source(Object regexFlagsObject, Node node, InteropReadStringMemberNode readSourceNode) {
            return readSourceNode.execute(node, regexFlagsObject, "source");
        }

        public static boolean global(Object regexFlagsObject, Node node, InteropReadBooleanMemberNode readGlobalNode) {
            return readGlobalNode.execute(node, regexFlagsObject, "global");
        }

        public static boolean multiline(Object regexFlagsObject, Node node, InteropReadBooleanMemberNode readMultilineNode) {
            return readMultilineNode.execute(node, regexFlagsObject, "multiline");
        }

        public static boolean ignoreCase(Object regexFlagsObject, Node node, InteropReadBooleanMemberNode readIgnoreCaseNode) {
            return readIgnoreCaseNode.execute(node, regexFlagsObject, "ignoreCase");
        }

        public static boolean sticky(Object regexFlagsObject, Node node, InteropReadBooleanMemberNode readStickyNode) {
            return readStickyNode.execute(node, regexFlagsObject, "sticky");
        }

        public static boolean unicode(Object regexFlagsObject, Node node, InteropReadBooleanMemberNode readUnicodeNode) {
            return readUnicodeNode.execute(node, regexFlagsObject, "unicode");
        }

        public static boolean dotAll(Object regexFlagsObject, Node node, InteropReadBooleanMemberNode readDotAllNode) {
            return readDotAllNode.execute(node, regexFlagsObject, "dotAll");
        }

        public static boolean hasIndices(Object regexFlagsObject, Node node, InteropReadBooleanMemberNode readHasIndicesNode) {
            return readHasIndicesNode.execute(node, regexFlagsObject, "hasIndices");
        }

        public static boolean unicodeSets(Object regexFlagsObject, Node node, InteropReadBooleanMemberNode readUnicodeSetsNode) {
            return readUnicodeSetsNode.execute(node, regexFlagsObject, "unicodeSets");
        }
    }

    public static final class TRegexNamedCaptureGroupsAccessor {
        private TRegexNamedCaptureGroupsAccessor() {
        }

        public static boolean hasGroup(Object namedCaptureGroupsMap, TruffleString name, InteropLibrary interop) {
            return interop.isMemberReadable(namedCaptureGroupsMap, Strings.toJavaString(name));
        }

        public static int[] getGroupNumbers(Object namedCaptureGroupsMap, TruffleString name, InteropLibrary libMap, InteropLibrary libArray, InteropToIntNode toIntNode, Node node) {
            try {
                Object interopArray = libMap.readMember(namedCaptureGroupsMap, Strings.toJavaString(name));
                int length = (int)libArray.getArraySize(interopArray);
                int[] array = new int[length];
                for (int i = 0; i < length; ++i) {
                    array[i] = toIntNode.execute(node, libArray.readArrayElement(interopArray, i));
                }
                return array;
            }
            catch (InvalidArrayIndexException | UnknownIdentifierException | UnsupportedMessageException e) {
                throw CompilerDirectives.shouldNotReachHere(e);
            }
        }
    }

    public static final class TRegexCompiledRegexAccessor {
        private TRegexCompiledRegexAccessor() {
        }

        public static Object pattern(Object compiledRegexObject, Node node, InteropReadStringMemberNode readPattern) {
            return readPattern.execute(node, compiledRegexObject, "pattern");
        }

        public static Object flags(Object compiledRegexObject, Node node, InteropReadMemberNode readFlags) {
            return readFlags.execute(node, compiledRegexObject, "flags");
        }

        public static Object exec(Object compiledRegexObject, Object input, long fromIndex, Node node, InvokeExecMethodNode invokeExec) {
            return invokeExec.execute(node, compiledRegexObject, input, fromIndex);
        }

        public static int groupCount(Object regexResultObject, Node node, InteropReadIntMemberNode readGroupCount) {
            return readGroupCount.execute(node, regexResultObject, "groupCount");
        }

        public static Object namedCaptureGroups(Object compiledRegexObject, Node node, InteropReadMemberNode readGroups) {
            return readGroups.execute(node, compiledRegexObject, "groups");
        }
    }

    @GenerateCached
    @GenerateInline(inlineByDefault=true)
    @GenerateUncached
    public static abstract class InvokeGetGroupBoundariesMethodNode
    extends Node {
        public abstract int execute(Node var1, Object var2, Object var3, int var4);

        @Specialization(guards={"objs.isMemberInvocable(regexResult, method)"}, limit="9")
        static int exec(Node node, Object regexResult, String method, int groupNumber, @CachedLibrary(value="regexResult") InteropLibrary objs, @Cached InteropToIntNode toIntNode) {
            try {
                return toIntNode.execute(node, objs.invokeMember(regexResult, method, groupNumber));
            }
            catch (ArityException | UnknownIdentifierException | UnsupportedMessageException | UnsupportedTypeException e) {
                throw CompilerDirectives.shouldNotReachHere(e);
            }
        }

        @NeverDefault
        public static InvokeGetGroupBoundariesMethodNode create() {
            return TRegexUtilFactory.InvokeGetGroupBoundariesMethodNodeGen.create();
        }

        public static InvokeGetGroupBoundariesMethodNode getUncached() {
            return TRegexUtilFactory.InvokeGetGroupBoundariesMethodNodeGen.getUncached();
        }
    }

    @GenerateCached(value=false)
    @GenerateInline
    @GenerateUncached
    @ImportStatic(value={Props.CompiledRegex.class})
    public static abstract class InvokeExecMethodNode
    extends Node {
        public abstract Object execute(Node var1, Object var2, Object var3, long var4);

        @Specialization(guards={"objs.isMemberInvocable(compiledRegex, EXEC)"}, limit="3")
        static Object exec(Object compiledRegex, Object input, long fromIndex, @CachedLibrary(value="compiledRegex") InteropLibrary objs) {
            try {
                return objs.invokeMember(compiledRegex, "exec", input, fromIndex);
            }
            catch (ArityException | UnknownIdentifierException | UnsupportedMessageException | UnsupportedTypeException e) {
                throw CompilerDirectives.shouldNotReachHere(e);
            }
        }

        public static InvokeExecMethodNode getUncached() {
            return TRegexUtilFactory.InvokeExecMethodNodeGen.getUncached();
        }
    }

    @GenerateCached(value=false)
    @GenerateInline
    @GenerateUncached
    @ImportStatic(value={JSGuards.class})
    public static abstract class InteropToStringNode
    extends Node {
        public abstract TruffleString execute(Node var1, Object var2);

        @Specialization
        static TruffleString coerceJavaString(String obj, @Cached(inline=false) TruffleString.FromJavaStringNode fromJavaStringNode) {
            return Strings.fromJavaString(fromJavaStringNode, obj);
        }

        @Specialization
        static TruffleString coerceDirect(TruffleString obj, @Cached @Cached.Shared TruffleString.SwitchEncodingNode switchEncoding) {
            return switchEncoding.execute(obj, TruffleString.Encoding.UTF_16);
        }

        @Specialization(guards={"!isTruffleString(obj)", "objs.isString(obj)"}, limit="3")
        static TruffleString coerce(Object obj, @CachedLibrary(value="obj") InteropLibrary objs, @Cached @Cached.Shared TruffleString.SwitchEncodingNode switchEncoding) {
            return Strings.interopAsTruffleString(obj, objs, switchEncoding);
        }
    }

    @GenerateCached
    @GenerateInline(inlineByDefault=true)
    @GenerateUncached
    public static abstract class InteropToIntNode
    extends Node {
        public abstract int execute(Node var1, Object var2);

        @Specialization
        static int coerceDirect(int obj) {
            return obj;
        }

        @Specialization(guards={"objs.fitsInInt(obj)"}, limit="3")
        static int coerce(Object obj, @CachedLibrary(value="obj") InteropLibrary objs) {
            try {
                return objs.asInt(obj);
            }
            catch (UnsupportedMessageException e) {
                throw CompilerDirectives.shouldNotReachHere(e);
            }
        }
    }

    @GenerateCached(value=false)
    @GenerateInline
    @GenerateUncached
    public static abstract class InteropToBooleanNode
    extends Node {
        public abstract boolean execute(Node var1, Object var2);

        @Specialization
        static boolean coerceDirect(boolean obj) {
            return obj;
        }

        @Specialization(guards={"objs.isBoolean(obj)"}, limit="3")
        static boolean coerce(Object obj, @CachedLibrary(value="obj") InteropLibrary objs) {
            try {
                return objs.asBoolean(obj);
            }
            catch (UnsupportedMessageException e) {
                throw CompilerDirectives.shouldNotReachHere(e);
            }
        }
    }

    @GenerateCached(value=false)
    @GenerateInline
    @GenerateUncached
    public static abstract class InteropReadStringMemberNode
    extends Node {
        public abstract TruffleString execute(Node var1, Object var2, String var3);

        @Specialization(guards={"objs.isMemberReadable(obj, key)"}, limit="3")
        static TruffleString read(Node node, Object obj, String key, @Cached InteropToStringNode coerceNode, @CachedLibrary(value="obj") InteropLibrary objs) {
            try {
                return coerceNode.execute(node, objs.readMember(obj, key));
            }
            catch (UnknownIdentifierException | UnsupportedMessageException e) {
                throw CompilerDirectives.shouldNotReachHere(e);
            }
        }

        public static InteropReadStringMemberNode getUncached() {
            return TRegexUtilFactory.InteropReadStringMemberNodeGen.getUncached();
        }
    }

    @GenerateCached
    @GenerateInline(inlineByDefault=true)
    @GenerateUncached
    public static abstract class InteropReadBooleanMemberNode
    extends Node {
        public abstract boolean execute(Node var1, Object var2, String var3);

        @Specialization(guards={"objs.isMemberReadable(obj, key)"}, limit="9")
        static boolean read(Node node, Object obj, String key, @Cached InteropToBooleanNode coerceNode, @CachedLibrary(value="obj") InteropLibrary objs) {
            try {
                return coerceNode.execute(node, objs.readMember(obj, key));
            }
            catch (UnknownIdentifierException | UnsupportedMessageException e) {
                throw CompilerDirectives.shouldNotReachHere(e);
            }
        }

        @NeverDefault
        public static InteropReadBooleanMemberNode create() {
            return TRegexUtilFactory.InteropReadBooleanMemberNodeGen.create();
        }

        public static InteropReadBooleanMemberNode getUncached() {
            return TRegexUtilFactory.InteropReadBooleanMemberNodeGen.getUncached();
        }
    }

    @GenerateCached(value=false)
    @GenerateInline(inlineByDefault=true)
    @GenerateUncached
    public static abstract class InteropReadIntArrayMemberNode
    extends Node {
        public abstract int[] execute(Node var1, Object var2, String var3);

        @Specialization(guards={"objs.isMemberReadable(obj, key)"}, limit="9")
        static int[] read(Node node, Object obj, String key, @Cached InteropToIntNode coerceNode, @CachedLibrary(value="obj") InteropLibrary objs, @CachedLibrary(limit="1") InteropLibrary arrays) {
            try {
                Object interopArray = objs.readMember(obj, key);
                int length = (int)arrays.getArraySize(interopArray);
                int[] array = new int[length];
                for (int i = 0; i < length; ++i) {
                    array[i] = coerceNode.execute(node, arrays.readArrayElement(interopArray, i));
                }
                return array;
            }
            catch (InvalidArrayIndexException | UnknownIdentifierException | UnsupportedMessageException e) {
                throw CompilerDirectives.shouldNotReachHere(e);
            }
        }

        public static InteropReadIntArrayMemberNode getUncached() {
            return TRegexUtilFactory.InteropReadIntArrayMemberNodeGen.getUncached();
        }
    }

    @GenerateCached(value=false)
    @GenerateInline(inlineByDefault=true)
    public static abstract class InteropReadIntMemberNode
    extends Node {
        public abstract int execute(Node var1, Object var2, String var3);

        @Specialization(guards={"objs.isMemberReadable(obj, key)"}, limit="9")
        static int read(Node node, Object obj, String key, @Cached InteropToIntNode coerceNode, @CachedLibrary(value="obj") InteropLibrary objs) {
            try {
                return coerceNode.execute(node, objs.readMember(obj, key));
            }
            catch (UnknownIdentifierException | UnsupportedMessageException e) {
                throw CompilerDirectives.shouldNotReachHere(e);
            }
        }
    }

    @GenerateCached
    @GenerateInline(inlineByDefault=true)
    @GenerateUncached
    public static abstract class InteropReadMemberNode
    extends Node {
        public abstract Object execute(Node var1, Object var2, String var3);

        @Specialization(guards={"objs.isMemberReadable(obj, key)"}, limit="9")
        static Object read(Object obj, String key, @CachedLibrary(value="obj") InteropLibrary objs) {
            try {
                return objs.readMember(obj, key);
            }
            catch (UnknownIdentifierException | UnsupportedMessageException e) {
                throw CompilerDirectives.shouldNotReachHere(e);
            }
        }

        @NeverDefault
        public static InteropReadMemberNode create() {
            return TRegexUtilFactory.InteropReadMemberNodeGen.create();
        }

        public static InteropReadMemberNode getUncached() {
            return TRegexUtilFactory.InteropReadMemberNodeGen.getUncached();
        }
    }

    public static final class Constants {
        public static final int CAPTURE_GROUP_NO_MATCH = -1;

        private Constants() {
        }
    }

    public static final class Props {
        private Props() {
        }

        public static final class RegexResult {
            public static final String IS_MATCH = "isMatch";
            public static final String GET_START = "getStart";
            public static final String GET_END = "getEnd";

            private RegexResult() {
            }
        }

        public static final class Flags {
            public static final String SOURCE = "source";
            public static final String GLOBAL = "global";
            public static final String MULTILINE = "multiline";
            public static final String IGNORE_CASE = "ignoreCase";
            public static final String STICKY = "sticky";
            public static final String UNICODE = "unicode";
            public static final String DOT_ALL = "dotAll";
            public static final String HAS_INDICES = "hasIndices";
            public static final String UNICODE_SETS = "unicodeSets";

            private Flags() {
            }
        }

        public static final class CompiledRegex {
            public static final String PATTERN = "pattern";
            public static final String FLAGS = "flags";
            public static final String EXEC = "exec";
            public static final String GROUP_COUNT = "groupCount";
            public static final String GROUPS = "groups";

            private CompiledRegex() {
            }
        }
    }
}

