/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.util;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Objects;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
interface ReferenceKey<T> {
    public T get();

    public void clear();

    public static final class StrongKeyWithEquality<T>
    implements WithEquality<T> {
        private final int hashcode;
        private T key;

        StrongKeyWithEquality(T key) {
            this.hashcode = key.hashCode();
            this.key = key;
        }

        @Override
        public T get() {
            return this.key;
        }

        @Override
        public void clear() {
            this.key = null;
        }

        public boolean equals(Object obj) {
            Object otherKey;
            if (obj instanceof WithEquality) {
                WithEquality ref = (WithEquality)obj;
                otherKey = ref.get();
            } else {
                otherKey = obj;
            }
            return Objects.equals(this.get(), otherKey);
        }

        public int hashCode() {
            return this.hashcode;
        }
    }

    public static final class WeakKeyWithEquality<T>
    extends WeakReference<T>
    implements WithEquality<T> {
        private final int hashcode;

        WeakKeyWithEquality(T key, ReferenceQueue<T> queue) {
            super(key, queue);
            this.hashcode = key.hashCode();
        }

        public boolean equals(Object obj) {
            Object otherKey;
            if (obj == this) {
                return true;
            }
            if (obj instanceof WithEquality) {
                WithEquality ref = (WithEquality)obj;
                otherKey = ref.get();
            } else {
                otherKey = obj;
            }
            return otherKey != null && Objects.equals(this.get(), otherKey);
        }

        public int hashCode() {
            return this.hashcode;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface WithEquality<T>
    extends ReferenceKey<T> {
    }

    public static final class StrongKeyWithIdentity<T>
    implements WithIdentity<T> {
        private final int hashcode;
        private T key;

        StrongKeyWithIdentity(T key) {
            this.hashcode = System.identityHashCode(Objects.requireNonNull(key, "key"));
            this.key = key;
        }

        @Override
        public T get() {
            return this.key;
        }

        @Override
        public void clear() {
            this.key = null;
        }

        @Override
        public boolean refersTo(T otherKey) {
            return this.get() == otherKey;
        }

        public boolean equals(Object obj) {
            if (obj instanceof WithIdentity) {
                return ((WithIdentity)obj).refersTo(this.get());
            }
            return this.refersTo(obj);
        }

        public int hashCode() {
            return this.hashcode;
        }
    }

    public static final class WeakKeyWithIdentity<T>
    extends WeakReference<T>
    implements WithIdentity<T> {
        private final int hashcode;

        WeakKeyWithIdentity(T key, ReferenceQueue<T> queue) {
            super(key, queue);
            this.hashcode = System.identityHashCode(Objects.requireNonNull(key, "key"));
        }

        public boolean equals(Object obj) {
            Object otherKey;
            if (obj == this) {
                return true;
            }
            if (obj instanceof WithIdentity) {
                WithIdentity ref = (WithIdentity)obj;
                otherKey = ref.get();
            } else {
                otherKey = obj;
            }
            return otherKey != null && this.refersTo(otherKey);
        }

        public int hashCode() {
            return this.hashcode;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface WithIdentity<T>
    extends ReferenceKey<T> {
        public boolean refersTo(T var1);
    }
}

