/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.util;

import java.util.Deque;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CallTarget;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerAsserts;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.TruffleContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.TruffleLanguage;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.exception.AbstractTruffleException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.source.Source;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.lang.JavaScriptLanguage;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSAgent;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSInterruptedExecutionException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRealm;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSArrayBufferObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSFunction;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSFunctionObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSSharedArrayBuffer;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.Null;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.Undefined;

public class DebugJSAgent
extends JSAgent {
    private final Deque<Object> reportValues = new ConcurrentLinkedDeque<Object>();
    private boolean quit;
    private JSFunctionObject debugReceiveBroadcast;
    private final Queue<JSArrayBufferObject.Shared> broadcasts = new ConcurrentLinkedQueue<JSArrayBufferObject.Shared>();
    private Thread thread;
    private final Lock queueLock = new ReentrantLock();
    private final Condition queueCondition = this.queueLock.newCondition();
    static final int POLL_TIMEOUT_MS = 100;

    public DebugJSAgent(boolean canBlock) {
        super(canBlock);
    }

    @CompilerDirectives.TruffleBoundary
    public String toString() {
        return "DebugJSAgent{signifier=" + this.getSignifier() + "}";
    }

    @CompilerDirectives.TruffleBoundary
    public void startNewAgent(String sourceText) {
        final Source agentSource = Source.newBuilder("js", sourceText, "agent").build();
        TruffleLanguage.Env env = JavaScriptLanguage.getCurrentEnv();
        TruffleContext agentContext = env.newInnerContextBuilder(new String[0]).inheritAllAccess(true).build();
        final CountDownLatch barrier = new CountDownLatch(1);
        agentContext.initializePublic(null, "js");
        Thread newThread = env.newTruffleThreadBuilder(new Runnable(){
            final /* synthetic */ DebugJSAgent this$0;
            {
                this.this$0 = this$0;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                JSRealm innerContext = JavaScriptLanguage.getCurrentJSRealm();
                DebugJSAgent childAgent = (DebugJSAgent)innerContext.getAgent();
                childAgent.thread = Thread.currentThread();
                DebugJSAgent parentAgent = this.this$0;
                parentAgent.registerChildAgent(childAgent);
                CallTarget callTarget = innerContext.getEnv().parsePublic(agentSource, new String[0]);
                callTarget.call(new Object[0]);
                barrier.countDown();
                try {
                    while (true) {
                        childAgent.queueLock.lock();
                        try {
                            if (childAgent.quit) {
                                return;
                            }
                            childAgent.queueCondition.await(100L, TimeUnit.MILLISECONDS);
                        }
                        finally {
                            childAgent.queueLock.unlock();
                        }
                        do {
                            JSArrayBufferObject.Shared original;
                            if ((original = childAgent.broadcasts.poll()) != null) {
                                JSArrayBufferObject.Shared current = (JSArrayBufferObject.Shared)JSSharedArrayBuffer.createSharedArrayBuffer(innerContext.getContext(), innerContext, original.getByteBuffer());
                                current.setWaiterList(original.getWaiterList());
                                childAgent.executeBroadcastCallback(current);
                                if (childAgent.quit) {
                                    return;
                                }
                            }
                            childAgent.processAllPromises(true);
                        } while (!childAgent.broadcasts.isEmpty());
                    }
                }
                catch (InterruptedException e) {
                    System.err.println("Interrupted " + String.valueOf(Thread.currentThread()));
                }
                catch (AbstractTruffleException e) {
                    System.err.println("Uncaught error from " + String.valueOf(Thread.currentThread()) + ": " + e.getMessage());
                }
            }
        }).context(agentContext).build();
        newThread.setName("Debug-JSAgent-Worker-Thread");
        newThread.start();
        try {
            barrier.await();
        }
        catch (InterruptedException e) {
            throw JSInterruptedExecutionException.wrap(e);
        }
    }

    @CompilerDirectives.TruffleBoundary
    public void setDebugReceiveBroadcast(JSFunctionObject broadcast) {
        this.debugReceiveBroadcast = broadcast;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    public void broadcast(JSArrayBufferObject.Shared sab) {
        List list = this.childAgents;
        synchronized (list) {
            for (JSAgent agent : this.childAgents) {
                if (!(agent instanceof DebugJSAgent)) continue;
                DebugJSAgent debugAgent = (DebugJSAgent)agent;
                debugAgent.pushMessage(sab);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    public Object getReport() {
        List list = this.childAgents;
        synchronized (list) {
            for (JSAgent agent : this.childAgents) {
                if (!(agent instanceof DebugJSAgent)) continue;
                DebugJSAgent debugAgent = (DebugJSAgent)agent;
                if (debugAgent.reportValues.isEmpty()) continue;
                return debugAgent.reportValues.pollLast();
            }
        }
        return Null.instance;
    }

    @CompilerDirectives.TruffleBoundary
    public void sleep(long time) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException e) {
            throw JSInterruptedExecutionException.wrap(e);
        }
    }

    @CompilerDirectives.TruffleBoundary
    public void report(Object value) {
        this.reportValues.push(value);
    }

    @CompilerDirectives.TruffleBoundary
    public void leaving() {
        this.quit = true;
    }

    @Override
    public void wake() {
        CompilerAsserts.neverPartOfCompilation();
        this.queueLock.lock();
        try {
            this.queueCondition.signalAll();
        }
        finally {
            this.queueLock.unlock();
        }
    }

    private void pushMessage(JSArrayBufferObject.Shared sab) {
        CompilerAsserts.neverPartOfCompilation();
        this.broadcasts.add(sab);
        this.wake();
    }

    private void executeBroadcastCallback(JSArrayBufferObject.Shared sab) {
        CompilerAsserts.neverPartOfCompilation();
        JSFunction.call(this.debugReceiveBroadcast, Undefined.instance, new Object[]{sab});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @CompilerDirectives.TruffleBoundary
    public void terminate() {
        super.terminate();
        List list = this.childAgents;
        synchronized (list) {
            try {
                for (JSAgent agent : this.childAgents) {
                    if (!(agent instanceof DebugJSAgent)) continue;
                    DebugJSAgent debugAgent = (DebugJSAgent)agent;
                    debugAgent.thread.join();
                }
            }
            catch (InterruptedException iex) {
                Thread.currentThread().interrupt();
            }
        }
        if (this.thread != null) {
            this.thread.interrupt();
        }
    }
}

