/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.cyclops.integratedscripting.vendors.com.oracle.js.parser.ir.Module;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerAsserts;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.Truffle;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.frame.FrameDescriptor;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.frame.FrameSlotKind;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.frame.MaterializedFrame;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.ArityException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.InteropLibrary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.InvalidArrayIndexException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.UnknownIdentifierException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.UnsupportedMessageException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.UnsupportedTypeException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.source.Source;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.wasm.WebAssemblyBuiltins;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Errors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSArguments;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRealm;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRuntime;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Strings;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSOrdinary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSPromiseObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.wasm.JSWebAssemblyInstanceObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.wasm.JSWebAssemblyModuleObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.AbstractModuleRecord;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.CyclicModuleRecord;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.ExportResolution;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSModuleRecord;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.PromiseCapabilityRecord;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.Undefined;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.util.Pair;

public class WebAssemblyModuleRecord
extends CyclicModuleRecord {
    private final JSWebAssemblyModuleObject webAssemblyModule;
    private List<Module.ModuleRequest> requestedModules;
    private List<TruffleString> exportNameList;

    public WebAssemblyModuleRecord(JSContext context, Source source, JSWebAssemblyModuleObject webAssemblyModule) {
        super(context, source, null, null);
        this.webAssemblyModule = webAssemblyModule;
    }

    @Override
    public Object getModuleSource() {
        return this.webAssemblyModule;
    }

    @Override
    public JSPromiseObject loadRequestedModules(JSRealm realm, Object hostDefined) {
        return this.context.getEvaluator().loadRequestedModules(realm, this, hostDefined);
    }

    @Override
    public List<Module.ModuleRequest> getRequestedModules() {
        if (this.requestedModules != null) {
            return this.requestedModules;
        }
        this.requestedModules = this.readRequestedModules();
        return this.requestedModules;
    }

    @CompilerDirectives.TruffleBoundary
    private List<Module.ModuleRequest> readRequestedModules() {
        JSRealm realm = JSRealm.get(null);
        try {
            Object importsArray = InteropLibrary.getUncached().execute(realm.getWASMModuleImports(), this.webAssemblyModule.getWASMModule());
            InteropLibrary importsArrayLib = InteropLibrary.getUncached(importsArray);
            int importsArrayLength = (int)importsArrayLib.getArraySize(importsArray);
            LinkedHashSet<Module.ModuleRequest> requestedModuleSet = new LinkedHashSet<Module.ModuleRequest>();
            for (int i = 0; i < importsArrayLength; ++i) {
                Object importDesc = importsArrayLib.readArrayElement(importsArray, i);
                TruffleString importedModuleName = Strings.interopAsTruffleString(InteropLibrary.getUncached().readMember(importDesc, "module"));
                requestedModuleSet.add(Module.ModuleRequest.create(importedModuleName));
            }
            return List.copyOf(requestedModuleSet);
        }
        catch (ArityException | InvalidArrayIndexException | UnknownIdentifierException | UnsupportedMessageException | UnsupportedTypeException ex) {
            throw Errors.shouldNotReachHere(ex);
        }
    }

    @Override
    public Collection<TruffleString> getExportedNames(Set<JSModuleRecord> exportStarSet) {
        if (this.exportNameList != null) {
            return this.exportNameList;
        }
        this.exportNameList = this.readExportedNames();
        return this.exportNameList;
    }

    @CompilerDirectives.TruffleBoundary
    private List<TruffleString> readExportedNames() {
        JSRealm realm = JSRealm.get(null);
        Object exportsFunction = realm.getWASMModuleExports();
        try {
            Object exportsArray = InteropLibrary.getUncached().execute(exportsFunction, this.webAssemblyModule.getWASMModule());
            InteropLibrary exportsArrayLib = InteropLibrary.getUncached(exportsArray);
            int exportsArrayLength = (int)exportsArrayLib.getArraySize(exportsArray);
            TruffleString[] exportNames = new TruffleString[exportsArrayLength];
            for (int i = 0; i < exportsArrayLength; ++i) {
                TruffleString exportName;
                Object exportDesc = exportsArrayLib.readArrayElement(exportsArray, i);
                exportNames[i] = exportName = Strings.interopAsTruffleString(InteropLibrary.getUncached().readMember(exportDesc, "name"));
            }
            return List.of(exportNames);
        }
        catch (ArityException | InvalidArrayIndexException | UnknownIdentifierException | UnsupportedMessageException | UnsupportedTypeException ex) {
            throw Errors.shouldNotReachHere(ex);
        }
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public ExportResolution resolveExport(TruffleString exportName, Set<Pair<? extends AbstractModuleRecord, TruffleString>> resolveSet) {
        for (TruffleString name : this.getExportedNames()) {
            if (!name.equals(exportName)) continue;
            return ExportResolution.resolved(this, name);
        }
        return ExportResolution.notFound();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public void initializeEnvironment(JSRealm realm) {
        Collection<TruffleString> exportNames = this.getExportedNames();
        int exportNameCount = exportNames.size();
        FrameDescriptor.Builder b = FrameDescriptor.newBuilder(exportNameCount);
        for (TruffleString name : exportNames) {
            b.addSlot(FrameSlotKind.Illegal, name, null);
        }
        FrameDescriptor desc = b.build();
        this.setFrameDescriptor(desc);
        MaterializedFrame env = Truffle.getRuntime().createMaterializedFrame(JSArguments.EMPTY_ARGUMENTS_ARRAY, desc);
        for (int i = 0; i < exportNameCount; ++i) {
            env.clear(i);
        }
        this.setEnvironment(env);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public Object executeModule(JSRealm realm, PromiseCapabilityRecord promiseCapability) {
        assert (promiseCapability == null);
        JSObject importObject = JSOrdinary.createWithNullPrototype(this.context);
        for (Module.ModuleRequest requestedModule : this.getRequestedModules()) {
            JSRuntime.createDataProperty(importObject, requestedModule.specifier(), JSOrdinary.createWithNullPrototype(this.context));
        }
        try {
            Object importsArray = InteropLibrary.getUncached().execute(realm.getWASMModuleImports(), this.webAssemblyModule.getWASMModule());
            InteropLibrary importsArrayLib = InteropLibrary.getUncached(importsArray);
            int importsArrayLength = (int)importsArrayLib.getArraySize(importsArray);
            for (int i = 0; i < importsArrayLength; ++i) {
                Object importDesc = importsArrayLib.readArrayElement(importsArray, i);
                TruffleString importedModuleName = Strings.interopAsTruffleString(InteropLibrary.getUncached().readMember(importDesc, "module"));
                TruffleString name = Strings.interopAsTruffleString(InteropLibrary.getUncached().readMember(importDesc, "name"));
                AbstractModuleRecord importedModule = this.getImportedModule(Module.ModuleRequest.create(importedModuleName));
                Object value = importedModule.getModuleNamespace(Module.ImportPhase.Evaluation).getValue(name);
                JSObject moduleImportsObject = (JSObject)importObject.getValue(importedModuleName);
                JSRuntime.createDataProperty(moduleImportsObject, name, value);
            }
            JSWebAssemblyInstanceObject instance = WebAssemblyBuiltins.WebAssemblyInstantiateNode.instantiateModule(this.context, realm, this.webAssemblyModule.getWASMModule(), importObject, InteropLibrary.getUncached());
            MaterializedFrame environment = this.getEnvironment();
            int i = 0;
            for (TruffleString name : this.getExportedNames()) {
                environment.setObject(i++, instance.getExports().getValue(name));
            }
        }
        catch (ArityException | InvalidArrayIndexException | UnknownIdentifierException | UnsupportedMessageException | UnsupportedTypeException ex) {
            throw Errors.shouldNotReachHere(ex);
        }
        return Undefined.instance;
    }

    public String toString() {
        CompilerAsserts.neverPartOfCompilation();
        return "WebAssembly.Module@" + Integer.toHexString(System.identityHashCode(this)) + "[status=" + String.valueOf((Object)this.getStatus()) + ", source=" + String.valueOf(this.getSource()) + "]";
    }
}

