/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.cyclops.integratedscripting.vendors.com.oracle.js.parser.ir.Module;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerAsserts;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.frame.FrameDescriptor;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.frame.MaterializedFrame;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.source.Source;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.AbstractTruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Errors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRealm;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSModuleNamespace;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSModuleNamespaceObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSPromise;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSPromiseObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.CyclicModuleRecord;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.ExportResolution;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSModuleRecord;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.ScriptOrModule;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.util.Pair;

public abstract class AbstractModuleRecord
extends ScriptOrModule {
    private JSModuleNamespaceObject namespace;
    private JSModuleNamespaceObject deferredNamespace;
    private MaterializedFrame environment;
    private FrameDescriptor frameDescriptor;
    private Object hostDefined;

    protected AbstractModuleRecord(JSContext context, Source source, Object hostDefined, FrameDescriptor frameDescriptor) {
        super(context, source);
        this.frameDescriptor = frameDescriptor;
        this.hostDefined = hostDefined;
    }

    public abstract JSPromiseObject loadRequestedModules(JSRealm var1, Object var2);

    public final void loadRequestedModulesSync(JSRealm realm, Object hostDefinedArg) {
        JSPromiseObject loadPromise = this.loadRequestedModules(realm, hostDefinedArg);
        assert (!JSPromise.isPending(loadPromise));
        JSPromise.throwIfRejected(loadPromise, realm);
    }

    public abstract void link(JSRealm var1);

    public abstract JSPromiseObject evaluate(JSRealm var1);

    @CompilerDirectives.TruffleBoundary
    public void evaluateSync(JSRealm realm) {
        CyclicModuleRecord cyclicModule;
        AbstractModuleRecord abstractModuleRecord;
        assert (!((abstractModuleRecord = this) instanceof CyclicModuleRecord) || (cyclicModule = (CyclicModuleRecord)abstractModuleRecord).isReadyForSyncExecution()) : this;
        JSPromiseObject loadPromise = this.evaluate(realm);
        assert (!JSPromise.isPending(loadPromise));
        JSPromise.throwIfRejected(loadPromise, realm);
    }

    @CompilerDirectives.TruffleBoundary
    public final Collection<TruffleString> getExportedNames() {
        return this.getExportedNames(new HashSet<JSModuleRecord>());
    }

    public abstract Collection<TruffleString> getExportedNames(Set<JSModuleRecord> var1);

    @CompilerDirectives.TruffleBoundary
    public final ExportResolution resolveExport(TruffleString exportName) {
        return this.resolveExport(exportName, new HashSet<Pair<? extends AbstractModuleRecord, TruffleString>>());
    }

    public abstract ExportResolution resolveExport(TruffleString var1, Set<Pair<? extends AbstractModuleRecord, TruffleString>> var2);

    public final JSModuleNamespaceObject getModuleNamespaceOrNull(Module.ImportPhase phase) {
        assert (phase == Module.ImportPhase.Evaluation || phase == Module.ImportPhase.Defer) : phase;
        return this.getModuleNamespaceOrNull(phase == Module.ImportPhase.Defer);
    }

    public final JSModuleNamespaceObject getModuleNamespace(Module.ImportPhase phase) {
        assert (phase == Module.ImportPhase.Evaluation || phase == Module.ImportPhase.Defer) : phase;
        return this.getModuleNamespace(phase == Module.ImportPhase.Defer);
    }

    public final JSModuleNamespaceObject getModuleNamespaceOrNull(boolean deferred) {
        if (deferred) {
            return this.deferredNamespace;
        }
        return this.namespace;
    }

    @CompilerDirectives.TruffleBoundary
    public final JSModuleNamespaceObject getModuleNamespace(boolean deferred) {
        CyclicModuleRecord cyclicModule;
        AbstractModuleRecord abstractModuleRecord;
        JSModuleNamespaceObject ns = this.getModuleNamespaceOrNull(deferred);
        if (ns != null) {
            return ns;
        }
        assert (!((abstractModuleRecord = this) instanceof CyclicModuleRecord) || (cyclicModule = (CyclicModuleRecord)abstractModuleRecord).getStatus() != CyclicModuleRecord.Status.New) : this;
        Collection<TruffleString> exportedNames = this.getExportedNames();
        ArrayList<Map.Entry<TruffleString, ExportResolution>> unambiguousNames = new ArrayList<Map.Entry<TruffleString, ExportResolution>>();
        for (TruffleString exportedName : exportedNames) {
            ExportResolution resolution = this.resolveExport(exportedName);
            if (resolution.isNull()) {
                throw Errors.createSyntaxError("Could not resolve export");
            }
            if (resolution.isAmbiguous()) continue;
            unambiguousNames.add(Map.entry(exportedName, resolution));
        }
        unambiguousNames.sort((a, b) -> ((TruffleString)a.getKey()).compareCharsUTF16Uncached((AbstractTruffleString)b.getKey()));
        ns = JSModuleNamespace.create(this.getContext(), JSRealm.get(null), this, unambiguousNames, deferred);
        if (deferred) {
            this.deferredNamespace = ns;
        } else {
            this.namespace = ns;
        }
        return ns;
    }

    public abstract Object getModuleSource();

    public final MaterializedFrame getEnvironment() {
        return this.environment;
    }

    public final void setEnvironment(MaterializedFrame environment) {
        assert (this.environment == null);
        this.environment = environment;
    }

    protected final void clearEnvironment() {
        this.environment = null;
    }

    public final FrameDescriptor getFrameDescriptor() {
        return this.frameDescriptor;
    }

    protected final void setFrameDescriptor(FrameDescriptor frameDescriptor) {
        this.frameDescriptor = frameDescriptor;
    }

    public final Object getHostDefined() {
        return this.hostDefined;
    }

    @CompilerDirectives.TruffleBoundary
    public List<AbstractModuleRecord> gatherAsynchronousTransitiveDependencies() {
        return this.gatherAsynchronousTransitiveDependencies(new ArrayList<AbstractModuleRecord>(), new HashSet<AbstractModuleRecord>());
    }

    private List<AbstractModuleRecord> gatherAsynchronousTransitiveDependencies(List<AbstractModuleRecord> result, Set<AbstractModuleRecord> seen) {
        CompilerAsserts.neverPartOfCompilation();
        if (!seen.add(this)) {
            return result;
        }
        AbstractModuleRecord abstractModuleRecord = this;
        if (abstractModuleRecord instanceof CyclicModuleRecord) {
            CyclicModuleRecord cyclicModule = (CyclicModuleRecord)abstractModuleRecord;
            if (cyclicModule.getStatus() == CyclicModuleRecord.Status.Evaluating || cyclicModule.getStatus() == CyclicModuleRecord.Status.Evaluated) {
                return result;
            }
            if (cyclicModule.hasTLA()) {
                result.add(cyclicModule);
                return result;
            }
            for (Module.ModuleRequest request : cyclicModule.getRequestedModules()) {
                AbstractModuleRecord requiredModule = cyclicModule.getImportedModule(request);
                requiredModule.gatherAsynchronousTransitiveDependencies(result, seen);
            }
        }
        return result;
    }

    public abstract CyclicModuleRecord.Status getStatus();
}

