/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.interop;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.InteropLibrary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.StopIterationException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.TruffleObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.UnsupportedMessageException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.library.CachedLibrary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.library.ExportLibrary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.library.ExportMessage;

@ExportLibrary(value=InteropLibrary.class)
public final class InteropArrayIndexIterator
implements TruffleObject {
    final Object array;
    private long cursor;

    private InteropArrayIndexIterator(Object array) {
        this.array = array;
    }

    public static InteropArrayIndexIterator create(Object array) {
        return new InteropArrayIndexIterator(array);
    }

    @ExportMessage
    boolean isIterator() {
        return true;
    }

    @ExportMessage
    boolean hasIteratorNextElement(@CachedLibrary(value="this.array") InteropLibrary interop) {
        try {
            long currentSize = interop.getArraySize(this.array);
            return this.cursor < currentSize;
        }
        catch (UnsupportedMessageException ex) {
            return false;
        }
    }

    @ExportMessage
    Object getIteratorNextElement(@CachedLibrary(value="this.array") InteropLibrary interop) throws StopIterationException {
        if (this.hasIteratorNextElement(interop)) {
            return this.cursor++;
        }
        throw StopIterationException.create();
    }
}

