/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.wasm;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object.Shape;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.wasm.WebAssemblyTablePrototypeBuiltins;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRealm;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Strings;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSConstructor;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSConstructorFactory;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSFunctionObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSNonProxy;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSObjectFactory;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.PrototypeSupplier;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.wasm.JSWebAssembly;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.wasm.JSWebAssemblyTableObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.wasm.WebAssemblyValueType;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSObjectUtil;

public class JSWebAssemblyTable
extends JSNonProxy
implements JSConstructorFactory.Default,
PrototypeSupplier {
    public static final int MAX_TABLE_SIZE = 10000000;
    public static final TruffleString CLASS_NAME = Strings.constant("Table");
    public static final TruffleString PROTOTYPE_NAME = Strings.constant("Table.prototype");
    public static final TruffleString WEB_ASSEMBLY_TABLE = Strings.constant("WebAssembly.Table");
    public static final JSWebAssemblyTable INSTANCE = new JSWebAssemblyTable();

    @Override
    public TruffleString getClassName() {
        return CLASS_NAME;
    }

    public static boolean isJSWebAssemblyTable(Object object) {
        return object instanceof JSWebAssemblyTableObject;
    }

    @Override
    public JSDynamicObject createPrototype(JSRealm realm, JSFunctionObject constructor) {
        JSObject prototype = JSObjectUtil.createOrdinaryPrototypeObject(realm);
        JSObjectUtil.putConstructorProperty(prototype, constructor);
        JSObjectUtil.putFunctionsFromContainer(realm, prototype, WebAssemblyTablePrototypeBuiltins.BUILTINS);
        JSObjectUtil.putAccessorsFromContainer(realm, prototype, WebAssemblyTablePrototypeBuiltins.BUILTINS);
        JSObjectUtil.putToStringTag(prototype, WEB_ASSEMBLY_TABLE);
        return prototype;
    }

    @Override
    public JSDynamicObject getIntrinsicDefaultProto(JSRealm realm) {
        return realm.getWebAssemblyTablePrototype();
    }

    @Override
    public Shape makeInitialShape(JSContext ctx, JSDynamicObject prototype) {
        return JSObjectUtil.getProtoChildShape(prototype, INSTANCE, ctx);
    }

    public static JSConstructor createConstructor(JSRealm realm) {
        return INSTANCE.createConstructorAndPrototype(realm);
    }

    public static JSWebAssemblyTableObject create(JSContext context, JSRealm realm, Object wasmTable, WebAssemblyValueType elementKind) {
        return JSWebAssemblyTable.create(context, realm, INSTANCE.getIntrinsicDefaultProto(realm), wasmTable, elementKind);
    }

    public static JSWebAssemblyTableObject create(JSContext context, JSRealm realm, JSDynamicObject proto, Object wasmTable, WebAssemblyValueType elementKind) {
        Object embedderData = JSWebAssembly.getEmbedderData(realm, wasmTable);
        if (embedderData instanceof JSWebAssemblyTableObject) {
            return (JSWebAssemblyTableObject)embedderData;
        }
        JSObjectFactory factory = context.getWebAssemblyTableFactory();
        Shape shape = factory.getShape(realm, proto);
        JSWebAssemblyTableObject object = factory.initProto(new JSWebAssemblyTableObject(shape, proto, wasmTable, elementKind), realm, proto);
        JSWebAssembly.setEmbedderData(realm, wasmTable, object);
        return factory.trackAllocation(object);
    }
}

