/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal;

import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.InteropLibrary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.UnsupportedMessageException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.library.ExportLibrary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.library.ExportMessage;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object.Shape;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.BigInt;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalCalendarHolder;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalZonedDateTime;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.util.TemporalUtil;

@ExportLibrary(value=InteropLibrary.class)
public final class JSTemporalZonedDateTimeObject
extends JSTemporalCalendarHolder {
    private final BigInt nanoseconds;
    private final TruffleString timeZone;

    protected JSTemporalZonedDateTimeObject(Shape shape, JSDynamicObject proto, BigInt nanoseconds, TruffleString timeZone, TruffleString calendar) {
        super(shape, proto, calendar);
        assert (TemporalUtil.isValidEpochNanoseconds(nanoseconds));
        this.nanoseconds = nanoseconds;
        this.timeZone = timeZone;
    }

    public BigInt getNanoseconds() {
        return this.nanoseconds;
    }

    public TruffleString getTimeZone() {
        return this.timeZone;
    }

    @CompilerDirectives.TruffleBoundary
    private Instant toInstant() {
        BigInt[] res = this.nanoseconds.divideAndRemainder(TemporalUtil.BI_NS_PER_SECOND);
        return Instant.ofEpochSecond(res[0].longValue(), res[1].intValue());
    }

    @ExportMessage.Repeat(value={@ExportMessage(name="isTimeZone"), @ExportMessage(name="isDate"), @ExportMessage(name="isTime")})
    @CompilerDirectives.TruffleBoundary
    boolean isTimeZone() {
        return this.getZoneIdIntl() != null;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    ZoneId asTimeZone() throws UnsupportedMessageException {
        ZoneId tzObj = this.getZoneIdIntl();
        if (tzObj == null) {
            throw UnsupportedMessageException.create();
        }
        return tzObj;
    }

    @CompilerDirectives.TruffleBoundary
    private ZoneId getZoneIdIntl() {
        ZoneId zoneId;
        String id = this.timeZone.toJavaStringUncached();
        try {
            zoneId = ZoneId.of(id);
        }
        catch (DateTimeException ex) {
            zoneId = null;
        }
        return zoneId;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    LocalDate asDate() throws UnsupportedMessageException {
        return LocalDate.ofInstant(this.toInstant(), this.asTimeZone());
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    LocalTime asTime() throws UnsupportedMessageException {
        return LocalTime.ofInstant(this.toInstant(), this.asTimeZone());
    }

    @Override
    public TruffleString getClassName() {
        return JSTemporalZonedDateTime.TO_STRING_TAG;
    }
}

