/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal;

import java.time.LocalDate;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.InteropLibrary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.library.ExportLibrary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.library.ExportMessage;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object.Shape;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.ISODateRecord;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalCalendarHolder;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDate;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSDynamicObject;

@ExportLibrary(value=InteropLibrary.class)
public final class JSTemporalPlainDateObject
extends JSTemporalCalendarHolder {
    private final int year;
    private final int month;
    private final int day;

    public JSTemporalPlainDateObject(Shape shape, JSDynamicObject proto, int year, int month, int day, TruffleString calendar) {
        super(shape, proto, calendar);
        this.year = year;
        this.month = month;
        this.day = day;
    }

    public int getYear() {
        return this.year;
    }

    public int getMonth() {
        return this.month;
    }

    public int getDay() {
        return this.day;
    }

    public ISODateRecord isoDate() {
        return new ISODateRecord(this.year, this.month, this.day);
    }

    @ExportMessage
    boolean isDate() {
        return true;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    LocalDate asDate() {
        return LocalDate.of(this.year, this.month, this.day);
    }

    @Override
    public TruffleString getClassName() {
        return JSTemporalPlainDate.TO_STRING_TAG;
    }
}

