/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.InteropLibrary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.library.ExportLibrary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.library.ExportMessage;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object.Shape;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.BigInt;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalInstant;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSNonProxyObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.util.TemporalUtil;

@ExportLibrary(value=InteropLibrary.class)
public final class JSTemporalInstantObject
extends JSNonProxyObject {
    private final BigInt nanoseconds;

    protected JSTemporalInstantObject(Shape shape, JSDynamicObject proto, BigInt nanoseconds) {
        super(shape, proto);
        assert (TemporalUtil.isValidEpochNanoseconds(nanoseconds));
        this.nanoseconds = nanoseconds;
    }

    public BigInt getNanoseconds() {
        return this.nanoseconds;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    Instant asInstant() {
        BigInt[] res = this.nanoseconds.divideAndRemainder(TemporalUtil.BI_NS_PER_SECOND);
        return Instant.ofEpochSecond(res[0].longValue(), res[1].intValue());
    }

    @ExportMessage
    boolean isTimeZone() {
        return true;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    ZoneId asTimeZone() {
        return ZoneId.of("UTC");
    }

    @ExportMessage
    boolean isDate() {
        return true;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    LocalDate asDate() {
        return LocalDate.ofInstant(this.asInstant(), this.asTimeZone());
    }

    @ExportMessage
    boolean isTime() {
        return true;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    LocalTime asTime() {
        return LocalTime.ofInstant(this.asInstant(), this.asTimeZone());
    }

    @Override
    public TruffleString getClassName() {
        return JSTemporalInstant.TO_STRING_TAG;
    }
}

