/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.intl;

import java.text.AttributedCharacterIterator;
import java.util.ArrayList;
import java.util.Locale;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerAsserts;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object.Shape;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.intl.RelativeTimeFormatFunctionBuiltins;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.intl.RelativeTimeFormatPrototypeBuiltins;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Errors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRealm;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Strings;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSArray;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSConstructor;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSConstructorFactory;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSFunctionObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSNonProxy;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSObjectFactory;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.PrototypeSupplier;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.intl.JSNumberFormat;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.intl.JSRelativeTimeFormatObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSAttributes;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.util.IntlUtil;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.util.LazyValue;
import org.cyclops.integratedscripting.vendors.org.graalvm.collections.EconomicMap;
import org.cyclops.integratedscripting.vendors.org.graalvm.collections.UnmodifiableEconomicMap;
import org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.text.DecimalFormat;
import org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.text.DisplayContext;
import org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.text.NumberFormat;
import org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.text.RelativeDateTimeFormatter;
import org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.util.ULocale;

public final class JSRelativeTimeFormat
extends JSNonProxy
implements JSConstructorFactory.WithFunctions,
PrototypeSupplier {
    public static final TruffleString CLASS_NAME = Strings.constant("RelativeTimeFormat");
    public static final TruffleString PROTOTYPE_NAME = Strings.constant("RelativeTimeFormat.prototype");
    public static final TruffleString TO_STRING_TAG = Strings.constant("Intl.RelativeTimeFormat");
    public static final JSRelativeTimeFormat INSTANCE = new JSRelativeTimeFormat();
    private static final LazyValue<UnmodifiableEconomicMap<String, RelativeDateTimeFormatter.RelativeDateTimeUnit>> timeUnitMap = new LazyValue<UnmodifiableEconomicMap>(JSRelativeTimeFormat::initTimeUnitMap);

    private JSRelativeTimeFormat() {
    }

    public static boolean isJSRelativeTimeFormat(Object obj) {
        return obj instanceof JSRelativeTimeFormatObject;
    }

    @Override
    public TruffleString getClassName() {
        return CLASS_NAME;
    }

    @Override
    public JSDynamicObject createPrototype(JSRealm realm, JSFunctionObject ctor) {
        JSObject relativeTimeFormatPrototype = JSObjectUtil.createOrdinaryPrototypeObject(realm);
        JSObjectUtil.putConstructorProperty(relativeTimeFormatPrototype, ctor);
        JSObjectUtil.putFunctionsFromContainer(realm, relativeTimeFormatPrototype, RelativeTimeFormatPrototypeBuiltins.BUILTINS);
        JSObjectUtil.putToStringTag(relativeTimeFormatPrototype, TO_STRING_TAG);
        return relativeTimeFormatPrototype;
    }

    @Override
    public Shape makeInitialShape(JSContext ctx, JSDynamicObject prototype) {
        Shape initialShape = JSObjectUtil.getProtoChildShape(prototype, INSTANCE, ctx);
        return initialShape;
    }

    public static JSConstructor createConstructor(JSRealm realm) {
        return INSTANCE.createConstructorAndPrototype(realm, RelativeTimeFormatFunctionBuiltins.BUILTINS);
    }

    public static JSRelativeTimeFormatObject create(JSContext context, JSRealm realm, JSDynamicObject proto) {
        InternalState state = new InternalState();
        JSObjectFactory factory = context.getRelativeTimeFormatFactory();
        Shape shape = factory.getShape(realm, proto);
        JSRelativeTimeFormatObject newObj = factory.initProto(new JSRelativeTimeFormatObject(shape, proto, state), realm, proto);
        return factory.trackAllocation(newObj);
    }

    private static void ensureFiniteNumber(double d) {
        if (!Double.isFinite(d)) {
            throw Errors.createRangeError("Value need to be finite number for Intl.RelativeTimeFormat operation");
        }
    }

    @CompilerDirectives.TruffleBoundary
    public static TruffleString format(JSRelativeTimeFormatObject relativeTimeFormatObj, double amount, String unit) {
        JSRelativeTimeFormat.ensureFiniteNumber(amount);
        InternalState state = relativeTimeFormatObj.getInternalState();
        RelativeDateTimeFormatter.RelativeDateTimeUnit icuUnit = JSRelativeTimeFormat.singularRelativeTimeUnit("format", unit);
        return Strings.fromJavaString(JSRelativeTimeFormat.innerFormat(amount, state, state.getRelativeDateTimeFormatter(), icuUnit));
    }

    private static String innerFormat(double amount, InternalState state, RelativeDateTimeFormatter relativeDateTimeFormatter, RelativeDateTimeFormatter.RelativeDateTimeUnit icuUnit) {
        if (state.getNumeric().equals("always")) {
            return relativeDateTimeFormatter.formatNumeric(amount, icuUnit);
        }
        return relativeDateTimeFormatter.format(amount, icuUnit);
    }

    @CompilerDirectives.TruffleBoundary
    public static JSDynamicObject formatToParts(JSContext context, JSRealm realm, JSRelativeTimeFormatObject relativeTimeFormatObj, double amount, String unit) {
        JSRelativeTimeFormat.ensureFiniteNumber(amount);
        InternalState state = relativeTimeFormatObj.getInternalState();
        RelativeDateTimeFormatter relativeDateTimeFormatter = state.getRelativeDateTimeFormatter();
        NumberFormat numberFormat = relativeDateTimeFormatter.getNumberFormat();
        RelativeDateTimeFormatter.RelativeDateTimeUnit icuUnit = JSRelativeTimeFormat.singularRelativeTimeUnit("formatToParts", unit);
        String formattedText = JSRelativeTimeFormat.innerFormat(amount, state, relativeDateTimeFormatter, icuUnit);
        double positiveAmount = Math.abs(amount);
        String formattedNumber = numberFormat.format(positiveAmount);
        int numberIndex = formattedText.indexOf(formattedNumber);
        boolean numberPresentInFormattedText = numberIndex > -1;
        ArrayList<JSObject> resultParts = new ArrayList<JSObject>();
        if (numberPresentInFormattedText) {
            if (numberIndex > 0) {
                resultParts.add(IntlUtil.makePart(context, realm, "literal", formattedText.substring(0, numberIndex)));
            }
            String esUnit = icuUnit.toString().toLowerCase();
            AttributedCharacterIterator iterator = numberFormat.formatToCharacterIterator(positiveAmount);
            String formatted = numberFormat.format(positiveAmount);
            resultParts.addAll(JSNumberFormat.innerFormatToParts(context, realm, iterator, positiveAmount, formatted, esUnit, false));
            if (numberIndex + formattedNumber.length() < formattedText.length()) {
                resultParts.add(IntlUtil.makePart(context, realm, "literal", formattedText.substring(numberIndex + formattedNumber.length(), formattedText.length())));
            }
        } else {
            resultParts.add(IntlUtil.makePart(context, realm, "literal", formattedText));
        }
        return JSArray.createConstant(context, realm, resultParts.toArray());
    }

    private static RelativeDateTimeFormatter createFormatter(Locale locale, String style) {
        ULocale ulocale = ULocale.forLocale(locale);
        NumberFormat numberFormat = NumberFormat.getNumberInstance(ulocale);
        if (numberFormat instanceof DecimalFormat) {
            ((DecimalFormat)numberFormat).setMinimumGroupingDigits(-2);
        }
        return RelativeDateTimeFormatter.getInstance(ulocale, numberFormat, RelativeDateTimeFormatter.Style.valueOf(style.toUpperCase()), DisplayContext.CAPITALIZATION_NONE);
    }

    @CompilerDirectives.TruffleBoundary
    public static JSObject resolvedOptions(JSContext context, JSRealm realm, JSRelativeTimeFormatObject relativeTimeFormatObj) {
        InternalState state = relativeTimeFormatObj.getInternalState();
        return state.toResolvedOptionsObject(context, realm);
    }

    @Override
    public JSDynamicObject getIntrinsicDefaultProto(JSRealm realm) {
        return realm.getRelativeTimeFormatPrototype();
    }

    private static RelativeDateTimeFormatter.RelativeDateTimeUnit toRelTimeUnit(String unit) {
        return timeUnitMap.get().get(unit);
    }

    private static UnmodifiableEconomicMap<String, RelativeDateTimeFormatter.RelativeDateTimeUnit> initTimeUnitMap() {
        CompilerAsserts.neverPartOfCompilation();
        EconomicMap<String, RelativeDateTimeFormatter.RelativeDateTimeUnit> map = EconomicMap.create(16);
        map.put("second", RelativeDateTimeFormatter.RelativeDateTimeUnit.SECOND);
        map.put("seconds", RelativeDateTimeFormatter.RelativeDateTimeUnit.SECOND);
        map.put("minute", RelativeDateTimeFormatter.RelativeDateTimeUnit.MINUTE);
        map.put("minutes", RelativeDateTimeFormatter.RelativeDateTimeUnit.MINUTE);
        map.put("hour", RelativeDateTimeFormatter.RelativeDateTimeUnit.HOUR);
        map.put("hours", RelativeDateTimeFormatter.RelativeDateTimeUnit.HOUR);
        map.put("day", RelativeDateTimeFormatter.RelativeDateTimeUnit.DAY);
        map.put("days", RelativeDateTimeFormatter.RelativeDateTimeUnit.DAY);
        map.put("week", RelativeDateTimeFormatter.RelativeDateTimeUnit.WEEK);
        map.put("weeks", RelativeDateTimeFormatter.RelativeDateTimeUnit.WEEK);
        map.put("month", RelativeDateTimeFormatter.RelativeDateTimeUnit.MONTH);
        map.put("months", RelativeDateTimeFormatter.RelativeDateTimeUnit.MONTH);
        map.put("quarter", RelativeDateTimeFormatter.RelativeDateTimeUnit.QUARTER);
        map.put("quarters", RelativeDateTimeFormatter.RelativeDateTimeUnit.QUARTER);
        map.put("year", RelativeDateTimeFormatter.RelativeDateTimeUnit.YEAR);
        map.put("years", RelativeDateTimeFormatter.RelativeDateTimeUnit.YEAR);
        return map;
    }

    private static RelativeDateTimeFormatter.RelativeDateTimeUnit singularRelativeTimeUnit(String functionName, String unit) {
        RelativeDateTimeFormatter.RelativeDateTimeUnit result = JSRelativeTimeFormat.toRelTimeUnit(unit);
        if (result != null) {
            return result;
        }
        throw Errors.createRangeErrorInvalidUnitArgument(functionName, unit);
    }

    public static class InternalState
    extends JSNumberFormat.BasicInternalState {
        private RelativeDateTimeFormatter relativeDateTimeFormatter;
        private String style;
        private String numeric;

        @Override
        void fillResolvedOptions(JSContext context, JSRealm realm, JSDynamicObject result) {
            JSObjectUtil.putDataProperty(result, IntlUtil.KEY_LOCALE, Strings.fromJavaString(this.getLocale()), JSAttributes.getDefault());
            JSObjectUtil.putDataProperty(result, IntlUtil.KEY_STYLE, Strings.fromJavaString(this.style), JSAttributes.getDefault());
            JSObjectUtil.putDataProperty(result, IntlUtil.KEY_NUMERIC, Strings.fromJavaString(this.numeric), JSAttributes.getDefault());
            JSObjectUtil.putDataProperty(result, IntlUtil.KEY_NUMBERING_SYSTEM, Strings.fromJavaString(this.getNumberingSystem()), JSAttributes.getDefault());
        }

        @CompilerDirectives.TruffleBoundary
        public void initializeRelativeTimeFormatter() {
            this.relativeDateTimeFormatter = JSRelativeTimeFormat.createFormatter(this.getJavaLocale(), this.style);
        }

        public RelativeDateTimeFormatter getRelativeDateTimeFormatter() {
            return this.relativeDateTimeFormatter;
        }

        public void setStyle(String style) {
            this.style = style;
        }

        public void setNumeric(String numeric) {
            this.numeric = numeric;
        }

        public String getNumeric() {
            return this.numeric;
        }
    }
}

