/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.TruffleLanguage;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Cached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.InteropLibrary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.TruffleObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.UnsupportedMessageException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.library.CachedLibrary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.library.ExportLibrary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.library.ExportMessage;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object.Shape;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.lang.JavaScriptLanguage;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.interop.ExportValueNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.interop.JSInteropExecuteNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.interop.JSInteropInstantiateNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.unary.IsCallableNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Errors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRealm;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRuntime;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Strings;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.ToDisplayStringFormat;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSArray;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSFunction;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSProxy;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.interop.JSMetaType;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSClassObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.Null;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.Undefined;

@ExportLibrary(value=InteropLibrary.class)
public final class JSProxyObject
extends JSClassObject {
    private Object proxyTarget;
    private JSDynamicObject proxyHandler;

    protected JSProxyObject(Shape shape, JSDynamicObject proto, Object proxyTarget, JSDynamicObject proxyHandler) {
        super(shape, proto);
        this.proxyTarget = proxyTarget;
        this.proxyHandler = proxyHandler;
    }

    public JSDynamicObject getProxyHandler() {
        return this.proxyHandler;
    }

    public Object getProxyTarget() {
        return this.proxyTarget;
    }

    public void revoke(boolean isCallable, boolean isConstructor) {
        this.proxyHandler = Null.instance;
        this.proxyTarget = RevokedTarget.lookup(isCallable, isConstructor);
    }

    @Override
    public TruffleString getClassName() {
        return JSProxy.CLASS_NAME;
    }

    @Override
    public TruffleString getBuiltinToStringTag() {
        Object targetNonProxy = JSProxy.getTargetNonProxy(this);
        if (JSDynamicObject.isJSDynamicObject(targetNonProxy)) {
            if (JSArray.isJSArray(targetNonProxy)) {
                return JSArray.CLASS_NAME;
            }
            if (JSFunction.isJSFunction(targetNonProxy)) {
                return JSFunction.CLASS_NAME;
            }
            return Strings.UC_OBJECT;
        }
        InteropLibrary interop = InteropLibrary.getUncached(targetNonProxy);
        if (interop.hasArrayElements(targetNonProxy)) {
            return JSArray.CLASS_NAME;
        }
        if (interop.isExecutable(targetNonProxy) || interop.isInstantiable(targetNonProxy)) {
            return JSFunction.CLASS_NAME;
        }
        return Strings.UC_OBJECT;
    }

    @ExportMessage
    public boolean isExecutable(@Cached IsCallableNode isCallable) {
        return isCallable.executeBoolean(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage
    public Object execute(Object[] args, @CachedLibrary(value="this") InteropLibrary self, @Cached JSInteropExecuteNode callNode, @Cached.Shared @Cached ExportValueNode exportNode) throws UnsupportedMessageException {
        JavaScriptLanguage language = JavaScriptLanguage.get(self);
        JSRealm realm = JSRealm.get(self);
        language.interopBoundaryEnter(realm);
        try {
            Object result = callNode.execute(this, Undefined.instance, args);
            Object object = exportNode.execute(result);
            return object;
        }
        finally {
            language.interopBoundaryExit(realm);
        }
    }

    @ExportMessage
    public boolean isInstantiable() {
        return JSRuntime.isConstructor(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage
    public Object instantiate(Object[] args, @CachedLibrary(value="this") InteropLibrary self, @Cached JSInteropInstantiateNode callNode, @Cached.Shared @Cached ExportValueNode exportNode) throws UnsupportedMessageException {
        JavaScriptLanguage language = JavaScriptLanguage.get(self);
        JSRealm realm = JSRealm.get(self);
        language.interopBoundaryEnter(realm);
        try {
            Object result = callNode.execute(this, args);
            Object object = exportNode.execute(result);
            return object;
        }
        finally {
            language.interopBoundaryExit(realm);
        }
    }

    @ExportMessage
    public boolean hasMetaObject() {
        return true;
    }

    @ExportMessage
    public Object getMetaObject() {
        return JSMetaType.JS_PROXY;
    }

    @Override
    public boolean isExtensible() {
        return JSProxy.INSTANCE.isExtensible(this);
    }

    @Override
    public boolean preventExtensions(boolean doThrow) {
        return JSProxy.INSTANCE.preventExtensions(this, doThrow);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public TruffleString toDisplayStringImpl(boolean allowSideEffects, ToDisplayStringFormat format, int depth) {
        if (JavaScriptLanguage.get(null).getJSContext().isOptionNashornCompatibilityMode()) {
            return this.defaultToString();
        }
        Object target = JSProxy.getTarget(this);
        JSDynamicObject handler = JSProxy.getHandler(this);
        return Strings.concatAll(Strings.PROXY_PAREN, JSRuntime.toDisplayStringInner(target, allowSideEffects, format, depth, this), Strings.COMMA_SPC, JSRuntime.toDisplayStringInner(handler, allowSideEffects, format, depth, this), Strings.PAREN_CLOSE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage
    public void removeMember(String key, @CachedLibrary(value="this") InteropLibrary self, @Cached @Cached.Shared TruffleString.FromJavaStringNode fromJavaString) throws UnsupportedMessageException {
        JavaScriptLanguage language = JavaScriptLanguage.get(self);
        JSRealm realm = JSRealm.get(self);
        language.interopBoundaryEnter(realm);
        try {
            super.removeMember(key, fromJavaString);
        }
        finally {
            language.interopBoundaryExit(realm);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage
    public Object getMembers(boolean internal, @CachedLibrary(value="this") InteropLibrary self) {
        JavaScriptLanguage language = JavaScriptLanguage.get(self);
        JSRealm realm = JSRealm.get(self);
        language.interopBoundaryEnter(realm);
        try {
            Object object = super.getMembers(internal);
            return object;
        }
        finally {
            language.interopBoundaryExit(realm);
        }
    }

    @ExportLibrary(value=InteropLibrary.class)
    public static final class RevokedTarget
    implements TruffleObject {
        private final boolean isCallable;
        private final boolean isConstructor;
        @CompilerDirectives.CompilationFinal(dimensions=1)
        static final Object[] REVOKED_TARGET = new Object[]{Null.instance, new RevokedTarget(true, false), new RevokedTarget(false, true), new RevokedTarget(true, true)};

        RevokedTarget(boolean isCallable, boolean isConstructor) {
            this.isCallable = isCallable;
            this.isConstructor = isConstructor;
        }

        @ExportMessage
        public boolean isExecutable() {
            return this.isCallable;
        }

        @ExportMessage
        public Object execute(Object[] args) throws UnsupportedMessageException {
            if (this.isExecutable()) {
                throw Errors.createTypeErrorProxyRevoked(JSProxy.APPLY, null);
            }
            throw UnsupportedMessageException.create();
        }

        @ExportMessage
        public boolean isInstantiable() {
            return this.isConstructor;
        }

        @ExportMessage
        public Object instantiate(Object[] args) throws UnsupportedMessageException {
            if (this.isInstantiable()) {
                throw Errors.createTypeErrorProxyRevoked(JSProxy.CONSTRUCT, null);
            }
            throw UnsupportedMessageException.create();
        }

        @ExportMessage
        public TruffleString toDisplayString(boolean allowSideEffects) {
            return Null.NAME;
        }

        @ExportMessage
        public boolean hasLanguage() {
            return true;
        }

        @ExportMessage
        public Class<? extends TruffleLanguage<?>> getLanguage() {
            return JavaScriptLanguage.class;
        }

        static Object lookup(boolean callable, boolean constructor) {
            return REVOKED_TARGET[(callable ? 1 : 0) + (constructor ? 2 : 0)];
        }
    }
}

