/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins;

import java.util.Objects;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerAsserts;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object.DynamicObjectLibrary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object.Property;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object.Shape;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Errors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRealm;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Properties;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSClass;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSFunctionFactory;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.PrototypeSupplier;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSShape;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.util.CompilableBiFunction;

public abstract class JSObjectFactory {
    protected final JSContext context;
    private final boolean inObjectProto;
    @CompilerDirectives.CompilationFinal
    private DynamicObjectLibrary setProto;

    public static UnboundProto createUnbound(JSContext context, Shape factory) {
        return new UnboundProto(context, factory);
    }

    public static BoundProto createBound(JSContext context, JSDynamicObject prototype, Shape factory) {
        return new BoundProto(context, prototype, factory);
    }

    static JSObjectFactory createIntrinsic(JSContext context, PrototypeSupplier prototypeSupplier, CompilableBiFunction<JSContext, JSDynamicObject, Shape> shapeSupplier, int slot) {
        return new LazySupplier(context, prototypeSupplier, shapeSupplier, slot);
    }

    static <T extends JSClass> JSObjectFactory createIntrinsic(JSContext context, T jsclass, int slot) {
        return new LazyJSClass<T>(context, jsclass, slot);
    }

    static CompilableBiFunction<JSContext, JSDynamicObject, Shape> defaultShapeSupplier(JSClass jsclass) {
        return (ctx, proto) -> JSObjectUtil.getProtoChildShape(proto, jsclass, ctx);
    }

    protected JSObjectFactory(JSContext context, boolean inObjectProto) {
        this.context = context;
        this.inObjectProto = inObjectProto;
    }

    public static boolean verifyPrototype(Shape shape, JSDynamicObject prototype) {
        return JSShape.getPrototypeProperty(shape).getLocation().isConstant() && JSShape.getPrototypeProperty(shape).getLocation().getConstantValue() == prototype;
    }

    public abstract JSDynamicObject getPrototype(JSRealm var1);

    public static boolean hasInObjectProto(Shape shape) {
        Property prototypeProperty = JSShape.getPrototypeProperty(shape);
        return prototypeProperty == null || !prototypeProperty.getLocation().isConstant();
    }

    public abstract Shape getShape(JSRealm var1, JSDynamicObject var2);

    public final Shape getShape(JSRealm realm) {
        return this.getShape(realm, this.getPrototype(realm));
    }

    public final <T extends JSDynamicObject> T initProto(T obj, JSRealm realm) {
        return this.initProto(obj, realm, this.getPrototype(realm));
    }

    public final <T extends JSDynamicObject> T initProto(T obj, JSRealm realm, JSDynamicObject prototype) {
        if (this.isInObjectProto(realm, prototype)) {
            this.setPrototype(obj, prototype);
        } else assert (JSObjectFactory.verifyPrototype(obj.getShape(), prototype));
        return obj;
    }

    protected void setPrototype(JSDynamicObject obj, JSDynamicObject prototype) {
        if (this.setProto == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.setProto = this.context.adoptNode(JSObjectUtil.createCached(JSObject.HIDDEN_PROTO, obj));
        }
        Properties.put(this.setProto, obj, JSObject.HIDDEN_PROTO, prototype);
    }

    public final <T extends JSDynamicObject> T trackAllocation(T obj) {
        return this.context.trackAllocation(obj);
    }

    protected final boolean isInObjectProto(JSRealm realm, JSDynamicObject prototype) {
        return this.inObjectProto && this.context.isMultiContext() || prototype != this.getPrototype(realm);
    }

    public static final class UnboundProto
    extends JSObjectFactory {
        private final Shape factory;

        protected UnboundProto(JSContext context, Shape factory) {
            super(context, UnboundProto.hasInObjectProto(factory));
            this.factory = factory;
        }

        @Override
        public Shape getShape(JSRealm realm, JSDynamicObject proto) {
            return this.factory;
        }

        @Override
        public JSDynamicObject getPrototype(JSRealm realm) {
            throw Errors.shouldNotReachHere();
        }
    }

    public static final class BoundProto
    extends JSObjectFactory {
        private final JSDynamicObject prototype;
        private final Shape factory;

        protected BoundProto(JSContext context, JSDynamicObject prototype, Shape factory) {
            super(context, BoundProto.hasInObjectProto(factory));
            this.prototype = Objects.requireNonNull(prototype);
            this.factory = factory;
        }

        @Override
        public JSDynamicObject getPrototype(JSRealm realm) {
            return this.prototype;
        }

        @Override
        public Shape getShape(JSRealm realm, JSDynamicObject proto) {
            assert (proto == this.prototype);
            return this.factory;
        }
    }

    private static final class LazySupplier
    extends Lazy {
        protected final PrototypeSupplier prototypeSupplier;
        protected final CompilableBiFunction<JSContext, JSDynamicObject, Shape> shapeSupplier;

        protected LazySupplier(JSContext context, PrototypeSupplier prototypeSupplier, CompilableBiFunction<JSContext, JSDynamicObject, Shape> shapeSupplier, int slot) {
            super(context, slot);
            this.prototypeSupplier = prototypeSupplier;
            this.shapeSupplier = shapeSupplier;
        }

        @Override
        public JSDynamicObject getPrototype(JSRealm realm) {
            return this.prototypeSupplier.getIntrinsicDefaultProto(realm);
        }

        @Override
        protected Shape makeInitialShape(JSDynamicObject prototype) {
            return (Shape)this.shapeSupplier.apply(this.context, prototype);
        }
    }

    private static final class LazyJSClass<T extends JSClass>
    extends Lazy {
        protected final T jsclass;

        protected LazyJSClass(JSContext context, T jsclass, int slot) {
            super(context, slot);
            this.jsclass = jsclass;
        }

        @Override
        public JSDynamicObject getPrototype(JSRealm realm) {
            return ((JSClass)this.jsclass).getIntrinsicDefaultProto(realm);
        }

        @Override
        protected Shape makeInitialShape(JSDynamicObject prototype) {
            return ((JSClass)this.jsclass).makeInitialShape(this.context, prototype);
        }
    }

    private static abstract class Lazy
    extends JSObjectFactory {
        @CompilerDirectives.CompilationFinal
        private Shape sharedShape;
        private final int slot;

        protected Lazy(JSContext context, int slot) {
            super(context, context.isMultiContext());
            this.slot = slot;
        }

        @Override
        public final Shape getShape(JSRealm realm, JSDynamicObject prototype) {
            Shape initialShape;
            CompilerAsserts.partialEvaluationConstant(this);
            boolean inObjectProto = this.isInObjectProto(realm, prototype);
            if (inObjectProto || this.context.isMultiContext()) {
                initialShape = this.sharedShape;
                if (initialShape == null) {
                    Shape newShape;
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.sharedShape = initialShape = (newShape = this.makeInitialShape(inObjectProto ? null : prototype));
                }
            } else {
                assert (prototype == this.getPrototype(realm));
                initialShape = realm.getObjectFactories().shapes[this.slot];
                if (initialShape == null) {
                    Shape newShape;
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    realm.getObjectFactories().shapes[this.slot] = initialShape = (newShape = this.makeInitialShape(prototype));
                }
            }
            assert (inObjectProto == Lazy.hasInObjectProto(initialShape));
            return initialShape;
        }

        protected abstract Shape makeInitialShape(JSDynamicObject var1);
    }

    public static final class RealmData {
        @CompilerDirectives.CompilationFinal(dimensions=1)
        final Shape[] shapes;

        public RealmData(int count) {
            this.shapes = new Shape[count];
        }
    }

    public static final class IntrinsicBuilder {
        private final JSContext context;
        private int count;
        private boolean closed;

        public IntrinsicBuilder(JSContext context) {
            this.context = context;
        }

        public JSObjectFactory create(PrototypeSupplier prototypeSupplier, CompilableBiFunction<JSContext, JSDynamicObject, Shape> shapeSupplier) {
            int index = this.nextIndex();
            return JSObjectFactory.createIntrinsic(this.context, prototypeSupplier, shapeSupplier, index);
        }

        public JSObjectFactory create(PrototypeSupplier prototypeSupplier, JSClass jsclass) {
            int index = this.nextIndex();
            return JSObjectFactory.createIntrinsic(this.context, prototypeSupplier, JSObjectFactory.defaultShapeSupplier(jsclass), index);
        }

        public <T extends JSClass> JSObjectFactory create(T jsclass) {
            int index = this.nextIndex();
            return JSObjectFactory.createIntrinsic(this.context, jsclass, index);
        }

        public JSFunctionFactory function(PrototypeSupplier intrinsicDefaultProto, boolean isStrict, boolean isConstructor, boolean isGenerator, boolean isBound, boolean isAsync) {
            JSObjectFactory objectFactory = this.create(intrinsicDefaultProto, (ctx, prototype) -> JSFunctionFactory.makeShape(ctx, prototype, isStrict, false, isConstructor, isGenerator, isBound, isAsync));
            return JSFunctionFactory.createIntrinsic(this.context, objectFactory, isStrict, isConstructor, isGenerator, isBound, isAsync);
        }

        int nextIndex() {
            assert (!this.closed);
            return this.count++;
        }

        public int finish() {
            assert (!this.closed);
            this.closed = true;
            return this.count;
        }
    }
}

