/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.ImportStatic;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.ExceptionType;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.InteropLibrary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.UnsupportedMessageException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.library.ExportLibrary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.library.ExportMessage;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.lang.JavaScriptLanguage;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.GraalJSException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSConfig;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRuntime;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Strings;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSError;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.Undefined;

@ExportLibrary(value=InteropLibrary.class, delegateTo="exceptionObject")
@ImportStatic(value={JSConfig.class})
public final class UserScriptException
extends GraalJSException {
    final Object exceptionObject;

    private UserScriptException(Object exceptionObject, Node originatingNode, int stackTraceLimit) {
        super(UserScriptException.getMessage(exceptionObject), originatingNode, stackTraceLimit);
        this.exceptionObject = exceptionObject;
    }

    private UserScriptException(Throwable exception, Node originatingNode, int stackTraceLimit) {
        super(exception.toString(), exception, originatingNode, stackTraceLimit);
        this.exceptionObject = exception;
    }

    @CompilerDirectives.TruffleBoundary
    public static UserScriptException createCapture(Object exceptionObject, Node originatingNode, int stackTraceLimit, JSDynamicObject skipFramesUpTo, boolean customSkip) {
        return UserScriptException.fillInStackTrace(new UserScriptException(exceptionObject, originatingNode, stackTraceLimit), true, skipFramesUpTo, customSkip);
    }

    @CompilerDirectives.TruffleBoundary
    public static UserScriptException createCapture(Object exceptionObject, Node originatingNode, int stackTraceLimit) {
        return UserScriptException.createCapture(exceptionObject, originatingNode, stackTraceLimit, Undefined.instance, false);
    }

    @CompilerDirectives.TruffleBoundary
    public static UserScriptException create(Object exceptionObject, Node originatingNode, int stackTraceLimit) {
        return UserScriptException.fillInStackTrace(new UserScriptException(exceptionObject, originatingNode, stackTraceLimit), false);
    }

    @CompilerDirectives.TruffleBoundary
    public static UserScriptException create(Object exceptionObject) {
        int stackTraceLimit = JavaScriptLanguage.getCurrentLanguage().getJSContext().getLanguageOptions().stackTraceLimit();
        return UserScriptException.create(exceptionObject, null, stackTraceLimit);
    }

    @Override
    public Object getErrorObject() {
        return this.exceptionObject;
    }

    @Override
    public Object getErrorObjectLazy() {
        return this.exceptionObject;
    }

    @ExportMessage
    public boolean isException() {
        return true;
    }

    @ExportMessage
    public RuntimeException throwException() {
        throw this;
    }

    @ExportMessage
    public ExceptionType getExceptionType() {
        return ExceptionType.RUNTIME_ERROR;
    }

    @ExportMessage
    public boolean isExceptionIncompleteSource() {
        return false;
    }

    @ExportMessage
    public boolean hasExceptionMessage() {
        return this.getMessage() != null;
    }

    @ExportMessage
    public Object getExceptionMessage() throws UnsupportedMessageException {
        String message = this.getMessage();
        if (message == null) {
            throw UnsupportedMessageException.create();
        }
        return message;
    }

    @CompilerDirectives.TruffleBoundary
    private static String getMessage(Object exc) {
        if (exc instanceof JSObject) {
            TruffleString messageStr;
            Object messageValue;
            JSObject errorObj = (JSObject)exc;
            String name = UserScriptException.getErrorNameSafe(errorObj, "Error");
            String message = UserScriptException.getErrorMessageSafe(errorObj, null);
            if (message == null && JSObject.getJSContext(errorObj).getLanguageOptions().testV8Mode() && (messageValue = JSObject.get((JSDynamicObject)errorObj, JSError.MESSAGE)) instanceof TruffleString && !(messageStr = (TruffleString)messageValue).isEmpty()) {
                message = Strings.toJavaString(messageStr);
            }
            return UserScriptException.concatErrorNameAndMessage(name, message);
        }
        return Strings.toJavaString(JSRuntime.safeToString(exc));
    }
}

