/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.InteropException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.InteropLibrary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.source.Source;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.BigInt;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Errors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.GraalJSException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSAgentWaiterList;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSErrorType;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRealm;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRuntime;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.RegexCompilerInterface;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Strings;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Symbol;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.array.TypedArray;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSAbstractArray;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSArray;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSArrayBuffer;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSArrayBufferObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSArrayBufferView;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSArrayObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSBigInt;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSBigIntObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSBoolean;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSBooleanObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSDataView;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSDataViewObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSDate;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSDateObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSError;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSErrorObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSMap;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSMapObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSNumber;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSNumberObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSOrdinary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSRegExp;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSRegExpObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSSet;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSSetObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSSharedArrayBuffer;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSStringObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSTypedArrayObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.wasm.JSWebAssemblyMemory;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.wasm.JSWebAssemblyMemoryObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.wasm.JSWebAssemblyModule;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.wasm.JSWebAssemblyModuleObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSAttributes;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.Null;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.PropertyDescriptor;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.Undefined;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.util.JSHashMap;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.util.TRegexUtil;
import org.cyclops.integratedscripting.vendors.org.graalvm.collections.EconomicSet;

public class SerializedData {
    private final List<Object> data = new ArrayList<Object>();
    private int nextId;
    private Map<Object, Integer> memory = new IdentityHashMap<Object, Integer>();

    public SerializedData(Object value) {
        this(value, null);
    }

    public SerializedData(Object value, EconomicSet<JSArrayBufferObject> transferSet) {
        int transferableCount = transferSet == null ? 0 : transferSet.size();
        this.data.add(transferableCount);
        if (transferableCount != 0) {
            for (JSArrayBufferObject transferable : transferSet) {
                if (transferable instanceof JSArrayBufferObject.Shared) {
                    throw Errors.createError("Cannot transfer SharedArrayBuffer");
                }
                this.serializeTransferable(transferable);
            }
        }
        this.serializeValue(value);
        if (transferableCount != 0) {
            for (JSArrayBufferObject transferable : transferSet) {
                JSArrayBuffer.detachArrayBuffer(transferable);
            }
        }
        this.memory = null;
    }

    private void serializeValue(Object value) {
        if (value == Undefined.instance || value == Null.instance || value instanceof Boolean || value instanceof Integer || value instanceof Double || value instanceof Long || value instanceof BigInt || value instanceof TruffleString) {
            this.data.add((Object)Type.Primitive);
            this.data.add(value);
            return;
        }
        if (value instanceof Symbol) {
            throw SerializedData.couldNotBeClonedError(value);
        }
        Integer id = this.memory.get(value);
        if (id != null) {
            this.data.add((Object)Type.Duplicate);
            this.data.add(id);
            return;
        }
        this.assignId(value);
        if (value instanceof JSBooleanObject) {
            JSBooleanObject booleanObject = (JSBooleanObject)value;
            this.data.add((Object)Type.Boolean);
            this.data.add(booleanObject.getBooleanValue());
        } else if (value instanceof JSNumberObject) {
            JSNumberObject numberObject = (JSNumberObject)value;
            this.data.add((Object)Type.Number);
            this.data.add(numberObject.getNumber());
        } else if (value instanceof JSBigIntObject) {
            JSBigIntObject bigIntObject = (JSBigIntObject)value;
            this.data.add((Object)Type.BigInt);
            this.data.add(bigIntObject.getBigIntValue());
        } else if (value instanceof JSStringObject) {
            JSStringObject stringObject = (JSStringObject)value;
            this.data.add((Object)Type.String);
            this.data.add(stringObject.getString());
        } else if (value instanceof JSDateObject) {
            JSDateObject dateObject = (JSDateObject)value;
            this.data.add((Object)Type.Date);
            this.data.add(dateObject.getTimeMillis());
        } else if (value instanceof JSRegExpObject) {
            JSRegExpObject regExpObject = (JSRegExpObject)value;
            this.serializeRegExp(regExpObject);
        } else if (value instanceof JSArrayBufferObject.Shared) {
            JSArrayBufferObject.Shared sharedArrayBuffer = (JSArrayBufferObject.Shared)value;
            this.serializeSharedArrayBuffer(sharedArrayBuffer);
        } else if (value instanceof JSArrayBufferObject) {
            JSArrayBufferObject arrayBuffer = (JSArrayBufferObject)value;
            this.serializeArrayBuffer(arrayBuffer);
        } else if (value instanceof JSTypedArrayObject) {
            JSTypedArrayObject typedArray = (JSTypedArrayObject)value;
            this.serializeArrayBufferView(typedArray);
        } else if (value instanceof JSDataViewObject) {
            JSDataViewObject dataView = (JSDataViewObject)value;
            this.serializeDataView(dataView);
        } else if (value instanceof JSMapObject) {
            JSMapObject mapObject = (JSMapObject)value;
            this.serializeMap(mapObject);
        } else if (value instanceof JSSetObject) {
            JSSetObject setObject = (JSSetObject)value;
            this.serializeSet(setObject);
        } else if (value instanceof JSErrorObject) {
            JSErrorObject errorObject = (JSErrorObject)value;
            this.serializeError(errorObject);
        } else if (value instanceof JSArrayObject) {
            JSArrayObject arrayObject = (JSArrayObject)value;
            this.data.add((Object)Type.Array);
            this.data.add(JSAbstractArray.arrayGetLength(arrayObject));
            this.serializeProperties(arrayObject);
        } else if (value instanceof JSWebAssemblyMemoryObject) {
            JSWebAssemblyMemoryObject memoryObject = (JSWebAssemblyMemoryObject)value;
            this.serializeWebAssemblyMemory(memoryObject);
        } else if (value instanceof JSWebAssemblyModuleObject) {
            JSWebAssemblyModuleObject moduleObject = (JSWebAssemblyModuleObject)value;
            this.serializeWebAssemblyModule(moduleObject);
        } else if (value instanceof JSObject) {
            JSObject object = (JSObject)value;
            this.data.add((Object)Type.Object);
            this.serializeProperties(object);
        } else {
            throw SerializedData.couldNotBeClonedError(value);
        }
    }

    private static JSException couldNotBeClonedError(Object value) {
        return Errors.createError(String.valueOf(JSRuntime.safeToString(value)) + " could not be cloned.");
    }

    private void assignId(Object value) {
        this.memory.put(value, this.nextId++);
    }

    private void serializeTransferable(JSArrayBufferObject arrayBuffer) {
        Object content;
        this.assignId(arrayBuffer);
        if (arrayBuffer instanceof JSArrayBufferObject.Heap) {
            JSArrayBufferObject.Heap heapBuffer = (JSArrayBufferObject.Heap)arrayBuffer;
            content = heapBuffer.getByteArray();
        } else if (arrayBuffer instanceof JSArrayBufferObject.Direct) {
            JSArrayBufferObject.Direct directBuffer = (JSArrayBufferObject.Direct)arrayBuffer;
            content = directBuffer.getByteBuffer();
        } else {
            content = ((JSArrayBufferObject.Interop)arrayBuffer).getInteropBuffer();
        }
        this.serializeArrayBufferImpl(content, arrayBuffer.getByteLength(), arrayBuffer.getMaxByteLength());
    }

    private void serializeRegExp(JSRegExpObject regExp) {
        Object compiledRegex = regExp.getCompiledRegex();
        TruffleString pattern = TRegexUtil.InteropReadStringMemberNode.getUncached().execute(null, compiledRegex, "pattern");
        Object flagsObject = TRegexUtil.InteropReadMemberNode.getUncached().execute(null, compiledRegex, "flags");
        TruffleString flags = TRegexUtil.InteropReadStringMemberNode.getUncached().execute(null, flagsObject, "source");
        this.data.add((Object)Type.RegExp);
        this.data.add(pattern);
        this.data.add(flags);
    }

    private void serializeSharedArrayBuffer(JSArrayBufferObject.Shared sharedArrayBuffer) {
        this.data.add((Object)Type.SharedArrayBuffer);
        this.data.add(sharedArrayBuffer.getByteBuffer());
        this.data.add(sharedArrayBuffer.getByteLengthObject());
        this.data.add(sharedArrayBuffer.getMaxByteLength());
        this.data.add(sharedArrayBuffer.getWaiterList());
    }

    private void serializeArrayBuffer(JSArrayBufferObject arrayBuffer) {
        Object content;
        if (arrayBuffer instanceof JSArrayBufferObject.Heap) {
            JSArrayBufferObject.Heap heapBuffer = (JSArrayBufferObject.Heap)arrayBuffer;
            byte[] original = heapBuffer.getByteArray();
            content = Arrays.copyOf(original, original.length);
        } else if (arrayBuffer instanceof JSArrayBufferObject.Direct) {
            JSArrayBufferObject.Direct directBuffer = (JSArrayBufferObject.Direct)arrayBuffer;
            ByteBuffer original = directBuffer.getByteBuffer();
            ByteBuffer copy = ByteBuffer.allocateDirect(original.capacity());
            copy.put(original.duplicate().rewind());
            content = copy;
        } else {
            JSArrayBufferObject.Interop interopBuffer = (JSArrayBufferObject.Interop)arrayBuffer;
            Object foreignBuffer = interopBuffer.getInteropBuffer();
            int length = interopBuffer.getByteLength();
            byte[] array = new byte[length];
            try {
                InteropLibrary.getUncached().readBuffer(foreignBuffer, 0L, array, 0, length);
                if (arrayBuffer.getJSContext().isOptionDirectByteBuffer()) {
                    ByteBuffer byteBuffer = ByteBuffer.allocateDirect(length);
                    byteBuffer.put(array);
                    content = byteBuffer;
                } else {
                    content = array;
                }
            }
            catch (InteropException iex) {
                throw SerializedData.couldNotBeClonedError(interopBuffer);
            }
        }
        this.serializeArrayBufferImpl(content, arrayBuffer.getByteLength(), arrayBuffer.getMaxByteLength());
    }

    private void serializeArrayBufferImpl(Object content, int byteLength, int maxByteLength) {
        this.data.add((Object)Type.ArrayBuffer);
        this.data.add(content);
        this.data.add(byteLength);
        this.data.add(maxByteLength);
    }

    private void serializeArrayBufferView(JSTypedArrayObject arrayBufferView) {
        if (JSArrayBufferView.isOutOfBounds(arrayBufferView, arrayBufferView.getJSContext())) {
            throw SerializedData.couldNotBeClonedError(arrayBufferView);
        }
        this.data.add((Object)Type.ArrayBufferView);
        this.data.add(arrayBufferView.getArrayType());
        this.data.add(arrayBufferView.hasAutoLength() ? -1 : arrayBufferView.getLength());
        this.data.add(arrayBufferView.getByteOffset());
        this.serializeValue(arrayBufferView.getArrayBuffer());
    }

    private void serializeDataView(JSDataViewObject dataView) {
        this.data.add((Object)Type.DataView);
        this.data.add(dataView.hasAutoLength() ? -1 : dataView.getByteLength());
        this.data.add(dataView.getByteOffset());
        this.serializeValue(dataView.getArrayBuffer());
    }

    private void serializeMap(JSMapObject mapObject) {
        this.data.add((Object)Type.Map);
        JSHashMap map = mapObject.getMap();
        this.data.add(map.size());
        JSHashMap.Cursor cursor = map.getEntries();
        while (cursor.advance()) {
            this.serializeValue(cursor.getKey());
            this.serializeValue(cursor.getValue());
        }
    }

    private void serializeSet(JSSetObject setObject) {
        this.data.add((Object)Type.Set);
        JSHashMap map = setObject.getMap();
        this.data.add(map.size());
        JSHashMap.Cursor cursor = map.getEntries();
        while (cursor.advance()) {
            this.serializeValue(cursor.getKey());
        }
    }

    private void serializeError(JSErrorObject errorObject) {
        PropertyDescriptor desc;
        GraalJSException exception = errorObject.getException();
        JSErrorType type = JSErrorType.Error;
        if (exception instanceof JSException) {
            JSException jsException = (JSException)exception;
            type = jsException.getErrorType();
        }
        Object message = (desc = JSObject.getOwnProperty(errorObject, Strings.MESSAGE)) != null && desc.isDataDescriptor() ? JSRuntime.toString(desc.getValue()) : Undefined.instance;
        Object stack = JSObject.get((JSDynamicObject)errorObject, JSError.STACK_NAME);
        desc = JSObject.getOwnProperty(errorObject, Strings.CAUSE);
        Object cause = desc != null && desc.isDataDescriptor() ? desc.getValue() : Undefined.instance;
        this.data.add((Object)Type.Error);
        this.data.add(type);
        this.data.add(message);
        this.data.add(stack instanceof TruffleString ? stack : Undefined.instance);
        this.data.add(cause);
    }

    private void serializeWebAssemblyMemory(JSWebAssemblyMemoryObject memoryObject) {
        if (!memoryObject.isShared()) {
            throw SerializedData.couldNotBeClonedError(memoryObject);
        }
        Object wasmMemory = memoryObject.getWASMMemory();
        JSArrayBufferObject arrayBuffer = memoryObject.getBufferObject(memoryObject.getJSContext(), JSRealm.get(null));
        JSAgentWaiterList waiterList = JSSharedArrayBuffer.getWaiterList(arrayBuffer);
        this.data.add((Object)Type.WebAssemblyMemory);
        this.data.add(wasmMemory);
        this.data.add(waiterList);
    }

    private void serializeWebAssemblyModule(JSWebAssemblyModuleObject moduleObject) {
        this.data.add((Object)Type.WebAssemblyModule);
        this.data.add(moduleObject.getWASMModule());
        this.data.add(moduleObject.getWASMSource());
    }

    private void serializeProperties(JSObject object) {
        List<TruffleString> names = JSObject.enumerableOwnNames(object);
        this.data.add(names.size());
        for (TruffleString key : names) {
            Object value = JSObject.get((JSDynamicObject)object, key);
            this.serializeValue(key);
            this.serializeValue(value);
        }
    }

    public Object deserialize(JSRealm realm) {
        Iterator<Object> iter = this.data.iterator();
        ArrayList<Object> deserialized = new ArrayList<Object>();
        int transferableCount = (Integer)iter.next();
        for (int i = 0; i < transferableCount; ++i) {
            SerializedData.deserializeValue(realm, iter, deserialized);
        }
        return SerializedData.deserializeValue(realm, iter, deserialized);
    }

    private static Object deserializeValue(JSRealm realm, Iterator<Object> iter, List<Object> deserialized) {
        Object result;
        JSContext context = realm.getContext();
        Type type = (Type)((Object)iter.next());
        switch (type.ordinal()) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case 0: {
                Object object = iter.next();
                break;
            }
            case 1: {
                Object object = deserialized.get((Integer)iter.next());
                break;
            }
            case 2: {
                Object object = JSBoolean.create(context, realm, (Boolean)iter.next());
                break;
            }
            case 3: {
                Object object = JSNumber.create(context, realm, (Number)iter.next());
                break;
            }
            case 4: {
                Object object = JSBigInt.create(context, realm, (BigInt)iter.next());
                break;
            }
            case 5: {
                Object object = JSString.create(context, realm, (TruffleString)iter.next());
                break;
            }
            case 6: {
                Object object = JSDate.create(context, realm, (Double)iter.next());
                break;
            }
            case 7: {
                Object object = SerializedData.deserializeRegExp(realm, iter);
                break;
            }
            case 8: {
                Object object = SerializedData.deserializeSharedArrayBuffer(realm, iter);
                break;
            }
            case 9: {
                Object object = SerializedData.deserializeArrayBuffer(realm, iter);
                break;
            }
            case 10: {
                Object object = SerializedData.deserializeArrayBufferView(realm, iter, deserialized);
                break;
            }
            case 11: {
                Object object = SerializedData.deserializeDataView(realm, iter, deserialized);
                break;
            }
            case 12: {
                Object object = SerializedData.deserializeMap(realm, iter, deserialized);
                break;
            }
            case 13: {
                Object object = SerializedData.deserializeSet(realm, iter, deserialized);
                break;
            }
            case 14: {
                Object object = SerializedData.deserializeError(realm, iter);
                break;
            }
            case 15: {
                Object object = SerializedData.deserializeArray(realm, iter, deserialized);
                break;
            }
            case 16: {
                Object object = SerializedData.deserializeObject(realm, iter, deserialized);
                break;
            }
            case 17: {
                Object object = SerializedData.deserializeWebAssemblyMemory(realm, iter);
                break;
            }
            case 18: {
                Object object = result = SerializedData.deserializeWebAssemblyModule(realm, iter);
            }
        }
        if (type != Type.Primitive && type != Type.Duplicate && type != Type.Map && type != Type.Set && type != Type.Array && type != Type.Object) {
            deserialized.add(result);
        }
        return result;
    }

    private static Object deserializeRegExp(JSRealm realm, Iterator<Object> iter) {
        TruffleString pattern = (TruffleString)iter.next();
        TruffleString flags = (TruffleString)iter.next();
        JSContext context = realm.getContext();
        Object compiledRegexp = RegexCompilerInterface.compile(pattern, flags, context, realm);
        return JSRegExp.create(context, realm, compiledRegexp);
    }

    private static Object deserializeSharedArrayBuffer(JSRealm realm, Iterator<Object> iter) {
        ByteBuffer byteBuffer = (ByteBuffer)iter.next();
        AtomicInteger byteLength = (AtomicInteger)iter.next();
        int maxByteLength = (Integer)iter.next();
        JSAgentWaiterList waiterList = (JSAgentWaiterList)iter.next();
        JSArrayBufferObject sharedArrayBuffer = JSSharedArrayBuffer.createSharedArrayBuffer(realm.getContext(), realm, byteBuffer, byteLength, maxByteLength);
        ((JSArrayBufferObject.Shared)sharedArrayBuffer).setWaiterList(waiterList);
        return sharedArrayBuffer;
    }

    private static JSArrayBufferObject deserializeArrayBuffer(JSRealm realm, Iterator<Object> iter) {
        JSContext context = realm.getContext();
        Object content = iter.next();
        int byteLength = (Integer)iter.next();
        int maxByteLength = (Integer)iter.next();
        if (content instanceof byte[] || content == null) {
            return JSArrayBuffer.createArrayBuffer(context, realm, (byte[])content, byteLength, maxByteLength);
        }
        if (content instanceof ByteBuffer) {
            ByteBuffer buffer = (ByteBuffer)content;
            return JSArrayBuffer.createDirectArrayBuffer(context, realm, buffer, byteLength, maxByteLength);
        }
        return JSArrayBuffer.createInteropArrayBuffer(context, realm, content);
    }

    private static Object deserializeArrayBufferView(JSRealm realm, Iterator<Object> iter, List<Object> deserialized) {
        TypedArray arrayType = (TypedArray)iter.next();
        int length = (Integer)iter.next();
        int byteOffset = (Integer)iter.next();
        JSArrayBufferObject arrayBuffer = (JSArrayBufferObject)SerializedData.deserializeValue(realm, iter, deserialized);
        return JSArrayBufferView.createArrayBufferView(realm.getContext(), realm, arrayBuffer, arrayType.getFactory(), arrayType, byteOffset, length);
    }

    private static Object deserializeDataView(JSRealm realm, Iterator<Object> iter, List<Object> deserialized) {
        int byteLength = (Integer)iter.next();
        int byteOffset = (Integer)iter.next();
        JSArrayBufferObject arrayBuffer = (JSArrayBufferObject)SerializedData.deserializeValue(realm, iter, deserialized);
        return JSDataView.createDataView(realm.getContext(), realm, arrayBuffer, byteOffset, byteLength);
    }

    private static Object deserializeMap(JSRealm realm, Iterator<Object> iter, List<Object> deserialized) {
        JSMapObject mapObject = JSMap.create(realm.getContext(), realm);
        deserialized.add(mapObject);
        JSHashMap map = mapObject.getMap();
        int size = (Integer)iter.next();
        for (int i = 0; i < size; ++i) {
            Object key = SerializedData.deserializeValue(realm, iter, deserialized);
            Object value = SerializedData.deserializeValue(realm, iter, deserialized);
            map.put(key, value);
        }
        return mapObject;
    }

    private static Object deserializeSet(JSRealm realm, Iterator<Object> iter, List<Object> deserialized) {
        JSSetObject setObject = JSSet.create(realm.getContext(), realm);
        deserialized.add(setObject);
        JSHashMap map = setObject.getMap();
        int size = (Integer)iter.next();
        for (int i = 0; i < size; ++i) {
            Object value = SerializedData.deserializeValue(realm, iter, deserialized);
            map.put(value, value);
        }
        return setObject;
    }

    private static Object deserializeError(JSRealm realm, Iterator<Object> iter) {
        JSErrorType type = (JSErrorType)iter.next();
        Object message = iter.next();
        Object stack = iter.next();
        Object cause = iter.next();
        JSErrorObject errorObject = JSError.create(type, realm, message);
        JSObject.set((JSDynamicObject)errorObject, JSError.STACK_NAME, stack);
        if (cause != Undefined.instance) {
            JSObject.defineOwnProperty(errorObject, Strings.CAUSE, PropertyDescriptor.createData(cause, JSAttributes.getDefaultNotEnumerable()));
        }
        return errorObject;
    }

    private static Object deserializeArray(JSRealm realm, Iterator<Object> iter, List<Object> deserialized) {
        long length = (Long)iter.next();
        JSArrayObject array = JSArray.createEmptyChecked(realm.getContext(), realm, length);
        deserialized.add(array);
        SerializedData.deserializeProperties(realm, iter, array, deserialized);
        return array;
    }

    private static Object deserializeObject(JSRealm realm, Iterator<Object> iter, List<Object> deserialized) {
        JSObject object = JSOrdinary.create(realm.getContext(), realm);
        deserialized.add(object);
        SerializedData.deserializeProperties(realm, iter, object, deserialized);
        return object;
    }

    private static void deserializeProperties(JSRealm realm, Iterator<Object> iter, JSObject object, List<Object> deserialized) {
        int count = (Integer)iter.next();
        for (int i = 0; i < count; ++i) {
            Object key = SerializedData.deserializeValue(realm, iter, deserialized);
            Object value = SerializedData.deserializeValue(realm, iter, deserialized);
            JSObject.set((JSDynamicObject)object, key, value);
        }
    }

    private static Object deserializeWebAssemblyMemory(JSRealm realm, Iterator<Object> iter) {
        Object wasmMemory = iter.next();
        JSAgentWaiterList waiterList = (JSAgentWaiterList)iter.next();
        JSContext context = realm.getContext();
        JSWebAssemblyMemoryObject webAssemblyMemory = JSWebAssemblyMemory.create(context, realm, wasmMemory, true);
        JSArrayBufferObject arrayBuffer = webAssemblyMemory.getBufferObject(context, realm);
        JSSharedArrayBuffer.setWaiterList(arrayBuffer, waiterList);
        return webAssemblyMemory;
    }

    private static Object deserializeWebAssemblyModule(JSRealm realm, Iterator<Object> iter) {
        Object wasmModule = iter.next();
        Source wasmSource = (Source)iter.next();
        return JSWebAssemblyModule.create(realm.getContext(), realm, wasmModule, wasmSource);
    }

    private static enum Type {
        Primitive,
        Duplicate,
        Boolean,
        Number,
        BigInt,
        String,
        Date,
        RegExp,
        SharedArrayBuffer,
        ArrayBuffer,
        ArrayBufferView,
        DataView,
        Map,
        Set,
        Error,
        Array,
        Object,
        WebAssemblyMemory,
        WebAssemblyModule;

    }
}

