/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.temporal;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Cached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.InlinedBranchProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.InlinedConditionProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.IsObjectNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.intl.GetOptionsObjectNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.temporal.TemporalGetOptionNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Errors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRealm;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDateTimeRecord;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDurationRecord;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDateTime;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDateTimeObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainTime;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainTimeObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalZonedDateTimeObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.util.TemporalUtil;

public abstract class ToTemporalTimeNode
extends JavaScriptBaseNode {
    protected ToTemporalTimeNode() {
    }

    public abstract JSTemporalPlainTimeObject execute(Object var1, Object var2);

    @Specialization
    protected JSTemporalPlainTimeObject toTemporalTime(Object item, Object options, @Cached IsObjectNode isObjectNode, @Cached(value="create(getJSContext())") GetOptionsObjectNode getOptionsObjectNode, @Cached TemporalGetOptionNode getOptionNode, @Cached InlinedConditionProfile isObjectProfile, @Cached InlinedConditionProfile isPlainDateTimeProfile, @Cached InlinedConditionProfile isZonedDateTimeProfile, @Cached InlinedConditionProfile isPlainTimeProfile, @Cached InlinedBranchProfile errorBranch) {
        JSTemporalDurationRecord result2;
        assert (options != null);
        JSContext ctx = this.getJSContext();
        JSRealm realm = this.getRealm();
        if (isObjectProfile.profile(this, isObjectNode.executeBoolean(item))) {
            if (isPlainTimeProfile.profile(this, JSTemporalPlainTime.isJSTemporalPlainTime(item))) {
                Object resolvedOptions = getOptionsObjectNode.execute(options);
                TemporalUtil.getTemporalOverflowOption(resolvedOptions, getOptionNode);
                JSTemporalPlainTimeObject plainTime = (JSTemporalPlainTimeObject)item;
                return JSTemporalPlainTime.create(ctx, realm, plainTime.getHour(), plainTime.getMinute(), plainTime.getSecond(), plainTime.getMillisecond(), plainTime.getMicrosecond(), plainTime.getNanosecond(), this, errorBranch);
            }
            if (isPlainDateTimeProfile.profile(this, JSTemporalPlainDateTime.isJSTemporalPlainDateTime(item))) {
                Object resolvedOptions = getOptionsObjectNode.execute(options);
                TemporalUtil.getTemporalOverflowOption(resolvedOptions, getOptionNode);
                JSTemporalPlainDateTimeObject plainDateTime = (JSTemporalPlainDateTimeObject)item;
                return JSTemporalPlainTime.create(ctx, realm, plainDateTime.getHour(), plainDateTime.getMinute(), plainDateTime.getSecond(), plainDateTime.getMillisecond(), plainDateTime.getMicrosecond(), plainDateTime.getNanosecond(), this, errorBranch);
            }
            if (isZonedDateTimeProfile.profile(this, TemporalUtil.isTemporalZonedDateTime(item))) {
                JSTemporalZonedDateTimeObject zonedDateTime = (JSTemporalZonedDateTimeObject)item;
                JSTemporalDateTimeRecord isoDateTime = TemporalUtil.getISODateTimeFor(zonedDateTime.getTimeZone(), zonedDateTime.getNanoseconds());
                Object resolvedOptions = getOptionsObjectNode.execute(options);
                TemporalUtil.getTemporalOverflowOption(resolvedOptions, getOptionNode);
                return JSTemporalPlainTime.create(ctx, realm, isoDateTime.getHour(), isoDateTime.getMinute(), isoDateTime.getSecond(), isoDateTime.getMillisecond(), isoDateTime.getMicrosecond(), isoDateTime.getNanosecond(), this, errorBranch);
            }
            JSTemporalDateTimeRecord result = TemporalUtil.toTemporalTimeRecord(item);
            Object resolvedOptions = getOptionsObjectNode.execute(options);
            TemporalUtil.Overflow overflow = TemporalUtil.getTemporalOverflowOption(resolvedOptions, getOptionNode);
            result2 = TemporalUtil.regulateTime(result.getHour(), result.getMinute(), result.getSecond(), result.getMillisecond(), result.getMicrosecond(), result.getNanosecond(), overflow);
        } else if (item instanceof TruffleString) {
            TruffleString string = (TruffleString)item;
            JSTemporalDateTimeRecord result = TemporalUtil.parseTemporalTimeString(string);
            Object resolvedOptions = getOptionsObjectNode.execute(options);
            TemporalUtil.getTemporalOverflowOption(resolvedOptions, getOptionNode);
            result2 = JSTemporalDurationRecord.create(result);
        } else {
            errorBranch.enter(this);
            throw Errors.createTypeErrorNotAString(item);
        }
        return JSTemporalPlainTime.create(ctx, realm, TemporalUtil.dtoi(result2.getHours()), TemporalUtil.dtoi(result2.getMinutes()), TemporalUtil.dtoi(result2.getSeconds()), TemporalUtil.dtoi(result2.getMilliseconds()), TemporalUtil.dtoi(result2.getMicroseconds()), TemporalUtil.dtoi(result2.getNanoseconds()), this, errorBranch);
    }
}

