/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.temporal;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Cached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.InlinedBranchProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.BigInt;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRealm;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDuration;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDurationObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalInstant;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalInstantObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDate;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDateObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDateTime;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDateTimeObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.Undefined;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.util.TemporalUtil;

public abstract class TemporalAddZonedDateTimeNode
extends JavaScriptBaseNode {
    protected TemporalAddZonedDateTimeNode() {
    }

    public final BigInt execute(BigInt epochNanoseconds, TruffleString timeZone, TruffleString calendar, double years, double months, double weeks, double days, BigInt norm, JSTemporalPlainDateTimeObject precalculatedPlainDateTime) {
        return this.execute(epochNanoseconds, timeZone, calendar, years, months, weeks, days, norm, precalculatedPlainDateTime, Undefined.instance);
    }

    public abstract BigInt execute(BigInt var1, TruffleString var2, TruffleString var3, double var4, double var6, double var8, double var10, BigInt var12, JSTemporalPlainDateTimeObject var13, JSDynamicObject var14);

    @Specialization
    protected BigInt addZonedDateTime(BigInt epochNanoseconds, TruffleString timeZone, TruffleString calendar, double years, double months, double weeks, double days, BigInt norm, JSTemporalPlainDateTimeObject precalculatedPlainDateTime, JSDynamicObject options, @Cached InlinedBranchProfile errorBranch) {
        JSContext ctx = this.getJSContext();
        JSRealm realm = this.getRealm();
        if (years == 0.0 && months == 0.0 && weeks == 0.0 && days == 0.0) {
            return TemporalUtil.addInstant(epochNanoseconds, norm);
        }
        JSTemporalInstantObject instant = JSTemporalInstant.create(ctx, realm, epochNanoseconds);
        JSTemporalPlainDateTimeObject temporalDateTime = precalculatedPlainDateTime != null ? precalculatedPlainDateTime : TemporalUtil.builtinTimeZoneGetPlainDateTimeFor(ctx, realm, timeZone, instant, calendar);
        TemporalUtil.Overflow overflow = TemporalUtil.toTemporalOverflow(options);
        if (years == 0.0 && months == 0.0 && weeks == 0.0) {
            BigInt intermediate = TemporalUtil.addDaysToZonedDateTime(ctx, realm, instant, temporalDateTime, timeZone, (int)days, overflow).epochNanoseconds();
            return TemporalUtil.addInstant(intermediate, norm);
        }
        JSTemporalPlainDateObject datePart = JSTemporalPlainDate.create(ctx, realm, temporalDateTime.getYear(), temporalDateTime.getMonth(), temporalDateTime.getDay(), calendar, this, errorBranch);
        JSTemporalDurationObject dateDuration = JSTemporalDuration.createTemporalDuration(ctx, realm, years, months, weeks, days, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, this, errorBranch);
        JSTemporalPlainDateObject addedDate = TemporalUtil.calendarDateAdd(ctx, realm, calendar, datePart, dateDuration, overflow, this, errorBranch);
        JSTemporalPlainDateTimeObject intermediateDateTime = JSTemporalPlainDateTime.create(ctx, realm, addedDate.getYear(), addedDate.getMonth(), addedDate.getDay(), temporalDateTime.getHour(), temporalDateTime.getMinute(), temporalDateTime.getSecond(), temporalDateTime.getMillisecond(), temporalDateTime.getMicrosecond(), temporalDateTime.getNanosecond(), calendar);
        BigInt intermediateNs = TemporalUtil.getEpochNanosecondsFor(ctx, realm, timeZone, intermediateDateTime, TemporalUtil.Disambiguation.COMPATIBLE);
        return TemporalUtil.addInstant(intermediateNs, norm);
    }
}

