/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.temporal;

import java.math.BigDecimal;
import java.math.MathContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Cached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.InlinedBranchProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.temporal.TemporalAddDateTimeNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.temporal.TemporalDifferenceDateNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.BigInt;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Errors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRealm;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.ISODateRecord;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.ISODateTimeRecord;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDateTimeRecord;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDurationObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDurationRecord;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDate;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDateObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDateTime;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDateTimeObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.NormalizedDurationRecord;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.TemporalDurationWithTotalRecord;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.TimeDurationRecord;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.util.TemporalUtil;

public abstract class RoundRelativeDurationNode
extends JavaScriptBaseNode {
    protected RoundRelativeDurationNode() {
    }

    public abstract TemporalDurationWithTotalRecord execute(NormalizedDurationRecord var1, BigInt var2, ISODateTimeRecord var3, TruffleString var4, TruffleString var5, TemporalUtil.Unit var6, int var7, TemporalUtil.Unit var8, TemporalUtil.RoundingMode var9);

    @Specialization
    protected final TemporalDurationWithTotalRecord roundRelativeDuration(NormalizedDurationRecord duration0, BigInt destEpochNs, ISODateTimeRecord dateTime, TruffleString calendar, TruffleString timeZone, TemporalUtil.Unit largestUnit0, int increment, TemporalUtil.Unit smallestUnit, TemporalUtil.RoundingMode roundingMode, @Cached TemporalAddDateTimeNode addDateTimeNode, @Cached TemporalDifferenceDateNode differenceDateNode, @Cached InlinedBranchProfile errorBranch) {
        int sign;
        NormalizedDurationRecord duration = duration0;
        TemporalUtil.Unit largestUnit = largestUnit0;
        boolean irregularLengthUnit = smallestUnit.isCalendarUnit();
        if (timeZone != null && smallestUnit == TemporalUtil.Unit.DAY) {
            irregularLengthUnit = true;
        }
        int n = sign = TemporalUtil.durationSign(duration.years(), duration.months(), duration.weeks(), duration.days(), TemporalUtil.normalizedTimeDurationSign(duration.normalizedTimeTotalNanoseconds()), 0.0, 0.0, 0.0, 0.0, 0.0) < 0 ? -1 : 1;
        DurationNudgeResultRecord nudgeResult = irregularLengthUnit ? this.nudgeToCalendarUnit(sign, duration, destEpochNs, dateTime, calendar, timeZone, increment, smallestUnit, roundingMode, addDateTimeNode, differenceDateNode, errorBranch) : (timeZone != null ? this.nudgeToZonedTime(sign, duration, dateTime, calendar, timeZone, increment, smallestUnit, roundingMode, addDateTimeNode, errorBranch) : RoundRelativeDurationNode.nudgeToDayOrTime(duration, destEpochNs, largestUnit, increment, smallestUnit, roundingMode));
        duration = nudgeResult.duration();
        if (nudgeResult.didExpandCalendarUnit() && smallestUnit != TemporalUtil.Unit.WEEK) {
            TemporalUtil.Unit startUnit = TemporalUtil.largerOfTwoTemporalUnits(smallestUnit, TemporalUtil.Unit.DAY);
            duration = this.bubbleRelativeDuration(sign, duration, nudgeResult.nudgedEpochNs(), dateTime, calendar, timeZone, largestUnit, startUnit, addDateTimeNode, errorBranch);
        }
        if (largestUnit.isCalendarUnit() || largestUnit == TemporalUtil.Unit.DAY) {
            largestUnit = TemporalUtil.Unit.HOUR;
        }
        TimeDurationRecord balanceResult = TemporalUtil.balanceTimeDuration(duration.normalizedTimeTotalNanoseconds(), largestUnit);
        return new TemporalDurationWithTotalRecord(JSTemporalDurationRecord.createWeeks(duration.years(), duration.months(), duration.weeks(), duration.days(), balanceResult.hours(), balanceResult.minutes(), balanceResult.seconds(), balanceResult.milliseconds(), balanceResult.microseconds(), balanceResult.nanoseconds()), nudgeResult.total());
    }

    private DurationNudgeResultRecord nudgeToCalendarUnit(int sign, NormalizedDurationRecord duration, BigInt destEpochNs, ISODateTimeRecord dateTime, TruffleString calendar, TruffleString timeZone, int increment, TemporalUtil.Unit unit, TemporalUtil.RoundingMode roundingMode, TemporalAddDateTimeNode addDateTimeNode, TemporalDifferenceDateNode differenceDateNode, InlinedBranchProfile errorBranch) {
        BigInt nudgedEpochNs;
        NormalizedDurationRecord resultDuration;
        boolean didExpandCalendarUnit;
        BigInt endEpochNs;
        BigInt startEpochNs;
        NormalizedDurationRecord startDuration;
        double r2;
        double r1;
        JSRealm realm = this.getRealm();
        JSContext ctx = this.getJSContext();
        NormalizedDurationRecord endDuration = switch (unit) {
            case TemporalUtil.Unit.YEAR -> {
                double years;
                r1 = years = TemporalUtil.roundNumberToIncrement(duration.years(), increment, TemporalUtil.RoundingMode.TRUNC);
                r2 = years + (double)(increment * sign);
                startDuration = TemporalUtil.createNormalizedDurationRecord(r1, 0.0, 0.0, 0.0, TemporalUtil.zeroTimeDuration());
                yield TemporalUtil.createNormalizedDurationRecord(r2, 0.0, 0.0, 0.0, TemporalUtil.zeroTimeDuration());
            }
            case TemporalUtil.Unit.MONTH -> {
                double months;
                r1 = months = TemporalUtil.roundNumberToIncrement(duration.months(), increment, TemporalUtil.RoundingMode.TRUNC);
                r2 = months + (double)(increment * sign);
                startDuration = TemporalUtil.createNormalizedDurationRecord(duration.years(), r1, 0.0, 0.0, TemporalUtil.zeroTimeDuration());
                yield TemporalUtil.createNormalizedDurationRecord(duration.years(), r2, 0.0, 0.0, TemporalUtil.zeroTimeDuration());
            }
            case TemporalUtil.Unit.WEEK -> {
                double weeks;
                ISODateRecord isoResult1 = TemporalUtil.balanceISODate((double)dateTime.year() + duration.years(), (double)dateTime.month() + duration.months(), (double)dateTime.day());
                ISODateRecord isoResult2 = TemporalUtil.balanceISODate((double)dateTime.year() + duration.years(), (double)dateTime.month() + duration.months(), (double)dateTime.day() + duration.days());
                JSTemporalPlainDateObject weeksStart = JSTemporalPlainDate.create(ctx, realm, isoResult1.year(), isoResult1.month(), isoResult1.day(), calendar, this, errorBranch);
                JSTemporalPlainDateObject weeksEnd = JSTemporalPlainDate.create(ctx, realm, isoResult2.year(), isoResult2.month(), isoResult2.day(), calendar, this, errorBranch);
                JSTemporalDurationObject untilResult = differenceDateNode.execute(calendar, weeksStart, weeksEnd, TemporalUtil.Unit.WEEK);
                r1 = weeks = TemporalUtil.roundNumberToIncrement(duration.weeks() + untilResult.getWeeks(), increment, TemporalUtil.RoundingMode.TRUNC);
                r2 = weeks + (double)(increment * sign);
                startDuration = TemporalUtil.createNormalizedDurationRecord(duration.years(), duration.months(), r1, 0.0, TemporalUtil.zeroTimeDuration());
                yield TemporalUtil.createNormalizedDurationRecord(duration.years(), duration.months(), r2, 0.0, TemporalUtil.zeroTimeDuration());
            }
            case TemporalUtil.Unit.DAY -> {
                double days;
                r1 = days = TemporalUtil.roundNumberToIncrement(duration.days(), increment, TemporalUtil.RoundingMode.TRUNC);
                r2 = days + (double)(increment * sign);
                startDuration = TemporalUtil.createNormalizedDurationRecord(duration.years(), duration.months(), duration.weeks(), r1, TemporalUtil.zeroTimeDuration());
                yield TemporalUtil.createNormalizedDurationRecord(duration.years(), duration.months(), duration.weeks(), r2, TemporalUtil.zeroTimeDuration());
            }
            default -> throw Errors.shouldNotReachHereUnexpectedValue((Object)unit);
        };
        JSTemporalDateTimeRecord start = addDateTimeNode.execute(dateTime.year(), dateTime.month(), dateTime.day(), dateTime.hour(), dateTime.minute(), dateTime.second(), dateTime.millisecond(), dateTime.microsecond(), dateTime.nanosecond(), calendar, startDuration.years(), startDuration.months(), startDuration.weeks(), startDuration.days(), startDuration.normalizedTimeTotalNanoseconds(), TemporalUtil.Overflow.CONSTRAIN);
        JSTemporalDateTimeRecord end = addDateTimeNode.execute(dateTime.year(), dateTime.month(), dateTime.day(), dateTime.hour(), dateTime.minute(), dateTime.second(), dateTime.millisecond(), dateTime.microsecond(), dateTime.nanosecond(), calendar, endDuration.years(), endDuration.months(), endDuration.weeks(), endDuration.days(), endDuration.normalizedTimeTotalNanoseconds(), TemporalUtil.Overflow.CONSTRAIN);
        if (timeZone == null) {
            startEpochNs = TemporalUtil.getUTCEpochNanoseconds(start.getYear(), start.getMonth(), start.getDay(), start.getHour(), start.getMinute(), start.getSecond(), start.getMillisecond(), start.getMicrosecond(), start.getNanosecond());
            endEpochNs = TemporalUtil.getUTCEpochNanoseconds(end.getYear(), end.getMonth(), end.getDay(), end.getHour(), end.getMinute(), end.getSecond(), end.getMillisecond(), end.getMicrosecond(), end.getNanosecond());
        } else {
            JSTemporalPlainDateTimeObject startDateTime = JSTemporalPlainDateTime.create(ctx, realm, start.getYear(), start.getMonth(), start.getDay(), start.getHour(), start.getMinute(), start.getSecond(), start.getMillisecond(), start.getMicrosecond(), start.getNanosecond(), calendar, this, errorBranch);
            startEpochNs = TemporalUtil.getEpochNanosecondsFor(ctx, realm, timeZone, startDateTime, TemporalUtil.Disambiguation.COMPATIBLE);
            JSTemporalPlainDateTimeObject endDateTime = JSTemporalPlainDateTime.create(ctx, realm, end.getYear(), end.getMonth(), end.getDay(), end.getHour(), end.getMinute(), end.getSecond(), end.getMillisecond(), end.getMicrosecond(), end.getNanosecond(), calendar, this, errorBranch);
            endEpochNs = TemporalUtil.getEpochNanosecondsFor(ctx, realm, timeZone, endDateTime, TemporalUtil.Disambiguation.COMPATIBLE);
        }
        if (startEpochNs.compareTo(endEpochNs) == 0) {
            throw Errors.createRangeError("custom calendar method returned an illegal result");
        }
        BigInt numerator = destEpochNs.subtract(startEpochNs);
        BigInt denominator = endEpochNs.subtract(startEpochNs);
        double total = RoundRelativeDurationNode.computeTotal(r1, numerator, denominator, increment, sign);
        boolean isNegative = sign < 0;
        TemporalUtil.UnsignedRoundingMode unsignedRoundingMode = TemporalUtil.getUnsignedRoundingMode(roundingMode, isNegative);
        double roundedUnit = numerator.equals(denominator) ? Math.abs(r2) : TemporalUtil.applyUnsignedRoundingMode(numerator.abs(), denominator.abs(), Math.abs(r1), Math.abs(r2), unsignedRoundingMode);
        if (roundedUnit == Math.abs(r2)) {
            didExpandCalendarUnit = true;
            resultDuration = endDuration;
            nudgedEpochNs = endEpochNs;
        } else {
            didExpandCalendarUnit = false;
            resultDuration = startDuration;
            nudgedEpochNs = startEpochNs;
        }
        return new DurationNudgeResultRecord(resultDuration, total, nudgedEpochNs, didExpandCalendarUnit);
    }

    @CompilerDirectives.TruffleBoundary
    private static double computeTotal(double r1, BigInt numerator, BigInt denominator, int increment, int sign) {
        BigDecimal progress = new BigDecimal(numerator.bigIntegerValue()).divide(new BigDecimal(denominator.bigIntegerValue()), MathContext.DECIMAL128);
        return new BigDecimal(r1).add(progress.multiply(new BigDecimal(increment * sign))).doubleValue();
    }

    private DurationNudgeResultRecord nudgeToZonedTime(int sign, NormalizedDurationRecord duration, ISODateTimeRecord dateTime, TruffleString calendar, TruffleString timeZone, int increment, TemporalUtil.Unit unit, TemporalUtil.RoundingMode roundingMode, TemporalAddDateTimeNode addDateTimeNode, InlinedBranchProfile errorBranch) {
        BigInt nudgedEpochNs;
        int dayDelta;
        boolean didRoundBeyondDay;
        JSRealm realm = this.getRealm();
        JSContext ctx = this.getJSContext();
        JSTemporalDateTimeRecord start = addDateTimeNode.execute(dateTime.year(), dateTime.month(), dateTime.day(), dateTime.hour(), dateTime.minute(), dateTime.second(), dateTime.millisecond(), dateTime.microsecond(), dateTime.nanosecond(), calendar, duration.years(), duration.months(), duration.weeks(), duration.days(), TemporalUtil.zeroTimeDuration(), TemporalUtil.Overflow.CONSTRAIN);
        JSTemporalPlainDateTimeObject startDateTime = JSTemporalPlainDateTime.create(ctx, realm, start.getYear(), start.getMonth(), start.getDay(), start.getHour(), start.getMinute(), start.getSecond(), start.getMillisecond(), start.getMicrosecond(), start.getNanosecond(), calendar, this, errorBranch);
        ISODateRecord endDate = TemporalUtil.balanceISODate(start.getYear(), start.getMonth(), start.getDay() + sign);
        JSTemporalPlainDateTimeObject endDateTime = JSTemporalPlainDateTime.create(ctx, realm, endDate.year(), endDate.month(), endDate.day(), start.getHour(), start.getMinute(), start.getSecond(), start.getMillisecond(), start.getMicrosecond(), start.getNanosecond(), calendar, this, errorBranch);
        BigInt startEpochNs = TemporalUtil.getEpochNanosecondsFor(ctx, realm, timeZone, startDateTime, TemporalUtil.Disambiguation.COMPATIBLE);
        BigInt endEpochNs = TemporalUtil.getEpochNanosecondsFor(ctx, realm, timeZone, endDateTime, TemporalUtil.Disambiguation.COMPATIBLE);
        BigInt daySpan = TemporalUtil.normalizedTimeDurationFromEpochNanosecondsDifference(endEpochNs, startEpochNs);
        assert (TemporalUtil.normalizedTimeDurationSign(daySpan) == sign);
        long unitLength = unit.getLengthInNanoseconds();
        BigInt roundedNorm = TemporalUtil.roundNormalizedTimeDurationToIncrement(duration.normalizedTimeTotalNanoseconds(), unitLength, increment, roundingMode);
        BigInt beyondDaySpan = TemporalUtil.subtractNormalizedTimeDuration(roundedNorm, daySpan);
        if (TemporalUtil.normalizedTimeDurationSign(beyondDaySpan) != -sign) {
            didRoundBeyondDay = true;
            dayDelta = sign;
            roundedNorm = TemporalUtil.roundNormalizedTimeDurationToIncrement(beyondDaySpan, unitLength, increment, roundingMode);
            nudgedEpochNs = TemporalUtil.addNormalizedTimeDurationToEpochNanoseconds(roundedNorm, endEpochNs);
        } else {
            didRoundBeyondDay = false;
            dayDelta = 0;
            nudgedEpochNs = TemporalUtil.addNormalizedTimeDurationToEpochNanoseconds(roundedNorm, startEpochNs);
        }
        NormalizedDurationRecord resultDuration = TemporalUtil.createNormalizedDurationRecord(duration.years(), duration.months(), duration.weeks(), duration.days() + (double)dayDelta, roundedNorm);
        return new DurationNudgeResultRecord(resultDuration, Double.NaN, nudgedEpochNs, didRoundBeyondDay);
    }

    private static DurationNudgeResultRecord nudgeToDayOrTime(NormalizedDurationRecord duration, BigInt destEpochNs, TemporalUtil.Unit largestUnit, int increment, TemporalUtil.Unit unit, TemporalUtil.RoundingMode roundingMode) {
        BigInt norm = TemporalUtil.add24HourDaysToNormalizedTimeDuration(duration.normalizedTimeTotalNanoseconds(), duration.days());
        long unitLength = unit.getLengthInNanoseconds();
        double total = TemporalUtil.divideNormalizedTimeDurationAsDouble(norm, unitLength);
        BigInt roundedNorm = TemporalUtil.roundNormalizedTimeDurationToIncrement(norm, unitLength, increment, roundingMode);
        BigInt diffNorm = TemporalUtil.subtractNormalizedTimeDuration(roundedNorm, norm);
        double wholeDays = TemporalUtil.divideNormalizedTimeDurationAsDoubleTruncate(norm, 86400000000000L);
        double roundedWholeDays = TemporalUtil.divideNormalizedTimeDurationAsDoubleTruncate(roundedNorm, 86400000000000L);
        double dayDelta = roundedWholeDays - wholeDays;
        int dayDeltaSign = Double.compare(dayDelta, 0.0);
        boolean didExpandDays = dayDeltaSign == TemporalUtil.normalizedTimeDurationSign(norm);
        BigInt nudgedEpochNs = TemporalUtil.addNormalizedTimeDurationToEpochNanoseconds(diffNorm, destEpochNs);
        double days = 0.0;
        BigInt remainder = roundedNorm;
        if (TemporalUtil.largerOfTwoTemporalUnits(largestUnit, TemporalUtil.Unit.DAY) == largestUnit) {
            days = roundedWholeDays;
            remainder = TemporalUtil.remainderNormalizedTimeDuration(roundedNorm, 86400000000000L);
        }
        NormalizedDurationRecord resultDuration = TemporalUtil.createNormalizedDurationRecord(duration.years(), duration.months(), duration.weeks(), days, remainder);
        return new DurationNudgeResultRecord(resultDuration, total, nudgedEpochNs, didExpandDays);
    }

    private NormalizedDurationRecord bubbleRelativeDuration(int sign, NormalizedDurationRecord duration0, BigInt nudgedEpochNs, ISODateTimeRecord dateTime, TruffleString calendar, TruffleString timeZone, TemporalUtil.Unit largestUnit, TemporalUtil.Unit smallestUnit, TemporalAddDateTimeNode addDateTimeNode, InlinedBranchProfile errorBranch) {
        assert (largestUnit.isDateUnit()) : largestUnit;
        assert (smallestUnit.isDateUnit()) : smallestUnit;
        NormalizedDurationRecord duration = duration0;
        if (smallestUnit == TemporalUtil.Unit.YEAR) {
            return duration;
        }
        JSRealm realm = this.getRealm();
        JSContext ctx = this.getJSContext();
        int largestUnitIndex = largestUnit.ordinal();
        int smallestUnitIndex = smallestUnit.ordinal();
        for (int unitIndex = smallestUnitIndex - 1; unitIndex >= largestUnitIndex; --unitIndex) {
            BigInt endEpochNs;
            TemporalUtil.Unit unit = TemporalUtil.Unit.VALUES[unitIndex];
            if (unit == TemporalUtil.Unit.WEEK && largestUnit != TemporalUtil.Unit.WEEK) continue;
            NormalizedDurationRecord endDuration = switch (unit) {
                case TemporalUtil.Unit.YEAR -> {
                    double years = duration.years() + (double)sign;
                    yield TemporalUtil.createNormalizedDurationRecord(years, 0.0, 0.0, 0.0, TemporalUtil.zeroTimeDuration());
                }
                case TemporalUtil.Unit.MONTH -> {
                    double months = duration.months() + (double)sign;
                    yield TemporalUtil.createNormalizedDurationRecord(duration.years(), months, 0.0, 0.0, TemporalUtil.zeroTimeDuration());
                }
                case TemporalUtil.Unit.WEEK -> {
                    double weeks = duration.weeks() + (double)sign;
                    yield TemporalUtil.createNormalizedDurationRecord(duration.years(), duration.months(), weeks, 0.0, TemporalUtil.zeroTimeDuration());
                }
                case TemporalUtil.Unit.DAY -> {
                    double days = duration.days() + (double)sign;
                    yield TemporalUtil.createNormalizedDurationRecord(duration.years(), duration.months(), duration.weeks(), days, TemporalUtil.zeroTimeDuration());
                }
                default -> throw Errors.shouldNotReachHereUnexpectedValue((Object)unit);
            };
            JSTemporalDateTimeRecord end = addDateTimeNode.execute(dateTime.year(), dateTime.month(), dateTime.day(), dateTime.hour(), dateTime.minute(), dateTime.second(), dateTime.millisecond(), dateTime.microsecond(), dateTime.nanosecond(), calendar, endDuration.years(), endDuration.months(), endDuration.weeks(), endDuration.days(), endDuration.normalizedTimeTotalNanoseconds(), TemporalUtil.Overflow.CONSTRAIN);
            if (timeZone == null) {
                endEpochNs = TemporalUtil.getUTCEpochNanoseconds(end.getYear(), end.getMonth(), end.getDay(), end.getHour(), end.getMinute(), end.getSecond(), end.getMillisecond(), end.getMicrosecond(), end.getNanosecond());
            } else {
                JSTemporalPlainDateTimeObject endDateTime = JSTemporalPlainDateTime.create(ctx, realm, end.getYear(), end.getMonth(), end.getDay(), end.getHour(), end.getMinute(), end.getSecond(), end.getMillisecond(), end.getMicrosecond(), end.getNanosecond(), calendar, this, errorBranch);
                endEpochNs = TemporalUtil.getEpochNanosecondsFor(ctx, realm, timeZone, endDateTime, TemporalUtil.Disambiguation.COMPATIBLE);
            }
            BigInt beyondEnd = nudgedEpochNs.subtract(endEpochNs);
            int beyondEndSign = beyondEnd.signum();
            if (beyondEndSign == -sign) break;
            duration = endDuration;
        }
        return duration;
    }

    public record DurationNudgeResultRecord(NormalizedDurationRecord duration, double total, BigInt nudgedEpochNs, boolean didExpandCalendarUnit) {
    }
}

