/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.intl;

import java.util.ArrayList;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Cached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.ImportStatic;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.InteropLibrary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.InvalidArrayIndexException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.UnsupportedMessageException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.library.CachedLibrary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.BranchProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.JSHasPropertyNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.array.JSGetLengthNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.cast.JSToObjectNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.cast.JSToStringNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.interop.ImportValueNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.intl.JSToCanonicalizedLocaleListNodeGen;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.unary.TypeOfNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Boundaries;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Errors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSConfig;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRuntime;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Strings;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.intl.JSLocale;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.intl.JSLocaleObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.util.IntlUtil;

@ImportStatic(value={JSConfig.class})
public abstract class JSToCanonicalizedLocaleListNode
extends JavaScriptBaseNode {
    final JSContext context;
    private final BranchProfile errorBranch = BranchProfile.create();

    protected JSToCanonicalizedLocaleListNode(JSContext context) {
        this.context = context;
    }

    public static JSToCanonicalizedLocaleListNode create(JSContext context) {
        return JSToCanonicalizedLocaleListNodeGen.create(context);
    }

    public abstract String[] executeLanguageTags(Object var1);

    @Specialization
    protected String[] doTString(TruffleString s) {
        return JSToCanonicalizedLocaleListNode.doJavaString(Strings.toJavaString(s));
    }

    @Specialization(guards={"isUndefined(object)"})
    protected String[] doUndefined(Object object) {
        return new String[0];
    }

    @Specialization
    protected String[] doLocale(JSLocaleObject object) {
        return JSToCanonicalizedLocaleListNode.doJavaString(object.getInternalState().getLocale());
    }

    @Specialization(guards={"!isForeignObject(object)", "!isString(object)", "!isUndefined(object)", "!isJSLocale(object)"})
    protected String[] doOtherType(Object object, @Cached JSToObjectNode toObjectNode, @Cached(value="create(context)") JSGetLengthNode getLengthNode, @Cached JSHasPropertyNode hasPropertyNode, @Cached @Cached.Shared TypeOfNode typeOfNode, @Cached @Cached.Shared JSToStringNode toStringNode, @Cached @Cached.Shared TruffleString.EqualNode equalsNode, @Cached @Cached.Shared TruffleString.ToJavaStringNode toJavaStringNode) {
        ArrayList<String> result = new ArrayList<String>();
        JSDynamicObject localeObj = (JSDynamicObject)toObjectNode.execute(object);
        long len = getLengthNode.executeLong(localeObj);
        for (long k = 0L; k < len; ++k) {
            if (!hasPropertyNode.executeBoolean((Object)localeObj, k)) continue;
            Object kValue = JSObject.get(localeObj, k);
            TruffleString typeOfKValue = typeOfNode.executeString(kValue);
            if (JSRuntime.isNullOrUndefined(kValue) || !Strings.equals(equalsNode, Strings.STRING, typeOfKValue) && !Strings.equals(equalsNode, Strings.OBJECT, typeOfKValue)) {
                this.errorBranch.enter();
                throw Errors.createTypeError(Boundaries.stringFormat("String or Object expected in locales list, got %s", typeOfKValue));
            }
            String lt = JSLocale.isJSLocale(kValue) ? ((JSLocaleObject)kValue).getInternalState().getLocale() : Strings.toJavaString(toJavaStringNode, toStringNode.executeString(kValue));
            String canonicalizedLt = IntlUtil.validateAndCanonicalizeLanguageTag(lt);
            if (Boundaries.listContains(result, canonicalizedLt)) continue;
            Boundaries.listAdd(result, canonicalizedLt);
        }
        return Boundaries.listToStringArray(result);
    }

    @Specialization(guards={"isForeignObject(object)"})
    protected String[] doForeignType(Object object, @CachedLibrary(limit="InteropLibraryLimit") InteropLibrary arrayInterop, @CachedLibrary(limit="InteropLibraryLimit") InteropLibrary valueInterop, @Cached ImportValueNode importValueNode, @Cached @Cached.Shared TypeOfNode typeOfNode, @Cached @Cached.Shared JSToStringNode toStringNode, @Cached @Cached.Shared TruffleString.EqualNode equalsNode, @Cached @Cached.Shared TruffleString.ToJavaStringNode toJavaStringNode) {
        long len;
        ArrayList<String> result = new ArrayList<String>();
        try {
            len = arrayInterop.getArraySize(object);
        }
        catch (UnsupportedMessageException e) {
            this.errorBranch.enter();
            throw Errors.createTypeErrorInteropException(object, e, "getArraySize", this);
        }
        for (long k = 0L; k < len; ++k) {
            String tag;
            if (!arrayInterop.isArrayElementReadable(object, k)) continue;
            try {
                Object foreignValue = arrayInterop.readArrayElement(object, k);
                if (valueInterop.isString(foreignValue)) {
                    tag = valueInterop.asString(foreignValue);
                } else {
                    Object kValue = importValueNode.executeWithTarget(foreignValue);
                    TruffleString typeOfKValue = typeOfNode.executeString(kValue);
                    if (!Strings.equals(equalsNode, Strings.STRING, typeOfKValue) && !Strings.equals(equalsNode, Strings.OBJECT, typeOfKValue)) {
                        this.errorBranch.enter();
                        throw Errors.createTypeError(Boundaries.stringFormat("String or Object expected in locales list, got %s", typeOfKValue));
                    }
                    tag = Strings.toJavaString(toJavaStringNode, toStringNode.executeString(kValue));
                }
            }
            catch (InvalidArrayIndexException | UnsupportedMessageException e) {
                this.errorBranch.enter();
                throw Errors.createTypeErrorInteropException(object, e, "readArrayElement", k, this);
            }
            String canonicalizedTag = IntlUtil.validateAndCanonicalizeLanguageTag(tag);
            if (Boundaries.listContains(result, canonicalizedTag)) continue;
            Boundaries.listAdd(result, canonicalizedTag);
        }
        return Boundaries.listToStringArray(result);
    }

    private static String[] doJavaString(String s) {
        return new String[]{IntlUtil.validateAndCanonicalizeLanguageTag(s)};
    }
}

