/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.intl;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.NeverDefault;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.BranchProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.intl.GetDurationUnitOptionsNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.intl.GetNumberOptionNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.intl.GetOptionsObjectNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.intl.GetOptionsObjectNodeGen;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.intl.GetStringOptionNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.intl.InitializeDurationFormatNodeGen;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.intl.JSToCanonicalizedLocaleListNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.intl.JSDurationFormat;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.intl.JSDurationFormatObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.util.IntlUtil;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.util.Pair;

public abstract class InitializeDurationFormatNode
extends JavaScriptBaseNode {
    @Node.Child
    JSToCanonicalizedLocaleListNode canonicalizedLocaleList;
    @Node.Child
    GetOptionsObjectNode getOptionsObject;
    @Node.Child
    GetStringOptionNode getLocaleMatcherOption;
    @Node.Child
    GetStringOptionNode getNumberingSystemOption;
    @Node.Child
    GetStringOptionNode getStyleOption;
    @Node.Child
    GetDurationUnitOptionsNode getYearsOptions;
    @Node.Child
    GetDurationUnitOptionsNode getMonthsOptions;
    @Node.Child
    GetDurationUnitOptionsNode getWeeksOptions;
    @Node.Child
    GetDurationUnitOptionsNode getDaysOptions;
    @Node.Child
    GetDurationUnitOptionsNode getHoursOptions;
    @Node.Child
    GetDurationUnitOptionsNode getMinutesOptions;
    @Node.Child
    GetDurationUnitOptionsNode getSecondsOptions;
    @Node.Child
    GetDurationUnitOptionsNode getMillisecondsOptions;
    @Node.Child
    GetDurationUnitOptionsNode getMicrosecondsOptions;
    @Node.Child
    GetDurationUnitOptionsNode getNanosecondsOptions;
    @Node.Child
    GetNumberOptionNode getFractionalDigitsOption;
    private final BranchProfile errorBranch = BranchProfile.create();

    protected InitializeDurationFormatNode(JSContext context) {
        this.canonicalizedLocaleList = JSToCanonicalizedLocaleListNode.create(context);
        this.getOptionsObject = GetOptionsObjectNodeGen.create(context);
        this.getLocaleMatcherOption = GetStringOptionNode.create(context, IntlUtil.KEY_LOCALE_MATCHER, GetStringOptionNode.LOCALE_MATCHER_OPTION_VALUES, "best fit");
        this.getNumberingSystemOption = GetStringOptionNode.create(context, IntlUtil.KEY_NUMBERING_SYSTEM, null, null);
        this.getStyleOption = GetStringOptionNode.create(context, IntlUtil.KEY_STYLE, GetStringOptionNode.LONG_SHORT_NARROW_DIGITAL_OPTION_VALUES, "short");
        this.getYearsOptions = GetDurationUnitOptionsNode.create(context, GetDurationUnitOptionsNode.Unit.YEARS, GetDurationUnitOptionsNode.LONG_SHORT_NARROW_STYLES, "short");
        this.getMonthsOptions = GetDurationUnitOptionsNode.create(context, GetDurationUnitOptionsNode.Unit.MONTHS, GetDurationUnitOptionsNode.LONG_SHORT_NARROW_STYLES, "short");
        this.getWeeksOptions = GetDurationUnitOptionsNode.create(context, GetDurationUnitOptionsNode.Unit.WEEKS, GetDurationUnitOptionsNode.LONG_SHORT_NARROW_STYLES, "short");
        this.getDaysOptions = GetDurationUnitOptionsNode.create(context, GetDurationUnitOptionsNode.Unit.DAYS, GetDurationUnitOptionsNode.LONG_SHORT_NARROW_STYLES, "short");
        this.getHoursOptions = GetDurationUnitOptionsNode.create(context, GetDurationUnitOptionsNode.Unit.HOURS, GetDurationUnitOptionsNode.LONG_SHORT_NARROW_NUMERIC_2DIGIT_STYLES, "numeric");
        this.getMinutesOptions = GetDurationUnitOptionsNode.create(context, GetDurationUnitOptionsNode.Unit.MINUTES, GetDurationUnitOptionsNode.LONG_SHORT_NARROW_NUMERIC_2DIGIT_STYLES, "numeric");
        this.getSecondsOptions = GetDurationUnitOptionsNode.create(context, GetDurationUnitOptionsNode.Unit.SECONDS, GetDurationUnitOptionsNode.LONG_SHORT_NARROW_NUMERIC_2DIGIT_STYLES, "numeric");
        this.getMillisecondsOptions = GetDurationUnitOptionsNode.create(context, GetDurationUnitOptionsNode.Unit.MILLISECONDS, GetDurationUnitOptionsNode.LONG_SHORT_NARROW_NUMERIC_STYLES, "numeric");
        this.getMicrosecondsOptions = GetDurationUnitOptionsNode.create(context, GetDurationUnitOptionsNode.Unit.MICROSECONDS, GetDurationUnitOptionsNode.LONG_SHORT_NARROW_NUMERIC_STYLES, "numeric");
        this.getNanosecondsOptions = GetDurationUnitOptionsNode.create(context, GetDurationUnitOptionsNode.Unit.NANOSECONDS, GetDurationUnitOptionsNode.LONG_SHORT_NARROW_NUMERIC_STYLES, "numeric");
        this.getFractionalDigitsOption = GetNumberOptionNode.create(context, IntlUtil.KEY_FRACTIONAL_DIGITS);
    }

    public abstract JSDurationFormatObject executeInit(JSDurationFormatObject var1, Object var2, Object var3);

    @NeverDefault
    public static InitializeDurationFormatNode create(JSContext context) {
        return InitializeDurationFormatNodeGen.create(context);
    }

    @Specialization
    public JSDurationFormatObject initialize(JSDurationFormatObject durationFormat, Object locales, Object optionsArg) {
        JSDurationFormat.InternalState state = durationFormat.getInternalState();
        String[] requestedLocales = this.canonicalizedLocaleList.executeLanguageTags(locales);
        Object options = this.getOptionsObject.execute(optionsArg);
        this.getLocaleMatcherOption.executeValue(options);
        String numberingSystem = this.getNumberingSystemOption.executeValue(options);
        if (numberingSystem != null) {
            IntlUtil.validateUnicodeLocaleIdentifierType(numberingSystem, this.errorBranch);
        }
        state.resolveLocaleAndNumberingSystem(this.getJSContext(), requestedLocales, numberingSystem);
        boolean twoDigitHours = false;
        String style = this.getStyleOption.executeValue(options);
        state.setStyle(style);
        Pair<String, String> unitOptions = this.getYearsOptions.executeOptions(options, style, "", twoDigitHours);
        state.setYearsOptions(unitOptions);
        unitOptions = this.getMonthsOptions.executeOptions(options, style, unitOptions.getFirst(), twoDigitHours);
        state.setMonthsOptions(unitOptions);
        unitOptions = this.getWeeksOptions.executeOptions(options, style, unitOptions.getFirst(), twoDigitHours);
        state.setWeeksOptions(unitOptions);
        unitOptions = this.getDaysOptions.executeOptions(options, style, unitOptions.getFirst(), twoDigitHours);
        state.setDaysOptions(unitOptions);
        unitOptions = this.getHoursOptions.executeOptions(options, style, unitOptions.getFirst(), twoDigitHours);
        state.setHoursOptions(unitOptions);
        unitOptions = this.getMinutesOptions.executeOptions(options, style, unitOptions.getFirst(), twoDigitHours);
        state.setMinutesOptions(unitOptions);
        unitOptions = this.getSecondsOptions.executeOptions(options, style, unitOptions.getFirst(), twoDigitHours);
        state.setSecondsOptions(unitOptions);
        unitOptions = this.getMillisecondsOptions.executeOptions(options, style, unitOptions.getFirst(), twoDigitHours);
        state.setMillisecondsOptions(unitOptions);
        unitOptions = this.getMicrosecondsOptions.executeOptions(options, style, unitOptions.getFirst(), twoDigitHours);
        state.setMicrosecondsOptions(unitOptions);
        unitOptions = this.getNanosecondsOptions.executeOptions(options, style, unitOptions.getFirst(), twoDigitHours);
        state.setNanosecondsOptions(unitOptions);
        int fractionalDigits = this.getFractionalDigitsOption.executeInt(options, 0, 9, -1);
        state.setFractionalDigits(fractionalDigits);
        return durationFormat;
    }
}

