/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.intl;

import java.util.List;
import java.util.MissingResourceException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.BranchProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.intl.GetOptionsObjectNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.intl.GetOptionsObjectNodeGen;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.intl.GetStringOptionNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.intl.InitializeDisplayNamesNodeGen;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.intl.JSToCanonicalizedLocaleListNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Errors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.intl.JSDisplayNames;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.intl.JSDisplayNamesObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.Undefined;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.util.IntlUtil;

public abstract class InitializeDisplayNamesNode
extends JavaScriptBaseNode {
    private static final List<String> TYPE_OPTION_VALUES = List.of("language", "region", "script", "currency", "calendar", "dateTimeField");
    private static final List<String> FALLBACK_OPTION_VALUES = List.of("code", "none");
    private static final List<String> LANGUAGE_DISPLAY_OPTION_VALUES = List.of("dialect", "standard");
    private final JSContext context;
    @Node.Child
    JSToCanonicalizedLocaleListNode toCanonicalizedLocaleListNode;
    @Node.Child
    GetOptionsObjectNode getOptionsObjectNode;
    @Node.Child
    GetStringOptionNode getLocaleMatcherOption;
    @Node.Child
    GetStringOptionNode getStyleOption;
    @Node.Child
    GetStringOptionNode getTypeOption;
    @Node.Child
    GetStringOptionNode getFallbackOption;
    @Node.Child
    GetStringOptionNode getLanguageDisplayOption;
    private final BranchProfile errorBranch = BranchProfile.create();

    protected InitializeDisplayNamesNode(JSContext context) {
        this.context = context;
        this.toCanonicalizedLocaleListNode = JSToCanonicalizedLocaleListNode.create(context);
        this.getOptionsObjectNode = GetOptionsObjectNodeGen.create(context);
        this.getLocaleMatcherOption = GetStringOptionNode.create(context, IntlUtil.KEY_LOCALE_MATCHER, GetStringOptionNode.LOCALE_MATCHER_OPTION_VALUES, "best fit");
        this.getStyleOption = GetStringOptionNode.create(context, IntlUtil.KEY_STYLE, GetStringOptionNode.NARROW_SHORT_LONG_OPTION_VALUES, "long");
        this.getTypeOption = GetStringOptionNode.create(context, IntlUtil.KEY_TYPE, TYPE_OPTION_VALUES, null);
        this.getFallbackOption = GetStringOptionNode.create(context, IntlUtil.KEY_FALLBACK, FALLBACK_OPTION_VALUES, "code");
        this.getLanguageDisplayOption = GetStringOptionNode.create(context, IntlUtil.KEY_LANGUAGE_DISPLAY, LANGUAGE_DISPLAY_OPTION_VALUES, "dialect");
    }

    public abstract JSDisplayNamesObject executeInit(JSDisplayNamesObject var1, Object var2, Object var3);

    public static InitializeDisplayNamesNode createInitalizeDisplayNamesNode(JSContext context) {
        return InitializeDisplayNamesNodeGen.create(context);
    }

    @Specialization
    public JSDisplayNamesObject initializeDisplayNames(JSDisplayNamesObject displayNamesObject, Object localesArg, Object optionsArg) {
        try {
            String[] locales = this.toCanonicalizedLocaleListNode.executeLanguageTags(localesArg);
            if (optionsArg == Undefined.instance) {
                this.errorBranch.enter();
                throw Errors.createTypeError("options not specified");
            }
            Object options = this.getOptionsObjectNode.execute(optionsArg);
            this.getLocaleMatcherOption.executeValue(options);
            String optStyle = this.getStyleOption.executeValue(options);
            String optType = this.getTypeOption.executeValue(options);
            if (optType == null) {
                this.errorBranch.enter();
                throw Errors.createTypeError("'type' option not specified");
            }
            String optFallback = this.getFallbackOption.executeValue(options);
            String optLanguageDisplay = this.getLanguageDisplayOption.executeValue(options);
            JSDisplayNames.InternalState state = displayNamesObject.getInternalState();
            JSDisplayNames.setupInternalState(this.context, state, locales, optStyle, optType, optFallback, optLanguageDisplay);
        }
        catch (MissingResourceException e) {
            this.errorBranch.enter();
            throw Errors.createICU4JDataError(e);
        }
        return displayNamesObject;
    }
}

