/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.intl;

import java.util.List;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.BranchProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.intl.GetDurationUnitOptionsNodeGen;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.intl.GetStringOptionNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Errors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.util.IntlUtil;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.util.Pair;

public abstract class GetDurationUnitOptionsNode
extends JavaScriptBaseNode {
    public static final List<String> LONG_SHORT_NARROW_STYLES = List.of("long", "short", "narrow");
    public static final List<String> LONG_SHORT_NARROW_NUMERIC_STYLES = List.of("long", "short", "narrow", "numeric");
    public static final List<String> LONG_SHORT_NARROW_NUMERIC_2DIGIT_STYLES = List.of("long", "short", "narrow", "numeric", "2-digit");
    private final Unit unit;
    private final String digitalBase;
    @Node.Child
    GetStringOptionNode getStyleOption;
    @Node.Child
    GetStringOptionNode getDisplayOption;
    private final BranchProfile errorBranch = BranchProfile.create();

    protected GetDurationUnitOptionsNode(JSContext context, Unit unit, List<String> styleList, String digitalBase) {
        this.unit = unit;
        this.digitalBase = digitalBase;
        this.getStyleOption = GetStringOptionNode.create(context, unit.styleKey, styleList, null);
        this.getDisplayOption = GetStringOptionNode.create(context, unit.displayKey, GetStringOptionNode.AUTO_ALWAYS_OPTION_VALUES, null);
    }

    public static GetDurationUnitOptionsNode create(JSContext context, Unit unit, List<String> styleList, String digitalBase) {
        return GetDurationUnitOptionsNodeGen.create(context, unit, styleList, digitalBase);
    }

    public abstract Pair<String, String> executeOptions(Object var1, String var2, String var3, boolean var4);

    @Specialization
    public Pair<String, String> getOptions(Object options, String baseStyle, String prevStyle, boolean twoDigitHours) {
        String display;
        String style = this.getStyleOption.executeValue(options);
        String displayDefault = "always";
        if (style == null) {
            if ("digital".equals(baseStyle)) {
                if (this.unit != Unit.HOURS && this.unit != Unit.MINUTES && this.unit != Unit.SECONDS) {
                    displayDefault = "auto";
                }
                style = this.digitalBase;
            } else if ("fractional".equals(prevStyle) || "numeric".equals(prevStyle) || "2-digit".equals(prevStyle)) {
                if (this.unit != Unit.MINUTES && this.unit != Unit.SECONDS) {
                    displayDefault = "auto";
                }
                style = "numeric";
            } else {
                displayDefault = "auto";
                style = baseStyle;
            }
        }
        if ("numeric".equals(style) && (this.unit == Unit.MILLISECONDS || this.unit == Unit.MICROSECONDS || this.unit == Unit.NANOSECONDS)) {
            style = "fractional";
            displayDefault = "auto";
        }
        if ((display = this.getDisplayOption.executeValue(options)) == null) {
            display = displayDefault;
        }
        if ("always".equals(display) && "fractional".equals(style)) {
            this.errorBranch.enter();
            throw Errors.createRangeErrorInvalidOptions(this);
        }
        if ("fractional".equals(prevStyle)) {
            if (!"fractional".equals(style)) {
                this.errorBranch.enter();
                throw Errors.createRangeErrorInvalidOptions(this);
            }
        } else if ("numeric".equals(prevStyle) || "2-digit".equals(prevStyle)) {
            if (!("fractional".equals(style) || "numeric".equals(style) || "2-digit".equals(style))) {
                this.errorBranch.enter();
                throw Errors.createRangeErrorInvalidOptions(this);
            }
            if (this.unit == Unit.MINUTES || this.unit == Unit.SECONDS) {
                style = "2-digit";
            }
        }
        if (this.unit == Unit.HOURS && twoDigitHours) {
            style = "2-digit";
        }
        return new Pair<String, String>(style, display);
    }

    public static enum Unit {
        YEARS(IntlUtil.KEY_YEARS, IntlUtil.KEY_YEARS_DISPLAY),
        MONTHS(IntlUtil.KEY_MONTHS, IntlUtil.KEY_MONTHS_DISPLAY),
        WEEKS(IntlUtil.KEY_WEEKS, IntlUtil.KEY_WEEKS_DISPLAY),
        DAYS(IntlUtil.KEY_DAYS, IntlUtil.KEY_DAYS_DISPLAY),
        HOURS(IntlUtil.KEY_HOURS, IntlUtil.KEY_HOURS_DISPLAY),
        MINUTES(IntlUtil.KEY_MINUTES, IntlUtil.KEY_MINUTES_DISPLAY),
        SECONDS(IntlUtil.KEY_SECONDS, IntlUtil.KEY_SECONDS_DISPLAY),
        MILLISECONDS(IntlUtil.KEY_MILLISECONDS, IntlUtil.KEY_MILLISECONDS_DISPLAY),
        MICROSECONDS(IntlUtil.KEY_MICROSECONDS, IntlUtil.KEY_MICROSECONDS_DISPLAY),
        NANOSECONDS(IntlUtil.KEY_NANOSECONDS, IntlUtil.KEY_NANOSECONDS_DISPLAY);

        final TruffleString styleKey;
        final TruffleString displayKey;

        private Unit(TruffleString styleKey, TruffleString displayKey) {
            this.styleKey = styleKey;
            this.displayKey = displayKey;
        }
    }
}

