/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.function;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Fallback;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.ImportStatic;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.NeverDefault;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.function.SetFunctionNameNodeGen;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRuntime;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Strings;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Symbol;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSFunction;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSFunctionObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.PropertyDescriptor;

@ImportStatic(value={Strings.class})
public abstract class SetFunctionNameNode
extends JavaScriptBaseNode {
    protected SetFunctionNameNode() {
    }

    @NeverDefault
    public static SetFunctionNameNode create() {
        return SetFunctionNameNodeGen.create();
    }

    public final void execute(Object callable, Object propertyKey) {
        this.execute(callable, propertyKey, null);
    }

    public abstract void execute(Object var1, Object var2, TruffleString var3);

    @Specialization(guards={"prefix == null || isEmpty(prefix)"})
    protected static void doJSFunctionNoPrefix(JSFunctionObject function, TruffleString propertyKey, TruffleString prefix) {
        SetFunctionNameNode.setFunctionName(function, propertyKey);
    }

    @Specialization(guards={"prefix == null || isEmpty(prefix)"})
    protected static void doJSFunctionNoPrefix(JSFunctionObject function, Symbol propertyKey, TruffleString prefix) {
        SetFunctionNameNode.doJSFunctionNoPrefix(function, propertyKey.toFunctionNameString(), prefix);
    }

    @Specialization(guards={"prefix != null", "!isEmpty(prefix)"})
    protected static void doJSFunctionWithPrefix(JSFunctionObject function, TruffleString propertyKey, TruffleString prefix) {
        SetFunctionNameNode.setFunctionName(function, SetFunctionNameNode.concatenate(prefix, propertyKey));
    }

    @Specialization(guards={"prefix != null", "!isEmpty(prefix)"})
    protected static void doJSFunctionWithPrefix(JSFunctionObject function, Symbol propertyKey, TruffleString prefix) {
        SetFunctionNameNode.doJSFunctionWithPrefix(function, propertyKey.toFunctionNameString(), prefix);
    }

    @Fallback
    protected static void doUnsupported(Object function, Object propertyKey, TruffleString prefix) {
        assert (JSRuntime.isPropertyKey(propertyKey)) : propertyKey;
    }

    @CompilerDirectives.TruffleBoundary
    private static TruffleString concatenate(TruffleString prefix, TruffleString name) {
        return Strings.concatAll(prefix, Strings.SPACE, name);
    }

    private static void setFunctionName(JSFunctionObject functionValue, TruffleString name) {
        PropertyDescriptor propDesc = PropertyDescriptor.createData(name, false, false, true);
        JSRuntime.definePropertyOrThrow(functionValue, JSFunction.NAME, propDesc);
    }
}

