/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.control;

import java.util.Set;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.Truffle;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.frame.VirtualFrame;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.instrumentation.InstrumentableNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.instrumentation.Tag;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.LoopNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.NodeInfo;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.RepeatingNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JavaScriptNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.IteratorCompleteNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.IteratorValueNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.JSWriteFrameSlotNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.control.AbstractRepeatingNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.control.DiscardResultNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.control.ResumableNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.control.StatementNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.control.YieldException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.instrumentation.JSTags;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.Undefined;

@NodeInfo(shortName="while")
public final class WhileNode
extends StatementNode {
    @Node.Child
    private LoopNode loop;
    private final JSTags.ControlFlowRootTag.Type loopType;

    private WhileNode(RepeatingNode repeatingNode, JSTags.ControlFlowRootTag.Type type) {
        this(Truffle.getRuntime().createLoopNode(repeatingNode), type);
    }

    private WhileNode(LoopNode loopNode, JSTags.ControlFlowRootTag.Type type) {
        this.loop = loopNode;
        this.loopType = type;
    }

    private static JavaScriptNode createWhileDo(LoopNode loopNode, JSTags.ControlFlowRootTag.Type type) {
        return new WhileNode(loopNode, type);
    }

    public static RepeatingNode createWhileDoRepeatingNode(JavaScriptNode condition, JavaScriptNode body) {
        JavaScriptNode nonVoidBody = body instanceof DiscardResultNode ? ((DiscardResultNode)body).getOperand() : body;
        return new WhileDoRepeatingNode(condition, nonVoidBody);
    }

    public static JavaScriptNode createWhileDo(LoopNode loopNode) {
        return WhileNode.createWhileDo(loopNode, JSTags.ControlFlowRootTag.Type.WhileIteration);
    }

    public static JavaScriptNode createDesugaredFor(LoopNode loopNode) {
        return WhileNode.createWhileDo(loopNode, JSTags.ControlFlowRootTag.Type.ForIteration);
    }

    public static JavaScriptNode createDesugaredForOf(LoopNode loopNode) {
        return WhileNode.createWhileDo(loopNode, JSTags.ControlFlowRootTag.Type.ForOfIteration);
    }

    public static JavaScriptNode createDesugaredForIn(LoopNode loopNode) {
        return WhileNode.createWhileDo(loopNode, JSTags.ControlFlowRootTag.Type.ForInIteration);
    }

    public static JavaScriptNode createDesugaredForAwaitOf(LoopNode loopNode) {
        return WhileNode.createWhileDo(loopNode, JSTags.ControlFlowRootTag.Type.ForAwaitOfIteration);
    }

    public static RepeatingNode createDoWhileRepeatingNode(JavaScriptNode condition, JavaScriptNode body) {
        JavaScriptNode nonVoidBody = body instanceof DiscardResultNode ? ((DiscardResultNode)body).getOperand() : body;
        return new DoWhileRepeatingNode(condition, nonVoidBody);
    }

    public static JavaScriptNode createDoWhile(LoopNode loopNode) {
        return new WhileNode(loopNode, JSTags.ControlFlowRootTag.Type.DoWhileIteration);
    }

    public static RepeatingNode createForOfRepeatingNode(JavaScriptNode nextResultNode, JavaScriptNode body, JSWriteFrameSlotNode writeNextValueNode) {
        JavaScriptNode nonVoidBody = body instanceof DiscardResultNode ? ((DiscardResultNode)body).getOperand() : body;
        return new ForOfRepeatingNode(nextResultNode, nonVoidBody, writeNextValueNode);
    }

    @Override
    public boolean hasTag(Class<? extends Tag> tag) {
        if (tag == JSTags.ControlFlowRootTag.class) {
            return true;
        }
        return super.hasTag(tag);
    }

    @Override
    public Object getNodeObject() {
        return JSTags.createNodeObjectDescriptor("type", this.loopType.name());
    }

    @Override
    public InstrumentableNode materializeInstrumentableNodes(Set<Class<? extends Tag>> materializedTags) {
        AbstractRepeatingNode repeatingNode;
        RepeatingNode repeatingNode2;
        if (WhileNode.hasMaterializationTag(materializedTags) && (repeatingNode2 = this.loop.getRepeatingNode()) instanceof AbstractRepeatingNode && (repeatingNode = (AbstractRepeatingNode)repeatingNode2).materializationNeeded()) {
            InstrumentableNode materializedLoop = repeatingNode.materializeInstrumentableNodes((Set)materializedTags);
            WhileNode.transferSourceSectionAndTags(this, ((AbstractRepeatingNode)materializedLoop).bodyNode);
            WhileNode materialized = new WhileNode((RepeatingNode)((Object)materializedLoop), this.loopType);
            WhileNode.transferSourceSectionAndTags(this, materialized);
            return materialized;
        }
        return this;
    }

    private static boolean hasMaterializationTag(Set<Class<? extends Tag>> materializedTags) {
        return materializedTags.contains(JSTags.ControlFlowRootTag.class) || materializedTags.contains(JSTags.ControlFlowBlockTag.class) || materializedTags.contains(JSTags.ControlFlowBranchTag.class);
    }

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return new WhileNode((RepeatingNode)((Object)WhileNode.cloneUninitialized((JavaScriptNode)((Object)this.loop.getRepeatingNode()), materializedTags)), this.loopType);
    }

    @Override
    public Object execute(VirtualFrame frame) {
        this.loop.execute(frame);
        return EMPTY;
    }

    @Override
    public void executeVoid(VirtualFrame frame) {
        this.loop.execute(frame);
    }

    @Override
    public boolean isResultAlwaysOfType(Class<?> clazz) {
        assert (EMPTY == Undefined.instance);
        return clazz == Undefined.class;
    }

    public LoopNode getLoopNode() {
        return this.loop;
    }

    private static final class WhileDoRepeatingNode
    extends AbstractRepeatingNode
    implements ResumableNode.WithIntState {
        WhileDoRepeatingNode(JavaScriptNode condition, JavaScriptNode body) {
            super(condition, body);
        }

        @Override
        public boolean executeRepeating(VirtualFrame frame) {
            if (this.executeCondition(frame)) {
                this.executeBody(frame);
                return true;
            }
            return false;
        }

        @Override
        public Object resume(VirtualFrame frame, int stateSlot) {
            int index = this.getStateAsIntAndReset(frame, stateSlot);
            if (index != 0 || this.executeCondition(frame)) {
                try {
                    this.executeBody(frame);
                }
                catch (YieldException e) {
                    this.setStateAsInt(frame, stateSlot, 1);
                    throw e;
                }
                return true;
            }
            return false;
        }

        @Override
        protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
            return new WhileDoRepeatingNode(WhileDoRepeatingNode.cloneUninitialized(this.conditionNode, materializedTags), WhileDoRepeatingNode.cloneUninitialized(this.bodyNode, materializedTags));
        }

        @Override
        public AbstractRepeatingNode materializeInstrumentableNodes(Set<Class<? extends Tag>> materializedTags) {
            if (!this.materializationNeeded()) {
                return this;
            }
            return new WhileDoRepeatingNode(this.materializeCondition(materializedTags), this.materializeBody(materializedTags));
        }
    }

    private static final class DoWhileRepeatingNode
    extends AbstractRepeatingNode
    implements ResumableNode.WithIntState {
        DoWhileRepeatingNode(JavaScriptNode condition, JavaScriptNode body) {
            super(condition, body);
        }

        @Override
        public boolean executeRepeating(VirtualFrame frame) {
            this.executeBody(frame);
            return this.executeCondition(frame);
        }

        @Override
        public Object resume(VirtualFrame frame, int stateSlot) {
            int index = this.getStateAsIntAndReset(frame, stateSlot);
            if (index == 0) {
                this.executeBody(frame);
            }
            try {
                return this.executeCondition(frame);
            }
            catch (YieldException e) {
                this.setStateAsInt(frame, stateSlot, 1);
                throw e;
            }
        }

        @Override
        protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
            return new DoWhileRepeatingNode(DoWhileRepeatingNode.cloneUninitialized(this.conditionNode, materializedTags), DoWhileRepeatingNode.cloneUninitialized(this.bodyNode, materializedTags));
        }

        @Override
        public AbstractRepeatingNode materializeInstrumentableNodes(Set<Class<? extends Tag>> materializedTags) {
            if (!this.materializationNeeded()) {
                return this;
            }
            return new DoWhileRepeatingNode(this.materializeCondition(materializedTags), this.materializeBody(materializedTags));
        }
    }

    static final class ForOfRepeatingNode
    extends AbstractRepeatingNode
    implements ResumableNode.WithIntState {
        @Node.Child
        JavaScriptNode nextResultNode;
        @Node.Child
        JSWriteFrameSlotNode writeNextValueNode;
        @Node.Child
        IteratorCompleteNode iteratorCompleteNode = IteratorCompleteNode.create();
        @Node.Child
        IteratorValueNode iteratorValueNode = IteratorValueNode.create();

        ForOfRepeatingNode(JavaScriptNode nextResultNode, JavaScriptNode body, JSWriteFrameSlotNode writeNextValueNode) {
            super(null, body);
            this.nextResultNode = nextResultNode;
            this.writeNextValueNode = writeNextValueNode;
        }

        private Object executeNextResult(VirtualFrame frame) {
            return this.nextResultNode.execute(frame);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean executeRepeating(VirtualFrame frame) {
            Object nextResult = this.executeNextResult(frame);
            boolean done = this.iteratorCompleteNode.execute(nextResult);
            Object nextValue = this.iteratorValueNode.execute(nextResult);
            if (done) {
                return false;
            }
            this.writeNextValueNode.executeWrite(frame, nextValue);
            try {
                this.executeBody(frame);
            }
            finally {
                this.writeNextValueNode.executeWrite(frame, Undefined.instance);
            }
            return true;
        }

        @Override
        public Object resume(VirtualFrame frame, int stateSlot) {
            int state = this.getStateAsIntAndReset(frame, stateSlot);
            if (state == 0) {
                Object nextResult = this.executeNextResult(frame);
                boolean done = this.iteratorCompleteNode.execute(nextResult);
                Object nextValue = this.iteratorValueNode.execute(nextResult);
                if (done) {
                    return false;
                }
                this.writeNextValueNode.executeWrite(frame, nextValue);
            }
            try {
                this.executeBody(frame);
            }
            catch (YieldException e) {
                this.setStateAsInt(frame, stateSlot, 1);
                throw e;
            }
            finally {
                this.writeNextValueNode.executeWrite(frame, Undefined.instance);
            }
            return true;
        }

        @Override
        protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
            return new ForOfRepeatingNode(ForOfRepeatingNode.cloneUninitialized(this.nextResultNode, materializedTags), ForOfRepeatingNode.cloneUninitialized(this.bodyNode, materializedTags), ForOfRepeatingNode.cloneUninitialized(this.writeNextValueNode, materializedTags));
        }

        @Override
        public AbstractRepeatingNode materializeInstrumentableNodes(Set<Class<? extends Tag>> materializedTags) {
            if (!this.materializationNeeded()) {
                return this;
            }
            return new ForOfRepeatingNode(ForOfRepeatingNode.cloneUninitialized(this.nextResultNode, materializedTags), this.materializeBody(materializedTags), ForOfRepeatingNode.cloneUninitialized(this.writeNextValueNode, materializedTags));
        }
    }
}

