/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.control;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.frame.FrameSlotKind;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.frame.VirtualFrame;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JavaScriptNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.control.GeneratorNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.control.GeneratorWrapperNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.control.SuspendNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.Undefined;

public interface ResumableNode {
    default public Object resume(VirtualFrame frame, int stateSlot) {
        throw CompilerDirectives.shouldNotReachHere();
    }

    default public JavaScriptNode asResumableNode(int stateSlot) {
        return GeneratorWrapperNode.createWrapper((JavaScriptNode)((Object)this), stateSlot);
    }

    public static JavaScriptNode createResumableNode(ResumableNode node, int stateSlot) {
        if (!1.$assertionsDisabled && (node instanceof SuspendNode || node instanceof GeneratorNode)) {
            throw new AssertionError(node);
        }
        JavaScriptNode generatorNode = node.asResumableNode(stateSlot);
        if (!1.$assertionsDisabled && !(generatorNode instanceof GeneratorNode)) {
            throw new AssertionError(generatorNode);
        }
        JavaScriptNode.transferSourceSectionAndTags((JavaScriptNode)((Object)node), generatorNode);
        return generatorNode;
    }

    default public void resetState(VirtualFrame frame, int stateSlot) {
        frame.setObject(stateSlot, Undefined.instance);
    }

    default public FrameSlotKind getStateSlotKind() {
        return FrameSlotKind.Illegal;
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }

    public static interface WithIntState
    extends ResumableNode {
        default public void setStateAsInt(VirtualFrame frame, int stateSlot, int state) {
            if (!1.$assertionsDisabled && frame.getFrameDescriptor().getSlotKind(stateSlot) != FrameSlotKind.Int) {
                throw new AssertionError();
            }
            frame.setInt(stateSlot, state);
        }

        default public int getStateAsInt(VirtualFrame frame, int stateSlot) {
            if (!1.$assertionsDisabled && frame.getFrameDescriptor().getSlotKind(stateSlot) != FrameSlotKind.Int) {
                throw new AssertionError();
            }
            if (frame.isInt(stateSlot)) {
                return frame.getInt(stateSlot);
            }
            if (!(1.$assertionsDisabled || frame.isObject(stateSlot) && frame.getObject(stateSlot) == Undefined.instance)) {
                throw new AssertionError();
            }
            return 0;
        }

        default public int getStateAsIntAndReset(VirtualFrame frame, int stateSlot) {
            int state = this.getStateAsInt(frame, stateSlot);
            this.resetState(frame, stateSlot);
            return state;
        }

        @Override
        default public FrameSlotKind getStateSlotKind() {
            return FrameSlotKind.Int;
        }
    }

    public static interface WithObjectState
    extends ResumableNode {
        default public void setState(VirtualFrame frame, int stateSlot, Object state) {
            if (!1.$assertionsDisabled && frame.getFrameDescriptor().getSlotKind(stateSlot) != FrameSlotKind.Object) {
                throw new AssertionError();
            }
            frame.setObject(stateSlot, state);
        }

        default public Object getState(VirtualFrame frame, int stateSlot) {
            if (!1.$assertionsDisabled && frame.getFrameDescriptor().getSlotKind(stateSlot) != FrameSlotKind.Object) {
                throw new AssertionError();
            }
            return frame.getObject(stateSlot);
        }

        default public Object getStateAndReset(VirtualFrame frame, int stateSlot) {
            Object state = this.getState(frame, stateSlot);
            this.resetState(frame, stateSlot);
            return state;
        }

        @Override
        default public FrameSlotKind getStateSlotKind() {
            return FrameSlotKind.Object;
        }
    }
}

