/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.control;

import java.util.ArrayDeque;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.control.AsyncGeneratorResumeNextNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSArguments;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSAsyncGeneratorObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.AsyncGeneratorRequest;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.PromiseCapabilityRecord;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.Undefined;

public class AsyncGeneratorRejectNode
extends JavaScriptBaseNode {
    @Node.Child
    private JSFunctionCallNode callRejectNode = JSFunctionCallNode.createCall();
    @Node.Child
    private AsyncGeneratorResumeNextNode asyncGeneratorResumeNextNode;

    protected AsyncGeneratorRejectNode() {
    }

    public static AsyncGeneratorRejectNode create() {
        return new AsyncGeneratorRejectNode();
    }

    public Object execute(JSAsyncGeneratorObject generator, Object exception) {
        this.performReject(generator, exception);
        if (this.asyncGeneratorResumeNextNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.asyncGeneratorResumeNextNode = this.insert(AsyncGeneratorResumeNextNode.create(this.getLanguage().getJSContext()));
        }
        this.asyncGeneratorResumeNextNode.execute(generator);
        return Undefined.instance;
    }

    public void performReject(JSAsyncGeneratorObject generator, Object exception) {
        ArrayDeque<AsyncGeneratorRequest> queue = generator.getAsyncGeneratorQueue();
        assert (!queue.isEmpty());
        AsyncGeneratorRequest next = queue.pollFirst();
        PromiseCapabilityRecord promiseCapability = next.getPromiseCapability();
        Object reject = promiseCapability.getReject();
        this.callRejectNode.executeCall(JSArguments.createOneArg(Undefined.instance, reject, exception));
    }
}

