/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.cast;

import java.util.Set;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Cached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.instrumentation.Tag;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JavaScriptNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.cast.JSToObjectNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.cast.WithStatementToObjectNodeGen;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.unary.JSUnaryNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Errors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRuntime;

public abstract class WithStatementToObjectNode
extends JSUnaryNode {
    protected WithStatementToObjectNode(JavaScriptNode operand) {
        super(operand);
    }

    public static JavaScriptNode create(JavaScriptNode child) {
        return WithStatementToObjectNodeGen.create(child);
    }

    @Specialization
    protected Object doDefault(Object value, @Cached JSToObjectNode toObjectNode) {
        Object result;
        assert (this.getLanguage().getJSContext().isOptionNashornCompatibilityMode());
        try {
            result = toObjectNode.execute(value);
        }
        catch (JSException ex) {
            throw this.createTypeErrorNotObjectCoercible(value);
        }
        if (this.getRealm().getEnv().isHostObject(value)) {
            throw Errors.createTypeError("Cannot apply \"with\" to non script object. Consider using \"with(Object.bindProperties({}, nonScriptObject))\".", (Node)this);
        }
        return result;
    }

    @CompilerDirectives.TruffleBoundary
    private JSException createTypeErrorNotObjectCoercible(Object value) {
        return Errors.createTypeError("Cannot apply \"with\" to " + String.valueOf(JSRuntime.safeToString(value)), (Node)this);
    }

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return WithStatementToObjectNode.create(WithStatementToObjectNode.cloneUninitialized(this.getOperand(), materializedTags));
    }
}

