/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.cast;

import java.util.Set;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.HostCompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Cached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.NeverDefault;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.instrumentation.Tag;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JavaScriptNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.cast.JSDoubleToStringNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.cast.JSToPrimitiveNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.cast.JSToStringNodeGen;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.unary.JSUnaryNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.BigInt;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Errors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRuntime;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Strings;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Symbol;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.Null;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.Undefined;

public abstract class JSToStringNode
extends JavaScriptBaseNode {
    private final boolean undefinedToEmpty;
    private final boolean symbolToString;

    protected JSToStringNode() {
        this(false, false);
    }

    protected JSToStringNode(boolean undefinedToEmpty, boolean symbolToString) {
        this.undefinedToEmpty = undefinedToEmpty;
        this.symbolToString = symbolToString;
    }

    @NeverDefault
    public static JSToStringNode create() {
        return JSToStringNodeGen.create(false, false);
    }

    @NeverDefault
    public static JSToStringNode createUndefinedToEmpty() {
        return JSToStringNodeGen.create(true, false);
    }

    @NeverDefault
    public static JSToStringNode createSymbolToString() {
        return JSToStringNodeGen.create(false, true);
    }

    public abstract TruffleString executeString(Object var1);

    @Specialization
    protected TruffleString doString(TruffleString value) {
        return value;
    }

    @Specialization(guards={"isJSNull(value)"})
    protected TruffleString doNull(Object value) {
        return Null.NAME;
    }

    @Specialization(guards={"isUndefined(value)"})
    protected TruffleString doUndefined(Object value) {
        return this.undefinedToEmpty ? Strings.EMPTY_STRING : Undefined.NAME;
    }

    @Specialization
    protected TruffleString doBoolean(boolean value) {
        return JSRuntime.booleanToString(value);
    }

    @HostCompilerDirectives.InliningCutoff
    @Specialization
    protected TruffleString doInteger(int value, @Cached.Shared @Cached JSDoubleToStringNode doubleToStringNode) {
        return doubleToStringNode.executeString(value);
    }

    @Specialization
    protected TruffleString doBigInt(BigInt value) {
        return Strings.fromBigInt(value);
    }

    @HostCompilerDirectives.InliningCutoff
    @Specialization
    protected TruffleString doLong(long value, @Cached.Shared @Cached JSDoubleToStringNode doubleToStringNode) {
        return doubleToStringNode.executeString(value);
    }

    @HostCompilerDirectives.InliningCutoff
    @Specialization
    protected TruffleString doDouble(double d, @Cached.Shared @Cached JSDoubleToStringNode doubleToStringNode) {
        return doubleToStringNode.executeString(d);
    }

    @HostCompilerDirectives.InliningCutoff
    @Specialization(replaces={"doUndefined"})
    protected TruffleString doJSObject(JSDynamicObject value, @Cached.Shared @Cached JSToPrimitiveNode toPrimitiveHintStringNode, @Cached.Shared @Cached JSToStringNode toStringNode) {
        if (this.undefinedToEmpty && value == Undefined.instance) {
            return Strings.EMPTY_STRING;
        }
        return toStringNode.executeString(toPrimitiveHintStringNode.executeHintString(value));
    }

    @CompilerDirectives.TruffleBoundary
    @Specialization
    protected TruffleString doSymbol(Symbol value) {
        if (this.symbolToString) {
            return value.toTString();
        }
        throw Errors.createTypeErrorCannotConvertToString("a Symbol value", this);
    }

    @HostCompilerDirectives.InliningCutoff
    @Specialization(guards={"isForeignObject(object)"})
    protected TruffleString doTruffleObject(Object object, @Cached.Shared @Cached JSToPrimitiveNode toPrimitiveHintStringNode, @Cached.Shared @Cached JSToStringNode toStringNode) {
        return toStringNode.executeString(toPrimitiveHintStringNode.executeHintString(object));
    }

    @NeverDefault
    public static JSToStringNode getUncached() {
        return Uncached.INSTANCE;
    }

    static class Uncached
    extends JSToStringNode {
        static final Uncached INSTANCE = new Uncached();

        Uncached() {
        }

        @Override
        public TruffleString executeString(Object operand) {
            return JSRuntime.toString(operand);
        }
    }

    public static abstract class JSToStringWrapperNode
    extends JSUnaryNode {
        protected JSToStringWrapperNode(JavaScriptNode operand) {
            super(operand);
        }

        public static JSToStringWrapperNode create(JavaScriptNode child) {
            return JSToStringNodeGen.JSToStringWrapperNodeGen.create(child);
        }

        @Override
        public boolean isResultAlwaysOfType(Class<?> clazz) {
            return clazz == TruffleString.class;
        }

        @Specialization
        protected static Object doDefault(Object value, @Cached JSToStringNode toStringNode) {
            return toStringNode.executeString(value);
        }

        @Override
        protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
            return JSToStringNodeGen.JSToStringWrapperNodeGen.create(JSToStringWrapperNode.cloneUninitialized(this.getOperand(), materializedTags));
        }
    }
}

