/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.binary;

import java.util.Objects;
import java.util.Set;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.HostCompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Cached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.NeverDefault;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.instrumentation.InstrumentableNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.instrumentation.Tag;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.NodeInfo;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.InlinedConditionProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JavaScriptNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.JSConstantNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.binary.JSBitwiseAndConstantNodeGen;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.binary.JSBitwiseAndNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.binary.JSBitwiseAndNodeGen;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.binary.JSOverloadedBinaryNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.cast.JSToInt32Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.cast.JSToNumericNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.instrumentation.JSTags;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.unary.JSUnaryNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.BigInt;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Errors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRuntime;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.SafeInteger;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Strings;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSOverloadedOperatorsObject;

@NodeInfo(shortName="&")
public abstract class JSBitwiseAndConstantNode
extends JSUnaryNode {
    protected final boolean isInt;
    protected final int rightIntValue;
    protected final BigInt rightBigIntValue;

    protected JSBitwiseAndConstantNode(JavaScriptNode left, Object rightValue) {
        super(left);
        if (rightValue instanceof BigInt) {
            this.isInt = false;
            this.rightIntValue = 0;
            this.rightBigIntValue = (BigInt)rightValue;
        } else {
            this.isInt = true;
            this.rightIntValue = (Integer)rightValue;
            this.rightBigIntValue = null;
        }
    }

    public static JSBitwiseAndConstantNode create(JavaScriptNode left, Object right) {
        return JSBitwiseAndConstantNodeGen.create(left, right);
    }

    @Override
    public boolean hasTag(Class<? extends Tag> tag) {
        if (tag == JSTags.BinaryOperationTag.class) {
            return true;
        }
        return super.hasTag(tag);
    }

    @Override
    public InstrumentableNode materializeInstrumentableNodes(Set<Class<? extends Tag>> materializedTags) {
        if (materializedTags.contains(JSTags.BinaryOperationTag.class)) {
            JSConstantNode constantNode = JSConstantNode.create(this.isInt ? Integer.valueOf(this.rightIntValue) : this.rightBigIntValue);
            JSBitwiseAndNode node = JSBitwiseAndNodeGen.create(JSBitwiseAndConstantNode.cloneUninitialized(this.getOperand(), materializedTags), constantNode);
            JSBitwiseAndConstantNode.transferSourceSectionAddExpressionTag(this, constantNode);
            JSBitwiseAndConstantNode.transferSourceSectionAndTags(this, node);
            return node;
        }
        return this;
    }

    public abstract Object executeObject(Object var1);

    @Specialization(guards={"isInt"})
    protected int doInteger(int a) {
        return a & this.rightIntValue;
    }

    @Specialization(guards={"isInt"})
    protected int doSafeInteger(SafeInteger a) {
        return this.doInteger(a.intValue());
    }

    @Specialization(guards={"isInt"})
    protected int doDouble(double a, @Cached JSToInt32Node leftInt32) {
        return this.doInteger(leftInt32.executeInt(a));
    }

    @Specialization(guards={"!isInt"})
    protected void doIntegerThrows(int a) {
        throw Errors.createTypeErrorCannotMixBigIntWithOtherTypes(this);
    }

    @Specialization(guards={"!isInt"})
    protected void doDoubleThrows(double a) {
        throw Errors.createTypeErrorCannotMixBigIntWithOtherTypes(this);
    }

    @Specialization(guards={"isInt"})
    protected void doBigIntThrows(BigInt a) {
        throw Errors.createTypeErrorCannotMixBigIntWithOtherTypes(this);
    }

    @Specialization(guards={"!isInt"})
    protected BigInt doBigInt(BigInt a) {
        return a.and(this.rightBigIntValue);
    }

    @HostCompilerDirectives.InliningCutoff
    @Specialization
    protected Object doOverloaded(JSOverloadedOperatorsObject a, @Cached(value="createNumeric(getOverloadedOperatorName())") JSOverloadedBinaryNode overloadedOperatorNode) {
        return overloadedOperatorNode.execute(a, this.isInt ? Integer.valueOf(this.rightIntValue) : this.rightBigIntValue);
    }

    protected TruffleString getOverloadedOperatorName() {
        return Strings.SYMBOL_AMPERSAND;
    }

    @Specialization(guards={"!hasOverloadedOperators(a)", "isInt"}, replaces={"doInteger", "doSafeInteger", "doDouble", "doBigIntThrows"})
    protected Object doGeneric(Object a, @Cached @Cached.Shared JSToNumericNode toNumeric, @Cached @Cached.Shared InlinedConditionProfile profileIsBigInt, @Cached(value="makeCopy()") JavaScriptNode innerAndNode) {
        Object numericA = toNumeric.execute(a);
        if (profileIsBigInt.profile(this, JSRuntime.isBigInt(numericA))) {
            throw Errors.createTypeErrorCannotMixBigIntWithOtherTypes(this);
        }
        return ((JSBitwiseAndConstantNode)innerAndNode).executeObject(numericA);
    }

    @NeverDefault
    final JSBitwiseAndConstantNode makeCopy() {
        return JSBitwiseAndConstantNodeGen.create(null, this.isInt ? Integer.valueOf(this.rightIntValue) : this.rightBigIntValue);
    }

    @Specialization(guards={"!hasOverloadedOperators(a)", "!isInt"}, replaces={"doIntegerThrows", "doDoubleThrows", "doBigInt"})
    protected BigInt doGenericBigIntCase(Object a, @Cached @Cached.Shared JSToNumericNode toNumeric, @Cached @Cached.Shared InlinedConditionProfile profileIsBigInt) {
        Object numericA = toNumeric.execute(a);
        if (profileIsBigInt.profile(this, JSRuntime.isBigInt(numericA))) {
            return this.doBigInt((BigInt)numericA);
        }
        throw Errors.createTypeErrorCannotMixBigIntWithOtherTypes(this);
    }

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return JSBitwiseAndConstantNodeGen.create(JSBitwiseAndConstantNode.cloneUninitialized(this.getOperand(), materializedTags), this.isInt ? Integer.valueOf(this.rightIntValue) : this.rightBigIntValue);
    }

    @Override
    public String expressionToString() {
        if (this.getOperand() != null) {
            return "(" + Objects.toString(this.getOperand().expressionToString(), "(intermediate value)") + " & " + String.valueOf(this.isInt ? Integer.valueOf(this.rightIntValue) : this.rightBigIntValue.toString()) + ")";
        }
        return null;
    }
}

