/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.arguments;

import java.util.Set;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.frame.Frame;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.frame.VirtualFrame;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.instrumentation.Tag;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JavaScriptNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.RepeatableNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.ScopeFrameNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSArguments;

public final class AccessFrameArgumentNode
extends JavaScriptNode
implements RepeatableNode {
    @Node.Child
    private ScopeFrameNode accessFrame;
    private final int argIndex;

    private AccessFrameArgumentNode(ScopeFrameNode accessFrame, int argIndex) {
        this.accessFrame = accessFrame;
        this.argIndex = argIndex;
    }

    public static JavaScriptNode create(ScopeFrameNode accessFrame, int argIndex) {
        return new AccessFrameArgumentNode(accessFrame, argIndex);
    }

    @Override
    public Object execute(VirtualFrame frame) {
        Frame parentFrame = this.accessFrame.executeFrame(frame);
        Object arg = JSArguments.getUserArgument(parentFrame.getArguments(), this.argIndex);
        assert (arg != null);
        return arg;
    }

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return new AccessFrameArgumentNode(this.accessFrame, this.argIndex);
    }
}

