/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access;

import java.util.Set;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.frame.VirtualFrame;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.instrumentation.Tag;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.BranchProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JavaScriptNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.ReadNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.HasPropertyCacheNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.JSTargetableNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.PropertyNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.WriteNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.WritePropertyNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Errors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.Undefined;

public class WithVarWrapperNode
extends JSTargetableNode
implements ReadNode,
WriteNode {
    @Node.Child
    private JSTargetableNode withAccessNode;
    @Node.Child
    private JavaScriptNode globalDelegate;
    @Node.Child
    private JavaScriptNode withTarget;
    @Node.Child
    private HasPropertyCacheNode hasProperty;
    private final BranchProfile errorBranch = BranchProfile.create();
    private final JSContext context;
    private final TruffleString varName;
    private final boolean isStrict;

    protected WithVarWrapperNode(JSContext context, TruffleString varName, boolean isStrict, JavaScriptNode withTarget, JSTargetableNode withAccessNode, JavaScriptNode globalDelegate) {
        this.withAccessNode = withAccessNode;
        this.globalDelegate = globalDelegate;
        this.withTarget = withTarget;
        this.hasProperty = withAccessNode instanceof PropertyNode && !context.isOptionNashornCompatibilityMode() ? HasPropertyCacheNode.create(varName, context) : null;
        this.context = context;
        this.varName = varName;
        this.isStrict = isStrict;
    }

    public static JavaScriptNode create(JSContext context, TruffleString varName, boolean isStrict, JavaScriptNode withTarget, JSTargetableNode withAccessNode, JavaScriptNode globalDelegate) {
        return new WithVarWrapperNode(context, varName, isStrict, withTarget, withAccessNode, globalDelegate);
    }

    @Override
    public JavaScriptNode getTarget() {
        return this.withTarget;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        Object target = this.evaluateTarget(frame);
        return this.executeWithTarget(frame, target);
    }

    @Override
    public Object evaluateTarget(VirtualFrame frame) {
        return this.withTarget.execute(frame);
    }

    @Override
    public Object executeWithTarget(VirtualFrame frame, Object target) {
        if (target != Undefined.instance) {
            if (this.withAccessNode instanceof WritePropertyNode) {
                return ((WritePropertyNode)this.withAccessNode).executeWithValue(target, ((WriteNode)((Object)this.globalDelegate)).getRhs().execute(frame));
            }
            if (this.hasProperty == null || this.hasProperty.hasProperty(target)) {
                return this.withAccessNode.executeWithTarget(frame, target);
            }
            if (this.isStrict) {
                this.errorBranch.enter();
                throw Errors.createReferenceErrorNotDefined(this.varName, this);
            }
            return Undefined.instance;
        }
        return this.globalDelegate.execute(frame);
    }

    @Override
    public void executeWrite(VirtualFrame frame, Object value) {
        throw Errors.shouldNotReachHere();
    }

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return WithVarWrapperNode.create(this.context, this.varName, this.isStrict, WithVarWrapperNode.cloneUninitialized(this.withTarget, materializedTags), WithVarWrapperNode.cloneUninitialized(this.withAccessNode, materializedTags), WithVarWrapperNode.cloneUninitialized(this.globalDelegate, materializedTags));
    }

    @Override
    public JavaScriptNode getRhs() {
        return ((WriteNode)((Object)this.globalDelegate)).getRhs();
    }
}

