/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Cached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.NeverDefault;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object.HiddenKey;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.InlinedBranchProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.InlinedConditionProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.GetMethodNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.JSGetOwnPropertyNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.JSProxyPropertyGetNodeGen;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.binary.JSIdenticalNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.cast.JSToPropertyKeyNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Errors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSArguments;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRuntime;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSProxy;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSUncheckedProxyHandlerObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.interop.JSInteropUtil;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.Null;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.PropertyDescriptor;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.Undefined;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.util.JSClassProfile;

public abstract class JSProxyPropertyGetNode
extends JavaScriptBaseNode {
    @Node.Child
    protected GetMethodNode trapGet;
    @Node.Child
    private JSFunctionCallNode callNode = JSFunctionCallNode.createCall();
    @Node.Child
    private JSGetOwnPropertyNode getOwnPropertyNode;
    @Node.Child
    private JSIdenticalNode sameValueNode;

    protected JSProxyPropertyGetNode(JSContext context) {
        this.trapGet = GetMethodNode.create(context, JSProxy.GET);
    }

    @NeverDefault
    public static JSProxyPropertyGetNode create(JSContext context) {
        return JSProxyPropertyGetNodeGen.create(context);
    }

    public abstract Object executeWithReceiver(Object var1, Object var2, Object var3, Object var4);

    @Specialization
    protected Object doGeneric(JSDynamicObject proxy, Object receiver, Object key, Object defaultValue, @Cached JSToPropertyKeyNode toPropertyKeyNode, @Cached InlinedBranchProfile errorBranch, @Cached InlinedConditionProfile hasTrap, @Cached JSClassProfile targetClassProfile) {
        assert (JSProxy.isJSProxy(proxy));
        assert (!(key instanceof HiddenKey));
        Object propertyKey = toPropertyKeyNode.execute(key);
        if (JSRuntime.isPrivateSymbol(propertyKey)) {
            return Undefined.instance;
        }
        JSDynamicObject handler = JSProxy.getHandler(proxy);
        if (handler == Null.instance) {
            errorBranch.enter(this);
            throw Errors.createTypeErrorProxyRevoked(JSProxy.GET, this);
        }
        Object target = JSProxy.getTarget(proxy);
        Object trapFun = this.trapGet.executeWithTarget(handler);
        if (hasTrap.profile(this, trapFun == Undefined.instance)) {
            if (JSDynamicObject.isJSDynamicObject(target)) {
                return JSObject.getOrDefault((JSDynamicObject)target, propertyKey, receiver, defaultValue, targetClassProfile, (Node)this);
            }
            return JSInteropUtil.getOrDefault(this.getLanguage().getJSContext(), target, propertyKey, receiver, defaultValue);
        }
        Object trapResult = this.callNode.executeCall(JSArguments.create(handler, trapFun, target, propertyKey, receiver));
        if (!(handler instanceof JSUncheckedProxyHandlerObject)) {
            this.checkInvariants(propertyKey, target, trapResult, errorBranch);
        }
        return trapResult;
    }

    private void checkInvariants(Object propertyKey, Object proxyTarget, Object trapResult, @Cached InlinedBranchProfile errorBranch) {
        assert (JSRuntime.isPropertyKey(propertyKey));
        if (!JSDynamicObject.isJSDynamicObject(proxyTarget)) {
            return;
        }
        PropertyDescriptor targetDesc = this.getOwnProperty((JSDynamicObject)proxyTarget, propertyKey);
        if (targetDesc != null) {
            Object targetValue;
            if (targetDesc.isDataDescriptor() && !targetDesc.getConfigurable() && !targetDesc.getWritable() && !this.isSameValue(trapResult, targetValue = targetDesc.getValue())) {
                errorBranch.enter(this);
                throw Errors.createTypeErrorProxyGetInvariantViolated(propertyKey, targetValue, trapResult);
            }
            if (targetDesc.isAccessorDescriptor() && !targetDesc.getConfigurable() && targetDesc.getGet() == Undefined.instance && trapResult != Undefined.instance) {
                errorBranch.enter(this);
                throw Errors.createTypeError("Trap result must be undefined since the proxy target has a corresponding non-configurable own accessor property with undefined getter");
            }
        }
    }

    private boolean isSameValue(Object trapResult, Object value) {
        if (this.sameValueNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.sameValueNode = this.insert(JSIdenticalNode.createSameValue());
        }
        return this.sameValueNode.executeBoolean(trapResult, value);
    }

    private PropertyDescriptor getOwnProperty(JSDynamicObject target, Object propertyKey) {
        if (this.getOwnPropertyNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.getOwnPropertyNode = this.insert(JSGetOwnPropertyNode.create());
        }
        return this.getOwnPropertyNode.execute(target, propertyKey);
    }
}

