/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.library.CachedLibrary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object.DynamicObjectLibrary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object.Property;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.InitErrorObjectNodeFactory;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.InstallErrorCauseNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.PropertySetNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.function.CreateMethodPropertyNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Errors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.GraalJSException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Properties;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSError;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSErrorObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSAttributes;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSProperty;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.Undefined;

public final class InitErrorObjectNode
extends JavaScriptBaseNode {
    private final JSContext context;
    @Node.Child
    private PropertySetNode setException;
    @Node.Child
    private PropertySetNode setFormattedStack;
    @Node.Child
    private DynamicObjectLibrary setMessage;
    @Node.Child
    private DynamicObjectLibrary setErrors;
    @Node.Child
    private DefineStackPropertyNode defineStackProperty;
    private final boolean defaultColumnNumber;
    @Node.Child
    private CreateMethodPropertyNode setLineNumber;
    @Node.Child
    private CreateMethodPropertyNode setColumnNumber;
    @Node.Child
    private InstallErrorCauseNode installErrorCauseNode;

    private InitErrorObjectNode(JSContext context, boolean defaultColumnNumber) {
        this.context = context;
        this.setFormattedStack = PropertySetNode.createSetHidden(JSError.FORMATTED_STACK_NAME, context);
        this.setMessage = JSObjectUtil.createDispatched(JSError.MESSAGE);
        this.defineStackProperty = DefineStackPropertyNode.create();
        this.defaultColumnNumber = defaultColumnNumber;
        if (context.isOptionNashornCompatibilityMode()) {
            this.setLineNumber = CreateMethodPropertyNode.create(context, JSError.LINE_NUMBER_PROPERTY_NAME);
            this.setColumnNumber = CreateMethodPropertyNode.create(context, JSError.COLUMN_NUMBER_PROPERTY_NAME);
        }
    }

    public static InitErrorObjectNode create(JSContext context) {
        return new InitErrorObjectNode(context, false);
    }

    public static InitErrorObjectNode create(JSContext context, boolean defaultColumnNumber) {
        return new InitErrorObjectNode(context, defaultColumnNumber);
    }

    public JSObject execute(JSObject errorObj, GraalJSException exception, TruffleString messageOpt) {
        return this.execute(errorObj, exception, messageOpt, null);
    }

    public JSObject execute(JSObject errorObj, GraalJSException exception, TruffleString messageOpt, JSObject errorsOpt) {
        return this.execute(errorObj, exception, messageOpt, errorsOpt, Undefined.instance);
    }

    public JSObject execute(JSObject errorObj, GraalJSException exception, TruffleString messageOpt, JSObject errorsOpt, Object options) {
        if (messageOpt != null) {
            Properties.putWithFlags(this.setMessage, errorObj, JSError.MESSAGE, messageOpt, JSError.MESSAGE_ATTRIBUTES);
        }
        if (errorsOpt != null) {
            Properties.putWithFlags(this.setErrorsNode(), errorObj, JSError.ERRORS_NAME, errorsOpt, JSError.ERRORS_ATTRIBUTES);
        }
        if (this.context.getLanguageOptions().errorCause() && options != Undefined.instance) {
            this.installErrorCause(errorObj, options);
        }
        this.setException(errorObj, exception);
        this.setFormattedStack.setValue(errorObj, null);
        this.defineStackProperty.execute(errorObj);
        if (this.setLineNumber != null && exception.getJSStackTrace().length > 0) {
            GraalJSException.JSStackTraceElement topStackTraceElement = exception.getJSStackTrace()[0];
            this.setLineNumber.executeVoid(errorObj, topStackTraceElement.getLineNumber());
            this.setColumnNumber.executeVoid(errorObj, this.defaultColumnNumber ? -1 : topStackTraceElement.getColumnNumber());
        }
        return errorObj;
    }

    private void setException(JSObject errorObj, GraalJSException exception) {
        if (errorObj instanceof JSErrorObject) {
            JSErrorObject jsErrorObj = (JSErrorObject)errorObj;
            jsErrorObj.setException(exception);
        } else {
            if (this.setException == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.setException = this.insert(PropertySetNode.createSetHidden(JSError.EXCEPTION_PROPERTY_NAME, this.context));
            }
            this.setException.setValue(errorObj, exception);
        }
    }

    private void installErrorCause(JSObject errorObj, Object options) {
        if (this.installErrorCauseNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.installErrorCauseNode = this.insert(new InstallErrorCauseNode(this.context));
        }
        this.installErrorCauseNode.executeVoid(errorObj, options);
    }

    private DynamicObjectLibrary setErrorsNode() {
        DynamicObjectLibrary errorsLib = this.setErrors;
        if (errorsLib == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.setErrors = errorsLib = this.insert(JSObjectUtil.createDispatched(JSError.ERRORS_NAME));
        }
        return errorsLib;
    }

    public static abstract class DefineStackPropertyNode
    extends JavaScriptBaseNode {
        static DefineStackPropertyNode create() {
            return InitErrorObjectNodeFactory.DefineStackPropertyNodeGen.create();
        }

        abstract void execute(JSObject var1);

        @Specialization(limit="3")
        void doCached(JSObject errorObj, @CachedLibrary(value="errorObj") DynamicObjectLibrary objectLibrary) {
            Property stackProperty = Properties.getProperty(objectLibrary, errorObj, JSError.STACK_NAME);
            int attrs = JSAttributes.getDefaultNotEnumerable();
            if (stackProperty != null) {
                if (!JSProperty.isConfigurable(stackProperty)) {
                    throw Errors.createTypeErrorCannotRedefineProperty(JSError.STACK_NAME);
                }
                if (JSProperty.isEnumerable(stackProperty)) {
                    attrs = JSAttributes.getDefault();
                }
            }
            Properties.putConstant(objectLibrary, errorObj, JSError.STACK_NAME, JSError.STACK_PROXY, attrs | 0x10);
        }
    }
}

