/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access;

import java.util.Set;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Cached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.frame.VirtualFrame;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.instrumentation.Tag;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JavaScriptNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.ArrayLiteralNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.GetTemplateObjectNodeGen;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Boundaries;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Strings;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSArrayObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSAttributes;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSObjectUtil;

public abstract class GetTemplateObjectNode
extends JavaScriptNode {
    protected final JSContext context;
    @Node.Child
    private ArrayLiteralNode rawStrings;
    @Node.Child
    private ArrayLiteralNode cookedStrings;
    private final Object identity;

    protected GetTemplateObjectNode(JSContext context, ArrayLiteralNode rawStrings, ArrayLiteralNode cookedStrings) {
        this.context = context;
        this.rawStrings = rawStrings;
        this.cookedStrings = cookedStrings;
        this.identity = this;
    }

    protected GetTemplateObjectNode(JSContext context, ArrayLiteralNode rawStrings, ArrayLiteralNode cookedStrings, Object identity) {
        this.context = context;
        this.rawStrings = rawStrings;
        this.cookedStrings = cookedStrings;
        this.identity = identity;
    }

    public static GetTemplateObjectNode create(JSContext context, ArrayLiteralNode rawStrings, ArrayLiteralNode cookedStrings) {
        return GetTemplateObjectNodeGen.create(context, rawStrings, cookedStrings);
    }

    @Specialization(guards={"!context.isMultiContext()"}, assumptions={"context.getSingleRealmAssumption()"})
    protected JSDynamicObject doCached(VirtualFrame frame, @Cached(value="doUncached(frame)", neverDefault=true) JSDynamicObject cachedTemplate) {
        return cachedTemplate;
    }

    @Specialization(replaces={"doCached"})
    protected JSDynamicObject doUncached(VirtualFrame frame) {
        JSArrayObject cached = Boundaries.mapGet(this.getRealm().getTemplateRegistry(), this.identity);
        if (cached != null) {
            return cached;
        }
        cached = this.buildTemplateObject(frame);
        Boundaries.mapPut(this.getRealm().getTemplateRegistry(), this.identity, cached);
        return cached;
    }

    private JSArrayObject buildTemplateObject(VirtualFrame frame) {
        JSArrayObject template = this.cookedStrings.execute(frame);
        JSArrayObject rawObj = this.rawStrings.execute(frame);
        rawObj.setIntegrityLevel(true, true);
        JSObjectUtil.putDataProperty(template, Strings.RAW, rawObj, JSAttributes.notConfigurableNotEnumerableNotWritable());
        template.setIntegrityLevel(true, true);
        return template;
    }

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return GetTemplateObjectNodeGen.create(this.context, GetTemplateObjectNode.cloneUninitialized(this.rawStrings, materializedTags), GetTemplateObjectNode.cloneUninitialized(this.cookedStrings, materializedTags), this.identity);
    }
}

