/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Cached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object.DynamicObjectLibrary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.ErrorStackTraceLimitNodeGen;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.cast.IsNumberNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.cast.JSToIntegerAsLongNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSErrorType;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSError;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSFunctionObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSProperty;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.Undefined;

public abstract class ErrorStackTraceLimitNode
extends JavaScriptBaseNode {
    @Node.Child
    private DynamicObjectLibrary getStackTraceLimit = JSObjectUtil.createDispatched(JSError.STACK_TRACE_LIMIT_PROPERTY_NAME);

    protected ErrorStackTraceLimitNode() {
    }

    public static ErrorStackTraceLimitNode create() {
        return ErrorStackTraceLimitNodeGen.create();
    }

    @Specialization
    protected final int doInt(@Cached IsNumberNode isNumber, @Cached JSToIntegerAsLongNode toInteger) {
        JSContext context = this.getJSContext();
        if (context.getLanguageOptions().stackTraceAPI()) {
            Object value;
            JSFunctionObject errorConstructor = this.getRealm().getErrorConstructor(JSErrorType.Error);
            if (JSProperty.isData(this.getStackTraceLimit.getPropertyFlagsOrDefault(errorConstructor, JSError.STACK_TRACE_LIMIT_PROPERTY_NAME, 8)) && isNumber.execute(this, value = this.getStackTraceLimit.getOrDefault(errorConstructor, JSError.STACK_TRACE_LIMIT_PROPERTY_NAME, Undefined.instance))) {
                long limit = toInteger.executeLong(value);
                return (int)Math.max(0L, Math.min(limit, Integer.MAX_VALUE));
            }
            return 0;
        }
        return context.getLanguageOptions().stackTraceLimit();
    }

    public abstract int executeInt();
}

