/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.foreign;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Cached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.ImportStatic;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.InteropLibrary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.StopIterationException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.UnsupportedMessageException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.library.CachedLibrary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.InlinedBranchProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.foreign.ForeignIteratorPrototypeBuiltinsFactory;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.CreateIterResultObjectNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.function.JSBuiltin;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.interop.ImportValueNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Errors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSConfig;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.Undefined;

public final class ForeignIteratorPrototypeBuiltins
extends JSBuiltinsContainer.SwitchEnum<ForeignIteratorPrototype> {
    public static final JSBuiltinsContainer BUILTINS = new ForeignIteratorPrototypeBuiltins();

    protected ForeignIteratorPrototypeBuiltins() {
        super(null, ForeignIteratorPrototype.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, ForeignIteratorPrototype builtinEnum) {
        switch (builtinEnum.ordinal()) {
            case 0: {
                return ForeignIteratorPrototypeBuiltinsFactory.NextNodeGen.create(context, builtin, ForeignIteratorPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
        }
        return null;
    }

    public static enum ForeignIteratorPrototype implements BuiltinEnum<ForeignIteratorPrototype>
    {
        next(0);

        private final int length;

        private ForeignIteratorPrototype(int length) {
            this.length = length;
        }

        @Override
        public int getLength() {
            return this.length;
        }
    }

    @ImportStatic(value={JSConfig.class})
    public static abstract class NextNode
    extends JSBuiltinNode {
        public NextNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected JSObject next(Object target, @CachedLibrary(limit="InteropLibraryLimit") InteropLibrary interop, @Cached(value="create(getContext())") CreateIterResultObjectNode createIterResult, @Cached ImportValueNode importValue, @Cached InlinedBranchProfile errorBranch) {
            boolean hasNext;
            if (!interop.isIterator(target)) {
                errorBranch.enter(this);
                throw Errors.createTypeErrorNotIterator(target, this);
            }
            try {
                hasNext = interop.hasIteratorNextElement(target);
            }
            catch (UnsupportedMessageException umex) {
                errorBranch.enter(this);
                throw Errors.createTypeErrorInteropException(target, umex, "hasIteratorNextElement", null);
            }
            Object nextValue = Undefined.instance;
            if (hasNext) {
                try {
                    nextValue = importValue.executeWithTarget(interop.getIteratorNextElement(target));
                }
                catch (UnsupportedMessageException umex) {
                    errorBranch.enter(this);
                    throw Errors.createTypeErrorInteropException(target, umex, "getIteratorNextElement", null);
                }
                catch (StopIterationException siex) {
                    hasNext = false;
                }
            }
            return createIterResult.execute(nextValue, !hasNext);
        }
    }
}

